/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.StatisticTypeEnum;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Iterator;

public enum GoogleCloudStorageStatistics {
    EXCEPTION_COUNT("exception_count", "Counts the number of exceptions encountered", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_REQUEST_COUNT("gcs_api_total_request_count", "Counts the total number of gcs requests made", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_SIDE_ERROR_COUNT("gcs_api_client_side_error_count", "Counts the occurrence of client side error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_SIDE_ERROR_COUNT("gcs_api_server_side_error_count", "Counts the occurrence of server side error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_RATE_LIMIT_COUNT("gcs_api_client_rate_limit_error_count", "Counts the occurence of rate limit", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_BAD_REQUEST_COUNT("gcs_api_client_bad_request_count", "Counts the occurence of 400 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_UNAUTHORIZED_RESPONSE_COUNT("gcs_api_client_unauthorized_response_count", "Counts the occurence of 401 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_NOT_FOUND_RESPONSE_COUNT("gcs_api_client_non_found_response_count", "Counts the occurence of 404 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_REQUEST_TIMEOUT_COUNT("gcs_api_client_request_timeout_count", "Counts the occurence of 408 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_GONE_RESPONSE_COUNT("gcs_api_client_gone_response_count", "Counts the occurence of 410 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_PRECONDITION_FAILED_RESPONSE_COUNT("gcs_api_client_precondition_failed_response_count", "Counts the occurence of 412 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_REQUESTED_RANGE_NOT_SATISFIABLE_COUNT("gcs_api_client_requested_range_not_statisfiable_count", "Counts the occurence of 416 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_INTERNAL_ERROR_COUNT("gcs_api_server_internal_error_count", "Counts the occurrence of server side 500 error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_BAD_GATEWAY_COUNT("gcs_api_server_bad_gateway_count", "Counts the occurrence of server side 502 error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_SERVICE_UNAVAILABLE_COUNT("gcs_api_server_unavailable_count", "Counts the occurrence of server side 503 error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_TIMEOUT_COUNT("gcs_api_server_timeout_count", "Counts the occurrence of server side 504 error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_BACKOFF_TIME("gcs_backoff_time", "Total back off time in milliseconds", StatisticTypeEnum.TYPE_COUNTER),
    GCS_BACKOFF_COUNT("gcs_backoff_count", "Counts the number of times a request was retried after backing off due to some retriable response", StatisticTypeEnum.TYPE_COUNTER),
    GCS_EXCEPTION_COUNT("gcs_exception_count", "Counts the occurence of exception from GCS APIs", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_TIME("gcs_api_time", "Tracks the amount of time spend while calling GCS APIs.", StatisticTypeEnum.TYPE_COUNTER),
    GCS_METADATA_REQUEST("gcs_metadata_request", "Tracks GCS GET metadata API calls.", StatisticTypeEnum.TYPE_DURATION),
    GCS_GET_MEDIA_REQUEST("gcs_get_media_request", "Tracks GCS GET data API calls", StatisticTypeEnum.TYPE_DURATION),
    GCS_LIST_DIR_REQUEST("gcs_list_dir_request", "Tracks GCS GET list prefix API calls", StatisticTypeEnum.TYPE_DURATION),
    GCS_LIST_FILE_REQUEST("gcs_list_file_request", "Tracks GCS GET list file API calls. This is usually called with '/' as delimiter with some prefix and maxResults as 1", StatisticTypeEnum.TYPE_DURATION),
    GS_FILESYSTEM_CREATE("gs_filesystem_create", "Number of FileSystem objects created for 'gs' scheme", StatisticTypeEnum.TYPE_COUNTER),
    GCS_GET_OTHER_REQUEST("gcs_get_other_request", "Catch all metric of GCS GET API calls.", StatisticTypeEnum.TYPE_COUNTER),
    GS_FILESYSTEM_INITIALIZE("gs_filesystem_initialize", "Counts the filesystem initialize()", StatisticTypeEnum.TYPE_COUNTER);

    public static final ImmutableSet<GoogleCloudStorageStatistics> VALUES;
    private static final ImmutableMap<String, GoogleCloudStorageStatistics> SYMBOL_MAP;
    private final String symbol;
    private final String description;
    private final StatisticTypeEnum type;

    private GoogleCloudStorageStatistics(String symbol, String description, StatisticTypeEnum type) {
        this.symbol = symbol;
        this.description = description;
        this.type = type;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static GoogleCloudStorageStatistics fromSymbol(String symbol) {
        return (GoogleCloudStorageStatistics)((Object)SYMBOL_MAP.get((Object)symbol));
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.symbol;
    }

    public StatisticTypeEnum getType() {
        return this.type;
    }

    static {
        VALUES = ImmutableSet.copyOf(EnumSet.allOf(GoogleCloudStorageStatistics.class));
        SYMBOL_MAP = Maps.uniqueIndex((Iterator)Iterators.forArray((Object[])GoogleCloudStorageStatistics.values()), GoogleCloudStorageStatistics::getSymbol);
    }
}

