/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpResponse;
import com.google.api.services.storage.Storage;
import com.google.api.services.storage.model.StorageObject;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;

class StorageRequestFactory {
    private final Storage storage;

    StorageRequestFactory(Storage storage) {
        this.storage = storage;
    }

    ObjectsGetData objectsGetData(String bucketName, String objectName) {
        return new ObjectsGetData(this.storage.objects(), bucketName, objectName);
    }

    ObjectsGetMetadata objectsGetMetadata(String bucketName, String objectName) {
        return new ObjectsGetMetadata(this.storage.objects(), bucketName, objectName);
    }

    static class ObjectsGetMetadata
    extends Storage.Objects.Get {
        @VisibleForTesting
        private ObjectsGetMetadata(Storage.Objects objects, String bucket, String object) {
            Storage.Objects objects2 = objects;
            Objects.requireNonNull(objects2);
            super(objects2, bucket, object);
        }

        public HttpResponse executeMedia() {
            throw new WrongRequestTypeException("Shouldn't Call executeMedia on GetMetadata requests. ");
        }
    }

    static class ObjectsGetData
    extends Storage.Objects.Get {
        @VisibleForTesting
        private ObjectsGetData(Storage.Objects objects, String bucket, String object) {
            Storage.Objects objects2 = objects;
            Objects.requireNonNull(objects2);
            super(objects2, bucket, object);
        }

        public StorageObject execute() {
            throw new WrongRequestTypeException("Shouldn't Call execute on GetData requests. ");
        }
    }

    static class WrongRequestTypeException
    extends RuntimeException {
        WrongRequestTypeException(String message) {
            super(message);
        }
    }
}

