/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.cloud.hadoop.util.IGcsJsonApiEvent;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class GcsJsonApiEvent
implements IGcsJsonApiEvent {
    public static final String BACKOFF_TIME = "BACKOFF_TIME";
    public static final String RETRY_COUNT = "RETRY_COUNT";
    public static final String STATUS_CODE = "STATUS_CODE";
    public static final String DURATION = "DURATION";
    public static final String REQUEST_TYPE = "REQUEST_TYPE";
    private final EventType eventType;
    private final Object context;
    private final String method;
    private Map<String, Object> properties;

    @VisibleForTesting
    protected GcsJsonApiEvent(@Nonnull HttpRequest request, EventType eventType, Object context) {
        this.eventType = eventType;
        this.context = context;
        this.method = request.getRequestMethod();
    }

    private GcsJsonApiEvent(HttpRequest request, EventType eventType, int capacity, Object context) {
        this(request, eventType, context);
        this.properties = new HashMap<String, Object>(capacity, 1.0f);
    }

    @VisibleForTesting
    public static GcsJsonApiEvent getResponseEvent(HttpResponse httpResponse, @Nonnegative long duration, Object context) {
        GcsJsonApiEvent result = new GcsJsonApiEvent(httpResponse.getRequest(), EventType.RESPONSE, 3, context);
        result.set(STATUS_CODE, httpResponse.getStatusCode());
        result.set(DURATION, duration);
        result.set(REQUEST_TYPE, (Object)GcsJsonApiEvent.getRequestType(httpResponse));
        return result;
    }

    static GcsJsonApiEvent getRequestStartedEvent(HttpRequest request, Object context) {
        return new GcsJsonApiEvent(request, EventType.STARTED, context);
    }

    static GcsJsonApiEvent getExceptionEvent(HttpRequest httpRequest, Object context) {
        return new GcsJsonApiEvent(httpRequest, EventType.EXCEPTION, context);
    }

    static GcsJsonApiEvent getBackoffEvent(HttpRequest request, @Nonnegative long backOffTime, @Nonnegative int retryCount, Object context) {
        return new GcsJsonApiEvent(request, EventType.BACKOFF, 2, context).set(BACKOFF_TIME, backOffTime).set(RETRY_COUNT, retryCount);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Object getProperty(String key) {
        return this.properties == null ? null : this.properties.get(key);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("method", (Object)this.method).add("type", (Object)this.eventType).add("properties", this.properties).add("context", this.context).toString();
    }

    private GcsJsonApiEvent set(String key, Object value) {
        Preconditions.checkArgument((this.properties != null ? 1 : 0) != 0, (Object)"properties cannot be null");
        this.properties.put(key, value);
        return this;
    }

    private static RequestType getRequestType(HttpResponse httpResponse) {
        HttpRequest request = httpResponse.getRequest();
        String method = request.getRequestMethod();
        if ("GET".equals(method)) {
            GenericUrl url = request.getUrl();
            Object maxResult = url.getFirst("maxResults");
            if (maxResult != null) {
                String maxResultString = maxResult.toString();
                if ("1".equals(maxResultString)) {
                    return RequestType.LIST_FILE;
                }
                return RequestType.LIST_DIR;
            }
            Object fields = url.getFirst("fields");
            if (fields != null && fields.toString().contains("metadata")) {
                return RequestType.GET_METADATA;
            }
            Object alt = url.getFirst("alt");
            if (alt != null && "media".equals(alt.toString())) {
                return RequestType.GET_MEDIA;
            }
            return RequestType.GET_OTHER;
        }
        if ("DELETE".equals(method)) {
            return RequestType.DELETE;
        }
        if ("PUT".equals(method)) {
            return RequestType.PUT;
        }
        if ("POST".equals(method)) {
            return RequestType.POST;
        }
        if ("PATCH".equals(method)) {
            return RequestType.PATCH;
        }
        return RequestType.OTHER;
    }

    public static enum RequestType {
        DELETE,
        GET_MEDIA,
        GET_METADATA,
        GET_OTHER,
        LIST_DIR,
        LIST_FILE,
        OTHER,
        PATCH,
        POST,
        PUT;

    }

    public static enum EventType {
        BACKOFF,
        EXCEPTION,
        RESPONSE,
        RETRY_SKIPPED,
        STARTED;

    }
}

