/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.cloud.hadoop.util.RedactedString;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.time.Duration;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpTransportFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    public static HttpTransport createHttpTransport() throws IOException {
        return HttpTransportFactory.createHttpTransport(null, null, null);
    }

    public static HttpTransport createHttpTransport(@Nullable String proxyAddress, @Nullable RedactedString proxyUsername, @Nullable RedactedString proxyPassword) throws IOException {
        return HttpTransportFactory.createHttpTransport(proxyAddress, proxyUsername, proxyPassword, null);
    }

    public static HttpTransport createHttpTransport(@Nullable String proxyAddress, @Nullable RedactedString proxyUsername, @Nullable RedactedString proxyPassword, @Nullable Duration readTimeout) throws IOException {
        ((GoogleLogger.Api)logger.atFiner()).log("createHttpTransport(%s, %s, %s, %s)", (Object)proxyAddress, (Object)proxyUsername, (Object)proxyPassword, (Object)readTimeout);
        Preconditions.checkArgument((proxyAddress != null || proxyUsername == null && proxyPassword == null ? 1 : 0) != 0, (Object)"if proxyAddress is null then proxyUsername and proxyPassword should be null too");
        Preconditions.checkArgument((proxyUsername == null == (proxyPassword == null) ? 1 : 0) != 0, (Object)"both proxyUsername and proxyPassword should be null or not null together");
        URI proxyUri = HttpTransportFactory.parseProxyAddress(proxyAddress);
        try {
            PasswordAuthentication proxyAuth = proxyUsername != null ? new PasswordAuthentication(proxyUsername.value(), proxyPassword.value().toCharArray()) : null;
            return HttpTransportFactory.createNetHttpTransport(proxyUri, proxyAuth, readTimeout);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public static NetHttpTransport createNetHttpTransport(final @Nullable URI proxyUri, final @Nullable PasswordAuthentication proxyAuth, @Nullable Duration readTimeout) throws IOException, GeneralSecurityException {
        Preconditions.checkArgument((proxyUri != null || proxyAuth == null ? 1 : 0) != 0, (Object)"if proxyUri is null than proxyAuth should be null too");
        if (proxyAuth != null) {
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            Authenticator.setDefault(new Authenticator(){

                @Override
                @Nullable
                protected PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(proxyUri.getHost()) && this.getRequestingPort() == proxyUri.getPort()) {
                        return proxyAuth;
                    }
                    return null;
                }
            });
        }
        return HttpTransportFactory.createNetHttpTransportBuilder(proxyUri, readTimeout).build();
    }

    @VisibleForTesting
    static NetHttpTransport.Builder createNetHttpTransportBuilder(@Nullable URI proxyUri, @Nullable Duration readTimeout) throws IOException, GeneralSecurityException {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder().trustCertificates(GoogleUtils.getCertificateTrustStore());
        SSLSocketFactory wrappedSslSocketFactory = Objects.requireNonNullElseGet(builder.getSslSocketFactory(), HttpsURLConnection::getDefaultSSLSocketFactory);
        return builder.setSslSocketFactory((SSLSocketFactory)new CustomSslSocketFactory(wrappedSslSocketFactory, readTimeout)).setProxy(proxyUri == null ? null : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyUri.getPort())));
    }

    @VisibleForTesting
    static URI parseProxyAddress(@Nullable String proxyAddress) {
        if (Strings.isNullOrEmpty((String)proxyAddress)) {
            return null;
        }
        String uriString = (proxyAddress.contains("//") ? "" : "//") + proxyAddress;
        try {
            URI uri = new URI(uriString);
            String scheme = uri.getScheme();
            String host = uri.getHost();
            int port = uri.getPort();
            Preconditions.checkArgument((Strings.isNullOrEmpty((String)scheme) || scheme.matches("https?") ? 1 : 0) != 0, (String)"HTTP proxy address '%s' has invalid scheme '%s'.", (Object)proxyAddress, (Object)scheme);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)host) ? 1 : 0) != 0, (String)"Proxy address '%s' has no host.", (Object)proxyAddress);
            Preconditions.checkArgument((port != -1 ? 1 : 0) != 0, (String)"Proxy address '%s' has no port.", (Object)proxyAddress);
            Preconditions.checkArgument((boolean)uri.equals(new URI(scheme, null, host, port, null, null, null)), (String)"Invalid proxy address '%s'.", (Object)proxyAddress);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid proxy address '%s'.", proxyAddress), e);
        }
    }

    @VisibleForTesting
    static final class CustomSslSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory wrappedSockedFactory;
        private final Integer readTimeoutMillis;

        public CustomSslSocketFactory(SSLSocketFactory wrappedSocketFactory, Duration readTimeout) {
            this.wrappedSockedFactory = wrappedSocketFactory;
            this.readTimeoutMillis = readTimeout != null ? Integer.valueOf(Math.toIntExact(readTimeout.toMillis())) : null;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.wrappedSockedFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.wrappedSockedFactory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.customizeSocket(this.wrappedSockedFactory.createSocket());
        }

        @Override
        public Socket createSocket(Socket s, InputStream consumed, boolean autoClose) throws IOException {
            return this.customizeSocket(this.wrappedSockedFactory.createSocket(s, consumed, autoClose));
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.customizeSocket(this.wrappedSockedFactory.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.customizeSocket(this.wrappedSockedFactory.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress address, int port) throws IOException {
            return this.customizeSocket(this.wrappedSockedFactory.createSocket(address, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress clientAddress, int clientPort) throws IOException {
            return this.customizeSocket(this.wrappedSockedFactory.createSocket(host, port, clientAddress, clientPort));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
            return this.customizeSocket(this.wrappedSockedFactory.createSocket(address, port, clientAddress, clientPort));
        }

        private Socket customizeSocket(Socket socket) throws SocketException {
            socket.setKeepAlive(true);
            if (this.readTimeoutMillis != null) {
                socket.setSoTimeout(this.readTimeoutMillis);
            }
            return socket;
        }
    }
}

