/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchingDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchingSettings;
import com.google.bigtable.repackaged.com.google.api.gax.batching.DynamicFlowControlSettings;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowControlSettings;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsAttemptResult;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@BetaApi(value="This surface is likely to change as the batching surface evolves.")
public final class BigtableBatchingCallSettings
extends UnaryCallSettings<BulkMutation, MutateRowsAttemptResult> {
    private final BatchingCallSettings<RowMutationEntry, Void, BulkMutation, MutateRowsAttemptResult> batchingCallSettings;
    private final boolean isLatencyBasedThrottlingEnabled;
    private final Long targetRpcLatencyMs;
    private final DynamicFlowControlSettings dynamicFlowControlSettings;
    private final boolean isServerInitiatedFlowControlEnabled;

    private BigtableBatchingCallSettings(Builder builder) {
        super(builder);
        this.batchingCallSettings = ((BatchingCallSettings.Builder)((BatchingCallSettings.Builder)BatchingCallSettings.newBuilder(builder.batchingDescriptor).setBatchingSettings(builder.batchingSettings).setRetrySettings(builder.getRetrySettings())).setRetryableCodes((Set)builder.getRetryableCodes())).build();
        this.isLatencyBasedThrottlingEnabled = builder.isLatencyBasedThrottlingEnabled;
        this.targetRpcLatencyMs = builder.targetRpcLatencyMs;
        this.dynamicFlowControlSettings = builder.dynamicFlowControlSettings;
        this.isServerInitiatedFlowControlEnabled = builder.isServerInitiatedFlowControlEnabled;
    }

    public BatchingSettings getBatchingSettings() {
        return this.batchingCallSettings.getBatchingSettings();
    }

    BatchingDescriptor<RowMutationEntry, Void, BulkMutation, MutateRowsAttemptResult> getBatchingDescriptor() {
        return this.batchingCallSettings.getBatchingDescriptor();
    }

    public boolean isLatencyBasedThrottlingEnabled() {
        return this.isLatencyBasedThrottlingEnabled;
    }

    @Nullable
    public Long getTargetRpcLatencyMs() {
        return this.targetRpcLatencyMs;
    }

    DynamicFlowControlSettings getDynamicFlowControlSettings() {
        return this.dynamicFlowControlSettings;
    }

    @InternalApi(value="Intended for use by the Bigtable dataflow connectors only")
    public boolean isServerInitiatedFlowControlEnabled() {
        return this.isServerInitiatedFlowControlEnabled;
    }

    static Builder newBuilder(BatchingDescriptor<RowMutationEntry, Void, BulkMutation, MutateRowsAttemptResult> batchingDescriptor) {
        return new Builder(batchingDescriptor);
    }

    public final Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("batchingCallSettings", this.batchingCallSettings).add("isLatencyBasedThrottlingEnabled", this.isLatencyBasedThrottlingEnabled).add("targetRpcLatency", this.targetRpcLatencyMs).add("dynamicFlowControlSettings", this.dynamicFlowControlSettings).add("isServerInitiatedFlowControlEnabled", this.isServerInitiatedFlowControlEnabled).toString();
    }

    public static class Builder
    extends UnaryCallSettings.Builder<BulkMutation, MutateRowsAttemptResult> {
        private BatchingDescriptor<RowMutationEntry, Void, BulkMutation, MutateRowsAttemptResult> batchingDescriptor;
        private BatchingSettings batchingSettings;
        private boolean isLatencyBasedThrottlingEnabled;
        private Long targetRpcLatencyMs;
        private DynamicFlowControlSettings dynamicFlowControlSettings;
        private boolean isServerInitiatedFlowControlEnabled;

        private Builder(@Nonnull BatchingDescriptor<RowMutationEntry, Void, BulkMutation, MutateRowsAttemptResult> batchingDescriptor) {
            this.batchingDescriptor = Preconditions.checkNotNull(batchingDescriptor, "batching descriptor can't be null");
        }

        private Builder(@Nonnull BigtableBatchingCallSettings settings) {
            super(settings);
            this.batchingDescriptor = settings.getBatchingDescriptor();
            this.batchingSettings = settings.getBatchingSettings();
            this.isLatencyBasedThrottlingEnabled = settings.isLatencyBasedThrottlingEnabled();
            this.targetRpcLatencyMs = settings.getTargetRpcLatencyMs();
            this.dynamicFlowControlSettings = settings.getDynamicFlowControlSettings();
            this.isServerInitiatedFlowControlEnabled = settings.isServerInitiatedFlowControlEnabled();
        }

        public Builder setBatchingSettings(@Nonnull BatchingSettings batchingSettings) {
            Preconditions.checkNotNull(batchingSettings, "batching settings can't be null");
            this.batchingSettings = batchingSettings;
            return this;
        }

        public BatchingSettings getBatchingSettings() {
            return this.batchingSettings;
        }

        public Builder setRetryableCodes(StatusCode.Code ... codes) {
            super.setRetryableCodes(codes);
            return this;
        }

        public Builder setRetryableCodes(Set<StatusCode.Code> retryableCodes) {
            super.setRetryableCodes(retryableCodes);
            return this;
        }

        public Builder setRetrySettings(@Nonnull RetrySettings retrySettings) {
            super.setRetrySettings(retrySettings);
            return this;
        }

        public Builder enableLatencyBasedThrottling(long targetRpcLatency) {
            Preconditions.checkArgument(targetRpcLatency > 0L, "target RPC latency must be greater than 0");
            this.isLatencyBasedThrottlingEnabled = true;
            this.targetRpcLatencyMs = targetRpcLatency;
            return this;
        }

        public Builder disableLatencyBasedThrottling() {
            this.isLatencyBasedThrottlingEnabled = false;
            this.targetRpcLatencyMs = null;
            return this;
        }

        @Nullable
        public Long getTargetRpcLatencyMs() {
            return this.isLatencyBasedThrottlingEnabled ? this.targetRpcLatencyMs : null;
        }

        public boolean isLatencyBasedThrottlingEnabled() {
            return this.isLatencyBasedThrottlingEnabled;
        }

        DynamicFlowControlSettings getDynamicFlowControlSettings() {
            return this.dynamicFlowControlSettings;
        }

        @InternalApi(value="Intended for use by the Bigtable dataflow connectors only")
        public Builder setServerInitiatedFlowControl(boolean isEnable) {
            this.isServerInitiatedFlowControlEnabled = isEnable;
            return this;
        }

        @InternalApi(value="Intended for use by the Bigtable dataflow connectors only")
        public boolean isServerInitiatedFlowControlEnabled() {
            return this.isServerInitiatedFlowControlEnabled;
        }

        public BigtableBatchingCallSettings build() {
            Preconditions.checkState(this.batchingSettings != null, "batchingSettings must be set");
            FlowControlSettings flowControlSettings = this.batchingSettings.getFlowControlSettings();
            Preconditions.checkState(flowControlSettings.getMaxOutstandingElementCount() != null, "maxOutstandingElementCount must be set in BatchingSettings#FlowControlSettings");
            Preconditions.checkState(flowControlSettings.getMaxOutstandingRequestBytes() != null, "maxOutstandingRequestBytes must be set in BatchingSettings#FlowControlSettings");
            Preconditions.checkArgument(this.batchingSettings.getElementCountThreshold() == null || flowControlSettings.getMaxOutstandingElementCount() > this.batchingSettings.getElementCountThreshold(), "if batch elementCountThreshold is set in BatchingSettings, flow control maxOutstandingElementCount must be > elementCountThreshold");
            Preconditions.checkArgument(this.batchingSettings.getRequestByteThreshold() == null || flowControlSettings.getMaxOutstandingRequestBytes() > this.batchingSettings.getRequestByteThreshold(), "if batch requestByteThreshold is set in BatchingSettings, flow control maxOutstandingRequestBytes must be > getRequestByteThreshold");
            if (this.isLatencyBasedThrottlingEnabled()) {
                long maxThrottlingElementCount = flowControlSettings.getMaxOutstandingElementCount();
                long maxThrottlingRequestByteCount = flowControlSettings.getMaxOutstandingRequestBytes();
                long initialElementCount = maxThrottlingElementCount / 4L;
                long minElementCount = maxThrottlingElementCount / 100L;
                if (this.batchingSettings.getElementCountThreshold() != null) {
                    initialElementCount = Math.max(initialElementCount, this.batchingSettings.getElementCountThreshold());
                    minElementCount = Math.max(minElementCount, this.batchingSettings.getElementCountThreshold());
                }
                this.dynamicFlowControlSettings = DynamicFlowControlSettings.newBuilder().setLimitExceededBehavior(flowControlSettings.getLimitExceededBehavior()).setInitialOutstandingElementCount(initialElementCount).setMaxOutstandingElementCount(maxThrottlingElementCount).setMinOutstandingElementCount(minElementCount).setInitialOutstandingRequestBytes(maxThrottlingRequestByteCount).setMinOutstandingRequestBytes(maxThrottlingRequestByteCount).setMaxOutstandingRequestBytes(maxThrottlingRequestByteCount).build();
            } else {
                this.dynamicFlowControlSettings = DynamicFlowControlSettings.newBuilder().setLimitExceededBehavior(flowControlSettings.getLimitExceededBehavior()).setInitialOutstandingElementCount(flowControlSettings.getMaxOutstandingElementCount()).setMaxOutstandingElementCount(flowControlSettings.getMaxOutstandingElementCount()).setMinOutstandingElementCount(flowControlSettings.getMaxOutstandingElementCount()).setInitialOutstandingRequestBytes(flowControlSettings.getMaxOutstandingRequestBytes()).setMinOutstandingRequestBytes(flowControlSettings.getMaxOutstandingRequestBytes()).setMaxOutstandingRequestBytes(flowControlSettings.getMaxOutstandingRequestBytes()).build();
            }
            return new BigtableBatchingCallSettings(this);
        }
    }
}

