/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.monitoring.v3;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.bigtable.repackaged.com.google.api.gax.paging.AbstractPage;
import com.google.bigtable.repackaged.com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PageContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.QueryServiceSettings;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.QueryServiceStub;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.stub.QueryServiceStubSettings;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.monitoring.v3.QueryTimeSeriesRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.QueryTimeSeriesResponse;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeriesData;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class QueryServiceClient
implements BackgroundResource {
    private final QueryServiceSettings settings;
    private final QueryServiceStub stub;

    public static final QueryServiceClient create() throws IOException {
        return QueryServiceClient.create(QueryServiceSettings.newBuilder().build());
    }

    public static final QueryServiceClient create(QueryServiceSettings settings) throws IOException {
        return new QueryServiceClient(settings);
    }

    public static final QueryServiceClient create(QueryServiceStub stub) {
        return new QueryServiceClient(stub);
    }

    protected QueryServiceClient(QueryServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((QueryServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected QueryServiceClient(QueryServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final QueryServiceSettings getSettings() {
        return this.settings;
    }

    public QueryServiceStub getStub() {
        return this.stub;
    }

    public final QueryTimeSeriesPagedResponse queryTimeSeries(QueryTimeSeriesRequest request) {
        return this.queryTimeSeriesPagedCallable().call(request);
    }

    public final UnaryCallable<QueryTimeSeriesRequest, QueryTimeSeriesPagedResponse> queryTimeSeriesPagedCallable() {
        return this.stub.queryTimeSeriesPagedCallable();
    }

    public final UnaryCallable<QueryTimeSeriesRequest, QueryTimeSeriesResponse> queryTimeSeriesCallable() {
        return this.stub.queryTimeSeriesCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class QueryTimeSeriesFixedSizeCollection
    extends AbstractFixedSizeCollection<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData, QueryTimeSeriesPage, QueryTimeSeriesFixedSizeCollection> {
        private QueryTimeSeriesFixedSizeCollection(List<QueryTimeSeriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static QueryTimeSeriesFixedSizeCollection createEmptyCollection() {
            return new QueryTimeSeriesFixedSizeCollection(null, 0);
        }

        @Override
        protected QueryTimeSeriesFixedSizeCollection createCollection(List<QueryTimeSeriesPage> pages, int collectionSize) {
            return new QueryTimeSeriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class QueryTimeSeriesPage
    extends AbstractPage<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData, QueryTimeSeriesPage> {
        private QueryTimeSeriesPage(PageContext<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> context, QueryTimeSeriesResponse response) {
            super(context, response);
        }

        private static QueryTimeSeriesPage createEmptyPage() {
            return new QueryTimeSeriesPage(null, null);
        }

        @Override
        protected QueryTimeSeriesPage createPage(PageContext<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> context, QueryTimeSeriesResponse response) {
            return new QueryTimeSeriesPage(context, response);
        }

        @Override
        public ApiFuture<QueryTimeSeriesPage> createPageAsync(PageContext<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> context, ApiFuture<QueryTimeSeriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class QueryTimeSeriesPagedResponse
    extends AbstractPagedListResponse<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData, QueryTimeSeriesPage, QueryTimeSeriesFixedSizeCollection> {
        public static ApiFuture<QueryTimeSeriesPagedResponse> createAsync(PageContext<QueryTimeSeriesRequest, QueryTimeSeriesResponse, TimeSeriesData> context, ApiFuture<QueryTimeSeriesResponse> futureResponse) {
            ApiFuture<QueryTimeSeriesPage> futurePage = QueryTimeSeriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new QueryTimeSeriesPagedResponse((QueryTimeSeriesPage)input), MoreExecutors.directExecutor());
        }

        private QueryTimeSeriesPagedResponse(QueryTimeSeriesPage page) {
            super(page, QueryTimeSeriesFixedSizeCollection.createEmptyCollection());
        }
    }
}

