/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.alts.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Optional;
import com.google.bigtable.repackaged.io.grpc.alts.internal.HandshakerReq;
import com.google.bigtable.repackaged.io.grpc.alts.internal.HandshakerResp;
import com.google.bigtable.repackaged.io.grpc.alts.internal.HandshakerServiceGrpc;
import com.google.bigtable.repackaged.io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

class AltsHandshakerStub {
    private final StreamObserver<HandshakerResp> reader = new Reader();
    private StreamObserver<HandshakerReq> writer;
    private final HandshakerServiceGrpc.HandshakerServiceStub serviceStub;
    private final ArrayBlockingQueue<Optional<HandshakerResp>> responseQueue = new ArrayBlockingQueue(1);
    private final AtomicReference<ThrowableInfo> exceptionMessage = new AtomicReference();
    private static final long HANDSHAKE_RPC_DEADLINE_SECS = 20L;

    AltsHandshakerStub(HandshakerServiceGrpc.HandshakerServiceStub serviceStub) {
        this.serviceStub = serviceStub;
    }

    @VisibleForTesting
    AltsHandshakerStub() {
        this.serviceStub = null;
    }

    @VisibleForTesting
    AltsHandshakerStub(StreamObserver<HandshakerReq> writer) {
        this.writer = writer;
        this.serviceStub = null;
    }

    @VisibleForTesting
    StreamObserver<HandshakerResp> getReaderForTest() {
        return this.reader;
    }

    public HandshakerResp send(HandshakerReq req) throws InterruptedException, IOException {
        this.createWriterIfNull();
        this.maybeThrowIoException();
        if (!this.responseQueue.isEmpty()) {
            throw new IOException("Received an unexpected response.");
        }
        this.writer.onNext(req);
        Optional<HandshakerResp> result = this.responseQueue.take();
        if (result.isPresent()) {
            return result.get();
        }
        if (this.exceptionMessage.get() != null) {
            throw new IOException(this.exceptionMessage.get().info, this.exceptionMessage.get().throwable);
        }
        throw new IOException("No handshaker response received");
    }

    private void createWriterIfNull() {
        if (this.writer == null) {
            this.writer = ((HandshakerServiceGrpc.HandshakerServiceStub)this.serviceStub.withDeadlineAfter(20L, TimeUnit.SECONDS)).doHandshake(this.reader);
        }
    }

    private void maybeThrowIoException() throws IOException {
        if (this.exceptionMessage.get() != null) {
            throw new IOException(this.exceptionMessage.get().info, this.exceptionMessage.get().throwable);
        }
    }

    public void close() {
        if (this.writer != null) {
            this.writer.onCompleted();
        }
    }

    private static class ThrowableInfo {
        private final Throwable throwable;
        private final String info;

        private ThrowableInfo(Throwable throwable, String info) {
            this.throwable = throwable;
            this.info = info;
        }
    }

    private class Reader
    implements StreamObserver<HandshakerResp> {
        private Reader() {
        }

        @Override
        public void onNext(HandshakerResp resp) {
            try {
                AltsHandshakerStub.this.responseQueue.add(Optional.of(resp));
            }
            catch (IllegalStateException e) {
                AltsHandshakerStub.this.exceptionMessage.compareAndSet(null, new ThrowableInfo(e, "Received an unexpected response."));
                AltsHandshakerStub.this.close();
            }
        }

        @Override
        public void onError(Throwable t) {
            AltsHandshakerStub.this.exceptionMessage.compareAndSet(null, new ThrowableInfo(t, "Received a terminating error."));
            Optional result = Optional.absent();
            AltsHandshakerStub.this.responseQueue.offer(result);
        }

        @Override
        public void onCompleted() {
            AltsHandshakerStub.this.exceptionMessage.compareAndSet(null, new ThrowableInfo(null, "Response stream closed."));
            Optional result = Optional.absent();
            AltsHandshakerStub.this.responseQueue.offer(result);
        }
    }
}

