/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.io.grpc.ConnectivityState;
import com.google.bigtable.repackaged.io.grpc.ConnectivityStateInfo;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import com.google.bigtable.repackaged.io.grpc.EquivalentAddressGroup;
import com.google.bigtable.repackaged.io.grpc.ExperimentalApi;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.LoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.SynchronizationContext;
import com.google.bigtable.repackaged.io.grpc.services.MetricReport;
import com.google.bigtable.repackaged.io.grpc.util.ForwardingLoadBalancerHelper;
import com.google.bigtable.repackaged.io.grpc.util.ForwardingSubchannel;
import com.google.bigtable.repackaged.io.grpc.util.MultiChildLoadBalancer;
import com.google.bigtable.repackaged.io.grpc.util.RoundRobinLoadBalancer;
import com.google.bigtable.repackaged.io.grpc.xds.orca.OrcaOobUtil;
import com.google.bigtable.repackaged.io.grpc.xds.orca.OrcaPerRequestUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9885")
final class WeightedRoundRobinLoadBalancer
extends RoundRobinLoadBalancer {
    private static final Logger log = Logger.getLogger(WeightedRoundRobinLoadBalancer.class.getName());
    private WeightedRoundRobinLoadBalancerConfig config;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private SynchronizationContext.ScheduledHandle weightUpdateTimer;
    private final Runnable updateWeightTask;
    private final AtomicInteger sequence;
    private final long infTime;
    private final Deadline.Ticker ticker;

    public WeightedRoundRobinLoadBalancer(LoadBalancer.Helper helper, Deadline.Ticker ticker) {
        this(new WrrHelper(OrcaOobUtil.newOrcaReportingHelper(helper)), ticker, new Random());
    }

    public WeightedRoundRobinLoadBalancer(WrrHelper helper, Deadline.Ticker ticker, Random random) {
        super(helper);
        helper.setLoadBalancer(this);
        this.ticker = Preconditions.checkNotNull(ticker, "ticker");
        this.infTime = ticker.nanoTime() + Long.MAX_VALUE;
        this.syncContext = Preconditions.checkNotNull(helper.getSynchronizationContext(), "syncContext");
        this.timeService = Preconditions.checkNotNull(helper.getScheduledExecutorService(), "timeService");
        this.updateWeightTask = new UpdateWeightTask();
        this.sequence = new AtomicInteger(random.nextInt());
        log.log(Level.FINE, "weighted_round_robin LB created");
    }

    @VisibleForTesting
    WeightedRoundRobinLoadBalancer(LoadBalancer.Helper helper, Deadline.Ticker ticker, Random random) {
        this(new WrrHelper(OrcaOobUtil.newOrcaReportingHelper(helper)), ticker, random);
    }

    @Override
    protected MultiChildLoadBalancer.ChildLbState createChildLbState(Object key, Object policyConfig, LoadBalancer.SubchannelPicker initialPicker, LoadBalancer.ResolvedAddresses unused) {
        WeightedChildLbState childLbState = new WeightedChildLbState(key, this.pickFirstLbProvider, policyConfig, initialPicker);
        return childLbState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        MultiChildLoadBalancer.AcceptResolvedAddressRetVal acceptRetVal;
        if (resolvedAddresses.getLoadBalancingPolicyConfig() == null) {
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned no WeightedRoundRobinLoadBalancerConfig. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes());
            this.handleNameResolutionError(unavailableStatus);
            return unavailableStatus;
        }
        this.config = (WeightedRoundRobinLoadBalancerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        try {
            this.resolvingAddresses = true;
            acceptRetVal = this.acceptResolvedAddressesInternal(resolvedAddresses);
            if (!acceptRetVal.status.isOk()) {
                Status status = acceptRetVal.status;
                return status;
            }
            if (this.weightUpdateTimer != null && this.weightUpdateTimer.isPending()) {
                this.weightUpdateTimer.cancel();
            }
            this.updateWeightTask.run();
            this.createAndApplyOrcaListeners();
            this.updateOverallBalancingState();
            this.shutdownRemoved(acceptRetVal.removedChildren);
        }
        finally {
            this.resolvingAddresses = false;
        }
        return acceptRetVal.status;
    }

    @Override
    public LoadBalancer.SubchannelPicker createReadyPicker(Collection<MultiChildLoadBalancer.ChildLbState> activeList) {
        return new WeightedRoundRobinPicker(ImmutableList.copyOf(activeList), this.config.enableOobLoadReport, this.config.errorUtilizationPenalty, this.sequence);
    }

    @Override
    protected MultiChildLoadBalancer.ChildLbState getChildLbStateEag(EquivalentAddressGroup eag) {
        return super.getChildLbStateEag(eag);
    }

    private void createAndApplyOrcaListeners() {
        for (MultiChildLoadBalancer.ChildLbState child : this.getChildLbStates()) {
            WeightedChildLbState wChild = (WeightedChildLbState)child;
            for (WrrSubchannel weightedSubchannel : wChild.subchannels) {
                if (this.config.enableOobLoadReport) {
                    OrcaOobUtil.setListener(weightedSubchannel, wChild.getOrCreateOrcaListener(this.config.errorUtilizationPenalty), OrcaOobUtil.OrcaReportingConfig.newBuilder().setReportInterval(this.config.oobReportingPeriodNanos, TimeUnit.NANOSECONDS).build());
                    continue;
                }
                OrcaOobUtil.setListener(weightedSubchannel, null, null);
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.weightUpdateTimer != null) {
            this.weightUpdateTimer.cancel();
        }
        super.shutdown();
    }

    static final class WeightedRoundRobinLoadBalancerConfig {
        final long blackoutPeriodNanos;
        final long weightExpirationPeriodNanos;
        final boolean enableOobLoadReport;
        final long oobReportingPeriodNanos;
        final long weightUpdatePeriodNanos;
        final float errorUtilizationPenalty;

        public static Builder newBuilder() {
            return new Builder();
        }

        private WeightedRoundRobinLoadBalancerConfig(long blackoutPeriodNanos, long weightExpirationPeriodNanos, boolean enableOobLoadReport, long oobReportingPeriodNanos, long weightUpdatePeriodNanos, float errorUtilizationPenalty) {
            this.blackoutPeriodNanos = blackoutPeriodNanos;
            this.weightExpirationPeriodNanos = weightExpirationPeriodNanos;
            this.enableOobLoadReport = enableOobLoadReport;
            this.oobReportingPeriodNanos = oobReportingPeriodNanos;
            this.weightUpdatePeriodNanos = weightUpdatePeriodNanos;
            this.errorUtilizationPenalty = errorUtilizationPenalty;
        }

        static final class Builder {
            long blackoutPeriodNanos = 10000000000L;
            long weightExpirationPeriodNanos = 180000000000L;
            boolean enableOobLoadReport = false;
            long oobReportingPeriodNanos = 10000000000L;
            long weightUpdatePeriodNanos = 1000000000L;
            float errorUtilizationPenalty = 1.0f;

            private Builder() {
            }

            Builder setBlackoutPeriodNanos(long blackoutPeriodNanos) {
                this.blackoutPeriodNanos = blackoutPeriodNanos;
                return this;
            }

            Builder setWeightExpirationPeriodNanos(long weightExpirationPeriodNanos) {
                this.weightExpirationPeriodNanos = weightExpirationPeriodNanos;
                return this;
            }

            Builder setEnableOobLoadReport(boolean enableOobLoadReport) {
                this.enableOobLoadReport = enableOobLoadReport;
                return this;
            }

            Builder setOobReportingPeriodNanos(long oobReportingPeriodNanos) {
                this.oobReportingPeriodNanos = oobReportingPeriodNanos;
                return this;
            }

            Builder setWeightUpdatePeriodNanos(long weightUpdatePeriodNanos) {
                this.weightUpdatePeriodNanos = weightUpdatePeriodNanos;
                return this;
            }

            Builder setErrorUtilizationPenalty(float errorUtilizationPenalty) {
                this.errorUtilizationPenalty = errorUtilizationPenalty;
                return this;
            }

            WeightedRoundRobinLoadBalancerConfig build() {
                return new WeightedRoundRobinLoadBalancerConfig(this.blackoutPeriodNanos, this.weightExpirationPeriodNanos, this.enableOobLoadReport, this.oobReportingPeriodNanos, this.weightUpdatePeriodNanos, this.errorUtilizationPenalty);
            }
        }
    }

    @VisibleForTesting
    static final class StaticStrideScheduler {
        private final short[] scaledWeights;
        private final AtomicInteger sequence;
        private static final int K_MAX_WEIGHT = 65535;
        private static final double K_MAX_RATIO = 10.0;
        private static final double K_MIN_RATIO = 0.1;

        StaticStrideScheduler(float[] weights, AtomicInteger sequence) {
            double unscaledMeanWeight;
            Preconditions.checkArgument(weights.length >= 1, "Couldn't build scheduler: requires at least one weight");
            int numChannels = weights.length;
            int numWeightedChannels = 0;
            double sumWeight = 0.0;
            float unscaledMaxWeight = 0.0f;
            for (float weight : weights) {
                if (!(weight > 0.0f)) continue;
                sumWeight += (double)weight;
                unscaledMaxWeight = Math.max(weight, unscaledMaxWeight);
                ++numWeightedChannels;
            }
            if (numWeightedChannels > 0) {
                unscaledMeanWeight = sumWeight / (double)numWeightedChannels;
                unscaledMaxWeight = Math.min(unscaledMaxWeight, (float)(10.0 * unscaledMeanWeight));
            } else {
                unscaledMeanWeight = 1.0;
                unscaledMaxWeight = 1.0f;
            }
            double scalingFactor = 65535.0f / unscaledMaxWeight;
            int weightLowerBound = (int)Math.ceil(scalingFactor * unscaledMeanWeight * 0.1);
            short[] scaledWeights = new short[numChannels];
            for (int i = 0; i < numChannels; ++i) {
                if (weights[i] <= 0.0f) {
                    scaledWeights[i] = (short)Math.round(scalingFactor * unscaledMeanWeight);
                    continue;
                }
                int weight = (int)Math.round(scalingFactor * (double)Math.min(weights[i], unscaledMaxWeight));
                scaledWeights[i] = (short)Math.max(weight, weightLowerBound);
            }
            this.scaledWeights = scaledWeights;
            this.sequence = sequence;
        }

        private long nextSequence() {
            return Integer.toUnsignedLong(this.sequence.getAndIncrement());
        }

        int pick() {
            long offset;
            long generation;
            int backendIndex;
            int weight;
            do {
                long sequence = this.nextSequence();
                backendIndex = (int)(sequence % (long)this.scaledWeights.length);
                generation = sequence / (long)this.scaledWeights.length;
            } while (((long)(weight = Short.toUnsignedInt(this.scaledWeights[backendIndex])) * generation + (offset = 32767L * (long)backendIndex)) % 65535L < (long)(65535 - weight));
            return backendIndex;
        }
    }

    @VisibleForTesting
    static final class WeightedRoundRobinPicker
    extends LoadBalancer.SubchannelPicker {
        private final List<MultiChildLoadBalancer.ChildLbState> children;
        private final Map<LoadBalancer.Subchannel, OrcaPerRequestUtil.OrcaPerRequestReportListener> subchannelToReportListenerMap = new HashMap<LoadBalancer.Subchannel, OrcaPerRequestUtil.OrcaPerRequestReportListener>();
        private final boolean enableOobLoadReport;
        private final float errorUtilizationPenalty;
        private final AtomicInteger sequence;
        private final int hashCode;
        private volatile StaticStrideScheduler scheduler;

        WeightedRoundRobinPicker(List<MultiChildLoadBalancer.ChildLbState> children, boolean enableOobLoadReport, float errorUtilizationPenalty, AtomicInteger sequence) {
            Preconditions.checkNotNull(children, "children");
            Preconditions.checkArgument(!children.isEmpty(), "empty child list");
            this.children = children;
            for (MultiChildLoadBalancer.ChildLbState child : children) {
                WeightedChildLbState wChild = (WeightedChildLbState)child;
                for (WrrSubchannel subchannel : wChild.subchannels) {
                    this.subchannelToReportListenerMap.put(subchannel, wChild.getOrCreateOrcaListener(errorUtilizationPenalty));
                }
            }
            this.enableOobLoadReport = enableOobLoadReport;
            this.errorUtilizationPenalty = errorUtilizationPenalty;
            this.sequence = Preconditions.checkNotNull(sequence, "sequence");
            int sum = 0;
            for (MultiChildLoadBalancer.ChildLbState child : children) {
                sum += child.hashCode();
            }
            this.hashCode = sum ^ Boolean.hashCode(enableOobLoadReport) ^ Float.hashCode(errorUtilizationPenalty);
            this.updateWeight();
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            MultiChildLoadBalancer.ChildLbState childLbState = this.children.get(this.scheduler.pick());
            WeightedChildLbState wChild = (WeightedChildLbState)childLbState;
            LoadBalancer.PickResult pickResult = childLbState.getCurrentPicker().pickSubchannel(args);
            LoadBalancer.Subchannel subchannel = pickResult.getSubchannel();
            if (subchannel == null) {
                return pickResult;
            }
            if (!this.enableOobLoadReport) {
                return LoadBalancer.PickResult.withSubchannel(subchannel, OrcaPerRequestUtil.getInstance().newOrcaClientStreamTracerFactory(this.subchannelToReportListenerMap.getOrDefault(subchannel, wChild.getOrCreateOrcaListener(this.errorUtilizationPenalty))));
            }
            return LoadBalancer.PickResult.withSubchannel(subchannel);
        }

        private void updateWeight() {
            float[] newWeights = new float[this.children.size()];
            for (int i = 0; i < this.children.size(); ++i) {
                double newWeight = ((WeightedChildLbState)this.children.get(i)).getWeight();
                newWeights[i] = newWeight > 0.0 ? (float)newWeight : 0.0f;
            }
            this.scheduler = new StaticStrideScheduler(newWeights, this.sequence);
        }

        public String toString() {
            return MoreObjects.toStringHelper(WeightedRoundRobinPicker.class).add("enableOobLoadReport", this.enableOobLoadReport).add("errorUtilizationPenalty", this.errorUtilizationPenalty).add("list", this.children).toString();
        }

        @VisibleForTesting
        List<MultiChildLoadBalancer.ChildLbState> getChildren() {
            return this.children;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof WeightedRoundRobinPicker)) {
                return false;
            }
            WeightedRoundRobinPicker other = (WeightedRoundRobinPicker)o;
            if (other == this) {
                return true;
            }
            return this.hashCode == other.hashCode && this.sequence == other.sequence && this.enableOobLoadReport == other.enableOobLoadReport && Float.compare(this.errorUtilizationPenalty, other.errorUtilizationPenalty) == 0 && this.children.size() == other.children.size() && new HashSet<MultiChildLoadBalancer.ChildLbState>(this.children).containsAll(other.children);
        }
    }

    @VisibleForTesting
    final class WrrSubchannel
    extends ForwardingSubchannel {
        private final LoadBalancer.Subchannel delegate;
        private final WeightedChildLbState owner;

        WrrSubchannel(LoadBalancer.Subchannel delegate, WeightedChildLbState owner) {
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.owner = Preconditions.checkNotNull(owner, "owner");
        }

        @Override
        public void start(final LoadBalancer.SubchannelStateListener listener) {
            this.owner.addSubchannel(this);
            this.delegate().start(new LoadBalancer.SubchannelStateListener(){

                @Override
                public void onSubchannelState(ConnectivityStateInfo newState) {
                    if (newState.getState().equals((Object)ConnectivityState.READY)) {
                        WrrSubchannel.this.owner.nonEmptySince = WeightedRoundRobinLoadBalancer.this.infTime;
                    }
                    listener.onSubchannelState(newState);
                }
            });
        }

        @Override
        protected LoadBalancer.Subchannel delegate() {
            return this.delegate;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            this.owner.removeSubchannel(this);
        }
    }

    private static final class WrrHelper
    extends ForwardingLoadBalancerHelper {
        private final LoadBalancer.Helper delegate;
        private WeightedRoundRobinLoadBalancer wrr;

        WrrHelper(LoadBalancer.Helper helper) {
            this.delegate = helper;
        }

        void setLoadBalancer(WeightedRoundRobinLoadBalancer lb) {
            this.wrr = lb;
        }

        @Override
        protected LoadBalancer.Helper delegate() {
            return this.delegate;
        }

        @Override
        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs args) {
            Preconditions.checkElementIndex(0, args.getAddresses().size(), "Empty address group");
            WeightedChildLbState childLbState = (WeightedChildLbState)this.wrr.getChildLbStateEag(args.getAddresses().get(0));
            WeightedRoundRobinLoadBalancer weightedRoundRobinLoadBalancer = this.wrr;
            Objects.requireNonNull(weightedRoundRobinLoadBalancer);
            return weightedRoundRobinLoadBalancer.new WrrSubchannel(this.delegate().createSubchannel(args), childLbState);
        }
    }

    private final class UpdateWeightTask
    implements Runnable {
        private UpdateWeightTask() {
        }

        @Override
        public void run() {
            if (WeightedRoundRobinLoadBalancer.this.currentPicker != null && WeightedRoundRobinLoadBalancer.this.currentPicker instanceof WeightedRoundRobinPicker) {
                ((WeightedRoundRobinPicker)WeightedRoundRobinLoadBalancer.this.currentPicker).updateWeight();
            }
            WeightedRoundRobinLoadBalancer.this.weightUpdateTimer = WeightedRoundRobinLoadBalancer.this.syncContext.schedule(this, ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.weightUpdatePeriodNanos, TimeUnit.NANOSECONDS, WeightedRoundRobinLoadBalancer.this.timeService);
        }
    }

    @VisibleForTesting
    final class WeightedChildLbState
    extends MultiChildLoadBalancer.ChildLbState {
        private final Set<WrrSubchannel> subchannels;
        private volatile long lastUpdated;
        private volatile long nonEmptySince;
        private volatile double weight;
        private OrcaReportListener orcaReportListener;

        public WeightedChildLbState(Object key, LoadBalancerProvider policyProvider, Object childConfig, LoadBalancer.SubchannelPicker initialPicker) {
            super(key, policyProvider, childConfig, initialPicker);
            this.subchannels = new HashSet<WrrSubchannel>();
            this.weight = 0.0;
        }

        private double getWeight() {
            if (WeightedRoundRobinLoadBalancer.this.config == null) {
                return 0.0;
            }
            long now = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
            if (now - this.lastUpdated >= ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.weightExpirationPeriodNanos) {
                this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.infTime;
                return 0.0;
            }
            if (now - this.nonEmptySince < ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.blackoutPeriodNanos && ((WeightedRoundRobinLoadBalancer)WeightedRoundRobinLoadBalancer.this).config.blackoutPeriodNanos > 0L) {
                return 0.0;
            }
            return this.weight;
        }

        public void addSubchannel(WrrSubchannel wrrSubchannel) {
            this.subchannels.add(wrrSubchannel);
        }

        public OrcaReportListener getOrCreateOrcaListener(float errorUtilizationPenalty) {
            if (this.orcaReportListener != null && this.orcaReportListener.errorUtilizationPenalty == errorUtilizationPenalty) {
                return this.orcaReportListener;
            }
            this.orcaReportListener = new OrcaReportListener(errorUtilizationPenalty);
            return this.orcaReportListener;
        }

        public void removeSubchannel(WrrSubchannel wrrSubchannel) {
            this.subchannels.remove(wrrSubchannel);
        }

        final class OrcaReportListener
        implements OrcaPerRequestUtil.OrcaPerRequestReportListener,
        OrcaOobUtil.OrcaOobReportListener {
            private final float errorUtilizationPenalty;

            OrcaReportListener(float errorUtilizationPenalty) {
                this.errorUtilizationPenalty = errorUtilizationPenalty;
            }

            @Override
            public void onLoadReport(MetricReport report) {
                double utilization;
                double newWeight = 0.0;
                double d = utilization = report.getApplicationUtilization() > 0.0 ? report.getApplicationUtilization() : report.getCpuUtilization();
                if (utilization > 0.0 && report.getQps() > 0.0) {
                    double penalty = 0.0;
                    if (report.getEps() > 0.0 && this.errorUtilizationPenalty > 0.0f) {
                        penalty = report.getEps() / report.getQps() * (double)this.errorUtilizationPenalty;
                    }
                    newWeight = report.getQps() / (utilization + penalty);
                }
                if (newWeight == 0.0) {
                    return;
                }
                if (WeightedChildLbState.this.nonEmptySince == WeightedRoundRobinLoadBalancer.this.infTime) {
                    WeightedChildLbState.this.nonEmptySince = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
                }
                WeightedChildLbState.this.lastUpdated = WeightedRoundRobinLoadBalancer.this.ticker.nanoTime();
                WeightedChildLbState.this.weight = newWeight;
            }
        }
    }
}

