/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.implcore.trace.export;

import com.google.bigtable.repackaged.io.opencensus.common.Duration;
import com.google.bigtable.repackaged.io.opencensus.implcore.internal.EventQueue;
import com.google.bigtable.repackaged.io.opencensus.implcore.trace.export.InProcessRunningSpanStore;
import com.google.bigtable.repackaged.io.opencensus.implcore.trace.export.InProcessSampledSpanStoreImpl;
import com.google.bigtable.repackaged.io.opencensus.implcore.trace.export.SampledSpanStoreImpl;
import com.google.bigtable.repackaged.io.opencensus.implcore.trace.export.SpanExporterImpl;
import com.google.bigtable.repackaged.io.opencensus.trace.export.ExportComponent;

public final class ExportComponentImpl
extends ExportComponent {
    private static final int EXPORTER_BUFFER_SIZE = 2500;
    private static final Duration EXPORTER_SCHEDULE_DELAY = Duration.create(5L, 0);
    private final SpanExporterImpl spanExporter = SpanExporterImpl.create(2500, EXPORTER_SCHEDULE_DELAY);
    private final InProcessRunningSpanStore inProcessRunningSpanStore = InProcessRunningSpanStore.create();
    private final SampledSpanStoreImpl sampledSpanStore;

    @Override
    public SpanExporterImpl getSpanExporter() {
        return this.spanExporter;
    }

    @Override
    public InProcessRunningSpanStore getRunningSpanStore() {
        return this.inProcessRunningSpanStore;
    }

    @Override
    public SampledSpanStoreImpl getSampledSpanStore() {
        return this.sampledSpanStore;
    }

    @Override
    public void shutdown() {
        this.sampledSpanStore.shutdown();
        this.spanExporter.shutdown();
    }

    public static ExportComponentImpl createWithInProcessStores(EventQueue eventQueue) {
        return new ExportComponentImpl(true, eventQueue);
    }

    public static ExportComponentImpl createWithoutInProcessStores(EventQueue eventQueue) {
        return new ExportComponentImpl(false, eventQueue);
    }

    private ExportComponentImpl(boolean supportInProcessStores, EventQueue eventQueue) {
        this.sampledSpanStore = supportInProcessStores ? new InProcessSampledSpanStoreImpl(eventQueue) : SampledSpanStoreImpl.getNoopSampledSpanStoreImpl();
    }
}

