/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.core;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@InternalApi
public class GaxProperties {
    private static final String DEFAULT_VERSION = "";
    private static final String GAX_VERSION = GaxProperties.getLibraryVersion(GaxProperties.class, "version.gax");
    private static final String JAVA_VERSION = GaxProperties.getRuntimeVersion();

    private GaxProperties() {
    }

    public static String getLibraryVersion(Class<?> libraryClass) {
        String version = libraryClass.getPackage().getImplementationVersion();
        return version != null ? version : DEFAULT_VERSION;
    }

    public static String getLibraryVersion(Class<?> libraryClass, String propertyName) {
        String version = null;
        if (!libraryClass.equals(GaxProperties.class) && !DEFAULT_VERSION.equals(version = GaxProperties.getLibraryVersion(libraryClass))) {
            return version;
        }
        try (InputStream in = libraryClass.getResourceAsStream("/dependencies.properties");){
            if (in != null) {
                Properties props = new Properties();
                props.load(in);
                version = props.getProperty(propertyName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return version != null ? version : DEFAULT_VERSION;
    }

    public static String getJavaVersion() {
        return JAVA_VERSION;
    }

    public static String getGaxVersion() {
        return GAX_VERSION;
    }

    @VisibleForTesting
    static String getRuntimeVersion() {
        String javaRuntimeInformation = System.getProperty("java.version", "null");
        String vendor = System.getProperty("java.vendor");
        if (!Strings.isNullOrEmpty(vendor)) {
            javaRuntimeInformation = String.format("%s__%s", javaRuntimeInformation, vendor);
            String vendorVersion = System.getProperty("java.vendor.version");
            if (!Strings.isNullOrEmpty(vendorVersion)) {
                javaRuntimeInformation = String.format("%s__%s", javaRuntimeInformation, vendorVersion);
            }
        }
        return javaRuntimeInformation.replaceAll("[^0-9a-zA-Z_\\\\.]", "-");
    }
}

