/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AuthorizedViewName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.SubsetView;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class AuthorizedView {
    private final com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AuthorizedView proto;

    @InternalApi
    public static AuthorizedView fromProto(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AuthorizedView proto) {
        return new AuthorizedView(proto);
    }

    private AuthorizedView(@Nonnull com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AuthorizedView proto) {
        Preconditions.checkNotNull(proto);
        Preconditions.checkArgument(!proto.getName().isEmpty(), "AuthorizedView must have a name");
        Preconditions.checkArgument(proto.hasSubsetView(), "AuthorizedView must have a subset_view field");
        this.proto = proto;
    }

    public String getId() {
        AuthorizedViewName fullName = AuthorizedViewName.parse(this.proto.getName());
        return fullName.getAuthorizedView();
    }

    public String getTableId() {
        AuthorizedViewName fullName = AuthorizedViewName.parse(this.proto.getName());
        return fullName.getTable();
    }

    public boolean isDeletionProtected() {
        return this.proto.getDeletionProtection();
    }

    public AuthorizedViewType getAuthorizedViewType() {
        if (this.proto.hasSubsetView()) {
            return SubsetView.fromProto(this.proto.getSubsetView());
        }
        throw new IllegalStateException("This AuthorizedView doesn't have a valid type specified");
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AuthorizedView toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizedView that = (AuthorizedView)o;
        return Objects.equal(this.proto, that.proto);
    }

    public int hashCode() {
        return Objects.hashCode(this.proto);
    }

    @InternalExtensionOnly
    public static interface AuthorizedViewType {
    }
}

