/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateAppProfileRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.AppProfile;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.FieldMask;
import com.google.bigtable.repackaged.com.google.protobuf.util.FieldMaskUtil;
import javax.annotation.Nonnull;

public final class UpdateAppProfileRequest {
    private final String instanceId;
    private final String appProfileId;
    private final UpdateAppProfileRequest.Builder proto;

    public static UpdateAppProfileRequest of(@Nonnull AppProfile appProfile) {
        return new UpdateAppProfileRequest(appProfile.getInstanceId(), appProfile.getId(), com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder().setAppProfile(appProfile.toProto()));
    }

    public static UpdateAppProfileRequest of(@Nonnull String instanceId, @Nonnull String appProfileId) {
        return new UpdateAppProfileRequest(instanceId, appProfileId, com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateAppProfileRequest.newBuilder());
    }

    private UpdateAppProfileRequest(@Nonnull String instanceId, @Nonnull String appProfileId, @Nonnull UpdateAppProfileRequest.Builder proto) {
        Preconditions.checkNotNull(instanceId, "instanceId must be set");
        Preconditions.checkNotNull(appProfileId, "appProfileId must be set");
        Preconditions.checkNotNull(proto, "proto must be set");
        this.instanceId = instanceId;
        this.appProfileId = appProfileId;
        this.proto = proto;
    }

    public UpdateAppProfileRequest setIgnoreWarnings(boolean value) {
        this.proto.setIgnoreWarnings(value);
        return this;
    }

    public UpdateAppProfileRequest setDescription(@Nonnull String description) {
        Preconditions.checkNotNull(description);
        this.proto.getAppProfileBuilder().setDescription(description);
        this.updateFieldMask(3);
        return this;
    }

    public UpdateAppProfileRequest setRoutingPolicy(@Nonnull AppProfile.RoutingPolicy routingPolicy) {
        Preconditions.checkNotNull(routingPolicy);
        if (routingPolicy instanceof AppProfile.MultiClusterRoutingPolicy) {
            this.proto.getAppProfileBuilder().setMultiClusterRoutingUseAny(((AppProfile.MultiClusterRoutingPolicy)routingPolicy).toProto());
            this.updateFieldMask(5);
        } else if (routingPolicy instanceof AppProfile.SingleClusterRoutingPolicy) {
            this.proto.getAppProfileBuilder().setSingleClusterRouting(((AppProfile.SingleClusterRoutingPolicy)routingPolicy).toProto());
            this.updateFieldMask(6);
        } else {
            throw new IllegalArgumentException("Unknown policy type: " + routingPolicy);
        }
        return this;
    }

    public UpdateAppProfileRequest setIsolationPolicy(@Nonnull AppProfile.IsolationPolicy isolationPolicy) {
        Preconditions.checkNotNull(isolationPolicy);
        if (isolationPolicy instanceof AppProfile.StandardIsolationPolicy) {
            this.proto.getAppProfileBuilder().setStandardIsolation(((AppProfile.StandardIsolationPolicy)isolationPolicy).toProto());
            this.updateFieldMask(11);
        } else if (isolationPolicy instanceof AppProfile.DataBoostIsolationReadOnlyPolicy) {
            this.proto.getAppProfileBuilder().setDataBoostIsolationReadOnly(((AppProfile.DataBoostIsolationReadOnlyPolicy)isolationPolicy).toProto());
            this.updateFieldMask(10);
        } else {
            throw new IllegalArgumentException("Unknown policy type: " + isolationPolicy);
        }
        return this;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AppProfile.class, fieldNumber);
        this.proto.setUpdateMask(FieldMaskUtil.union(this.proto.getUpdateMask(), newMask, new FieldMask[0]));
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateAppProfileRequest toProto(String projectId) {
        String name = NameUtil.formatAppProfileName(projectId, this.instanceId, this.appProfileId);
        this.proto.getAppProfileBuilder().setName(name);
        return this.proto.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAppProfileRequest that = (UpdateAppProfileRequest)o;
        return Objects.equal(this.instanceId, that.instanceId) && Objects.equal(this.appProfileId, that.appProfileId) && Objects.equal(this.proto.build(), that.proto.build());
    }

    public int hashCode() {
        return Objects.hashCode(this.instanceId, this.appProfileId, this.proto.build());
    }
}

