/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

class CookiesHolder {
    static final CallOptions.Key<CookiesHolder> COOKIES_HOLDER_KEY = CallOptions.Key.create("bigtable-cookies");
    static final String COOKIE_KEY_PREFIX = "x-goog-cbt-cookie";
    private final Map<Metadata.Key<String>, String> cookies = new HashMap<Metadata.Key<String>, String>();

    CookiesHolder() {
    }

    @Nullable
    static CookiesHolder fromCallOptions(CallOptions options) {
        return options.getOption(COOKIES_HOLDER_KEY);
    }

    Metadata injectCookiesInRequestHeaders(Metadata headers) {
        for (Metadata.Key<String> key : this.cookies.keySet()) {
            headers.put(key, this.cookies.get(key));
        }
        return headers;
    }

    void extractCookiesFromMetadata(@Nullable Metadata metadata) {
        if (metadata == null) {
            return;
        }
        for (String key : metadata.keys()) {
            if (!key.startsWith(COOKIE_KEY_PREFIX)) continue;
            Metadata.Key<String> metadataKey = Metadata.Key.of(key, Metadata.ASCII_STRING_MARSHALLER);
            String value = metadata.get(metadataKey);
            this.cookies.put(metadataKey, value);
        }
    }
}

