/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.MonitoredResource;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutureCallback;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.CredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.NoCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PermissionDeniedException;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableExporterUtils;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.bigtable.repackaged.com.google.cloud.monitoring.v3.MetricServiceSettings;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.collect.Iterables;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.bigtable.repackaged.com.google.monitoring.v3.ProjectName;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeries;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.CompletableResultCode;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.MetricData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.export.MetricExporter;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@InternalApi
public final class BigtableCloudMonitoringExporter
implements MetricExporter {
    private static final Logger logger = Logger.getLogger(BigtableCloudMonitoringExporter.class.getName());
    @Deprecated
    @Nullable
    private static final String MONITORING_ENDPOINT_OVERRIDE_SYS_PROP = System.getProperty("bigtable.test-monitoring-endpoint");
    private static final String APPLICATION_RESOURCE_PROJECT_ID = "project_id";
    private static final int EXPORT_BATCH_SIZE_LIMIT = 200;
    private final MetricServiceClient client;
    private final String bigtableProjectId;
    private final String taskId;
    private final MonitoredResource applicationResource;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private CompletableResultCode lastExportCode;
    private final AtomicBoolean bigtableExportFailureLogged = new AtomicBoolean(false);
    private final AtomicBoolean applicationExportFailureLogged = new AtomicBoolean(false);
    private static final ImmutableList<String> BIGTABLE_TABLE_METRICS = ImmutableSet.of("operation_latencies", "attempt_latencies", "server_latencies", "first_response_latencies", "throttling_latencies", "application_latencies", new String[]{"retry_count", "connectivity_error_count"}).stream().map(m -> "bigtable.googleapis.com/internal/client/" + m).collect(ImmutableList.toImmutableList());
    private static final ImmutableList<String> APPLICATION_METRICS = ImmutableSet.of("per_connection_error_count").stream().map(m -> "bigtable.googleapis.com/internal/client/" + m).collect(ImmutableList.toImmutableList());

    public static BigtableCloudMonitoringExporter create(String projectId, @Nullable Credentials credentials, @Nullable String endpoint) throws IOException {
        MetricServiceSettings.Builder settingsBuilder = MetricServiceSettings.newBuilder();
        CredentialsProvider credentialsProvider = Optional.ofNullable(credentials).map(FixedCredentialsProvider::create).orElse(NoCredentialsProvider.create());
        settingsBuilder.setCredentialsProvider(credentialsProvider);
        if (MONITORING_ENDPOINT_OVERRIDE_SYS_PROP != null) {
            logger.warning("Setting the monitoring endpoint through system variable will be removed in future versions");
            settingsBuilder.setEndpoint(MONITORING_ENDPOINT_OVERRIDE_SYS_PROP);
        }
        if (endpoint != null) {
            settingsBuilder.setEndpoint(endpoint);
        }
        Duration timeout = Duration.ofMinutes(1L);
        settingsBuilder.createServiceTimeSeriesSettings().setSimpleTimeoutNoRetries(timeout);
        MonitoredResource applicationResource = null;
        try {
            applicationResource = BigtableExporterUtils.detectResource();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to detect resource, will skip exporting application level metrics ", e);
        }
        return new BigtableCloudMonitoringExporter(projectId, MetricServiceClient.create(settingsBuilder.build()), applicationResource, BigtableExporterUtils.getDefaultTaskValue());
    }

    @VisibleForTesting
    BigtableCloudMonitoringExporter(String projectId, MetricServiceClient client, @Nullable MonitoredResource applicationResource, String taskId) {
        this.client = client;
        this.taskId = taskId;
        this.applicationResource = applicationResource;
        this.bigtableProjectId = projectId;
    }

    @Override
    public CompletableResultCode export(Collection<MetricData> collection) {
        if (this.isShutdown.get()) {
            logger.log(Level.WARNING, "Exporter is shutting down");
            return CompletableResultCode.ofFailure();
        }
        CompletableResultCode bigtableExportCode = this.exportBigtableResourceMetrics(collection);
        CompletableResultCode applicationExportCode = this.exportApplicationResourceMetrics(collection);
        this.lastExportCode = CompletableResultCode.ofAll(ImmutableList.of(applicationExportCode, bigtableExportCode));
        return this.lastExportCode;
    }

    private CompletableResultCode exportBigtableResourceMetrics(Collection<MetricData> collection) {
        List<TimeSeries> bigtableTimeSeries;
        List<MetricData> bigtableMetricData = collection.stream().filter(md -> BIGTABLE_TABLE_METRICS.contains(md.getName())).collect(Collectors.toList());
        if (bigtableMetricData.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        if (!bigtableMetricData.stream().flatMap(metricData -> metricData.getData().getPoints().stream()).allMatch(pd -> this.bigtableProjectId.equals(BigtableExporterUtils.getProjectId(pd)))) {
            logger.log(Level.WARNING, "Metric data has different a projectId. Skip exporting.");
            return CompletableResultCode.ofFailure();
        }
        try {
            bigtableTimeSeries = BigtableExporterUtils.convertToBigtableTimeSeries(bigtableMetricData, this.taskId);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to convert bigtable table metric data to cloud monitoring timeseries.", e);
            return CompletableResultCode.ofFailure();
        }
        final ProjectName projectName = ProjectName.of(this.bigtableProjectId);
        ApiFuture<List<Empty>> future = this.exportTimeSeries(projectName, bigtableTimeSeries);
        final CompletableResultCode bigtableExportCode = new CompletableResultCode();
        ApiFutures.addCallback(future, new ApiFutureCallback<List<Empty>>(){

            @Override
            public void onFailure(Throwable throwable) {
                if (BigtableCloudMonitoringExporter.this.bigtableExportFailureLogged.compareAndSet(false, true)) {
                    String msg = "createServiceTimeSeries request failed for bigtable metrics.";
                    if (throwable instanceof PermissionDeniedException) {
                        msg = msg + String.format(" Need monitoring metric writer permission on project=%s. Follow https://cloud.google.com/bigtable/docs/client-side-metrics-setup to set up permissions.", projectName.getProject());
                    }
                    logger.log(Level.WARNING, msg, throwable);
                }
                bigtableExportCode.fail();
            }

            @Override
            public void onSuccess(List<Empty> emptyList) {
                BigtableCloudMonitoringExporter.this.bigtableExportFailureLogged.set(false);
                bigtableExportCode.succeed();
            }
        }, MoreExecutors.directExecutor());
        return bigtableExportCode;
    }

    private CompletableResultCode exportApplicationResourceMetrics(Collection<MetricData> collection) {
        List<TimeSeries> timeSeries;
        if (this.applicationResource == null) {
            return CompletableResultCode.ofSuccess();
        }
        List<MetricData> metricData = collection.stream().filter(md -> APPLICATION_METRICS.contains(md.getName())).collect(Collectors.toList());
        if (metricData.isEmpty()) {
            return CompletableResultCode.ofSuccess();
        }
        try {
            timeSeries = BigtableExporterUtils.convertToApplicationResourceTimeSeries(metricData, this.taskId, this.applicationResource);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to convert application metric data to cloud monitoring timeseries.", e);
            return CompletableResultCode.ofFailure();
        }
        final CompletableResultCode exportCode = new CompletableResultCode();
        try {
            final ProjectName projectName = ProjectName.of(this.applicationResource.getLabelsOrThrow(APPLICATION_RESOURCE_PROJECT_ID));
            ApiFuture<List<Empty>> gceOrGkeFuture = this.exportTimeSeries(projectName, timeSeries);
            ApiFutures.addCallback(gceOrGkeFuture, new ApiFutureCallback<List<Empty>>(){

                @Override
                public void onFailure(Throwable throwable) {
                    if (BigtableCloudMonitoringExporter.this.applicationExportFailureLogged.compareAndSet(false, true)) {
                        String msg = "createServiceTimeSeries request failed for bigtable metrics.";
                        if (throwable instanceof PermissionDeniedException) {
                            msg = msg + String.format(" Need monitoring metric writer permission on project=%s. Follow https://cloud.google.com/bigtable/docs/client-side-metrics-setup to set up permissions.", projectName.getProject());
                        }
                        logger.log(Level.WARNING, msg, throwable);
                    }
                    exportCode.fail();
                }

                @Override
                public void onSuccess(List<Empty> emptyList) {
                    BigtableCloudMonitoringExporter.this.applicationExportFailureLogged.set(false);
                    exportCode.succeed();
                }
            }, MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to get projectName for application resource " + this.applicationResource);
            return CompletableResultCode.ofFailure();
        }
        return exportCode;
    }

    private ApiFuture<List<Empty>> exportTimeSeries(ProjectName projectName, List<TimeSeries> timeSeries) {
        ArrayList<ApiFuture<Empty>> batchResults = new ArrayList<ApiFuture<Empty>>();
        for (List<TimeSeries> batch : Iterables.partition(timeSeries, 200)) {
            CreateTimeSeriesRequest req = CreateTimeSeriesRequest.newBuilder().setName(projectName.toString()).addAllTimeSeries(batch).build();
            ApiFuture<Empty> f = this.client.createServiceTimeSeriesCallable().futureCall(req);
            batchResults.add(f);
        }
        return ApiFutures.allAsList(batchResults);
    }

    @Override
    public CompletableResultCode flush() {
        if (this.lastExportCode != null) {
            return this.lastExportCode;
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            logger.log(Level.WARNING, "shutdown is called multiple times");
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode flushResult = this.flush();
        CompletableResultCode shutdownResult = new CompletableResultCode();
        flushResult.whenComplete(() -> {
            Throwable throwable = null;
            try {
                this.client.shutdown();
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "failed to shutdown the monitoring client", e);
                throwable = e;
            }
            if (throwable != null) {
                shutdownResult.fail();
            } else {
                shutdownResult.succeed();
            }
        });
        return CompletableResultCode.ofAll(Arrays.asList(flushResult, shutdownResult));
    }

    @Override
    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }
}

