/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.io.opentelemetry.api.common.AttributeKey;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.Aggregation;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentSelector;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.View;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@InternalApi
public class BuiltinMetricsConstants {
    public static final AttributeKey<String> BIGTABLE_PROJECT_ID_KEY = AttributeKey.stringKey("project_id");
    public static final AttributeKey<String> INSTANCE_ID_KEY = AttributeKey.stringKey("instance");
    public static final AttributeKey<String> TABLE_ID_KEY = AttributeKey.stringKey("table");
    public static final AttributeKey<String> CLUSTER_ID_KEY = AttributeKey.stringKey("cluster");
    public static final AttributeKey<String> ZONE_ID_KEY = AttributeKey.stringKey("zone");
    public static final AttributeKey<String> APP_PROFILE_KEY = AttributeKey.stringKey("app_profile");
    public static final AttributeKey<Boolean> STREAMING_KEY = AttributeKey.booleanKey("streaming");
    public static final AttributeKey<String> CLIENT_NAME_KEY = AttributeKey.stringKey("client_name");
    static final AttributeKey<String> METHOD_KEY = AttributeKey.stringKey("method");
    static final AttributeKey<String> STATUS_KEY = AttributeKey.stringKey("status");
    static final AttributeKey<String> CLIENT_UID_KEY = AttributeKey.stringKey("client_uid");
    public static final String OPERATION_LATENCIES_NAME = "operation_latencies";
    public static final String ATTEMPT_LATENCIES_NAME = "attempt_latencies";
    static final String RETRY_COUNT_NAME = "retry_count";
    static final String CONNECTIVITY_ERROR_COUNT_NAME = "connectivity_error_count";
    static final String SERVER_LATENCIES_NAME = "server_latencies";
    static final String FIRST_RESPONSE_LATENCIES_NAME = "first_response_latencies";
    static final String APPLICATION_BLOCKING_LATENCIES_NAME = "application_latencies";
    static final String CLIENT_BLOCKING_LATENCIES_NAME = "throttling_latencies";
    static final String PER_CONNECTION_ERROR_COUNT_NAME = "per_connection_error_count";
    private static final Aggregation AGGREGATION_WITH_MILLIS_HISTOGRAM = Aggregation.explicitBucketHistogram(ImmutableList.of(Double.valueOf(0.0), Double.valueOf(1.0), Double.valueOf(2.0), Double.valueOf(3.0), Double.valueOf(4.0), Double.valueOf(5.0), Double.valueOf(6.0), Double.valueOf(8.0), Double.valueOf(10.0), Double.valueOf(13.0), Double.valueOf(16.0), Double.valueOf(20.0), new Double[]{25.0, 30.0, 40.0, 50.0, 65.0, 80.0, 100.0, 130.0, 160.0, 200.0, 250.0, 300.0, 400.0, 500.0, 650.0, 800.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0, 200000.0, 400000.0, 800000.0, 1600000.0, 3200000.0}));
    private static final Aggregation AGGREGATION_PER_CONNECTION_ERROR_COUNT_HISTOGRAM = Aggregation.explicitBucketHistogram(ImmutableList.of(Double.valueOf(1.0), Double.valueOf(2.0), Double.valueOf(4.0), Double.valueOf(8.0), Double.valueOf(16.0), Double.valueOf(32.0), Double.valueOf(64.0), Double.valueOf(125.0), Double.valueOf(250.0), Double.valueOf(500.0), Double.valueOf(1000.0), Double.valueOf(2000.0), new Double[]{4000.0, 8000.0, 16000.0, 32000.0, 64000.0, 128000.0, 250000.0, 500000.0, 1000000.0}));
    public static final String METER_NAME = "bigtable.googleapis.com/internal/client/";
    static final Set<AttributeKey> COMMON_ATTRIBUTES = ImmutableSet.of(BIGTABLE_PROJECT_ID_KEY, INSTANCE_ID_KEY, TABLE_ID_KEY, APP_PROFILE_KEY, CLUSTER_ID_KEY, ZONE_ID_KEY, new AttributeKey[]{METHOD_KEY, CLIENT_NAME_KEY});

    static void defineView(ImmutableMap.Builder<InstrumentSelector, View> viewMap, String id, Aggregation aggregation, InstrumentType type, String unit, Set<AttributeKey> attributes) {
        InstrumentSelector selector = InstrumentSelector.builder().setName(id).setMeterName(METER_NAME).setType(type).setUnit(unit).build();
        ImmutableCollection attributesFilter = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)COMMON_ATTRIBUTES.stream().map(AttributeKey::getKey).collect(Collectors.toSet()))).addAll((Iterable)attributes.stream().map(AttributeKey::getKey).collect(Collectors.toSet()))).build();
        View view = View.builder().setName(METER_NAME + id).setAggregation(aggregation).setAttributeFilter((Set<String>)((Object)attributesFilter)).build();
        viewMap.put(selector, view);
    }

    public static Map<InstrumentSelector, View> getAllViews() {
        ImmutableMap.Builder<InstrumentSelector, View> views = ImmutableMap.builder();
        BuiltinMetricsConstants.defineView(views, OPERATION_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES)).add(new AttributeKey[]{STREAMING_KEY, STATUS_KEY})).build()));
        BuiltinMetricsConstants.defineView(views, ATTEMPT_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES)).add(new AttributeKey[]{STREAMING_KEY, STATUS_KEY})).build()));
        BuiltinMetricsConstants.defineView(views, SERVER_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES)).add(STATUS_KEY)).build()));
        BuiltinMetricsConstants.defineView(views, FIRST_RESPONSE_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES)).add(STATUS_KEY)).build()));
        BuiltinMetricsConstants.defineView(views, APPLICATION_BLOCKING_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)((Object)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES)).build()));
        BuiltinMetricsConstants.defineView(views, CLIENT_BLOCKING_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)((Object)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES)).build()));
        BuiltinMetricsConstants.defineView(views, RETRY_COUNT_NAME, Aggregation.sum(), InstrumentType.COUNTER, "1", (Set<AttributeKey>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES)).add(STATUS_KEY)).build()));
        BuiltinMetricsConstants.defineView(views, CONNECTIVITY_ERROR_COUNT_NAME, Aggregation.sum(), InstrumentType.COUNTER, "1", (Set<AttributeKey>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES)).add(STATUS_KEY)).build()));
        BuiltinMetricsConstants.defineView(views, PER_CONNECTION_ERROR_COUNT_NAME, AGGREGATION_PER_CONNECTION_ERROR_COUNT_HISTOGRAM, InstrumentType.HISTOGRAM, "1", (Set<AttributeKey>)((Object)((ImmutableSet.Builder)ImmutableSet.builder().add(new AttributeKey[]{BIGTABLE_PROJECT_ID_KEY, INSTANCE_ID_KEY, APP_PROFILE_KEY, CLIENT_NAME_KEY})).build()));
        return views.build();
    }
}

