/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.protobuf.services.internal;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.io.grpc.Internal;
import com.google.bigtable.repackaged.io.grpc.LoadBalancer;
import com.google.bigtable.repackaged.io.grpc.LoadBalancerProvider;
import com.google.bigtable.repackaged.io.grpc.NameResolver;
import com.google.bigtable.repackaged.io.grpc.protobuf.services.HealthCheckingLoadBalancerUtil;
import java.util.Map;

@Internal
public final class HealthCheckingRoundRobinLoadBalancerProvider
extends LoadBalancerProvider {
    private final LoadBalancerProvider rrProvider = HealthCheckingRoundRobinLoadBalancerProvider.newRoundRobinProvider();

    @Override
    public boolean isAvailable() {
        return this.rrProvider.isAvailable();
    }

    @Override
    public int getPriority() {
        return this.rrProvider.getPriority() + 1;
    }

    @Override
    public String getPolicyName() {
        return this.rrProvider.getPolicyName();
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return HealthCheckingLoadBalancerUtil.newHealthCheckingLoadBalancer(this.rrProvider, helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return this.rrProvider.parseLoadBalancingPolicyConfig(rawLoadBalancingPolicyConfig);
    }

    @VisibleForTesting
    static LoadBalancerProvider newRoundRobinProvider() {
        try {
            Class<LoadBalancerProvider> rrProviderClass = Class.forName("com.google.bigtable.repackaged.io.grpc.util.SecretRoundRobinLoadBalancerProvider$Provider").asSubclass(LoadBalancerProvider.class);
            return rrProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}

