/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opencensus.implcore.stats;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.opencensus.common.Clock;
import com.google.bigtable.repackaged.io.opencensus.implcore.internal.CurrentState;
import com.google.bigtable.repackaged.io.opencensus.implcore.internal.EventQueue;
import com.google.bigtable.repackaged.io.opencensus.implcore.stats.MetricProducerImpl;
import com.google.bigtable.repackaged.io.opencensus.implcore.stats.StatsManager;
import com.google.bigtable.repackaged.io.opencensus.implcore.stats.StatsRecorderImpl;
import com.google.bigtable.repackaged.io.opencensus.implcore.stats.ViewManagerImpl;
import com.google.bigtable.repackaged.io.opencensus.metrics.Metrics;
import com.google.bigtable.repackaged.io.opencensus.stats.StatsCollectionState;
import com.google.bigtable.repackaged.io.opencensus.stats.StatsComponent;

public class StatsComponentImplBase
extends StatsComponent {
    private static final CurrentState.State DEFAULT_STATE = CurrentState.State.ENABLED;
    private final CurrentState currentState = new CurrentState(DEFAULT_STATE);
    private final ViewManagerImpl viewManager;
    private final StatsRecorderImpl statsRecorder;

    public StatsComponentImplBase(EventQueue queue, Clock clock) {
        StatsManager statsManager = new StatsManager(queue, clock, this.currentState);
        this.viewManager = new ViewManagerImpl(statsManager);
        this.statsRecorder = new StatsRecorderImpl(statsManager);
        MetricProducerImpl metricProducer = new MetricProducerImpl(statsManager);
        Metrics.getExportComponent().getMetricProducerManager().add(metricProducer);
    }

    @Override
    public ViewManagerImpl getViewManager() {
        return this.viewManager;
    }

    @Override
    public StatsRecorderImpl getStatsRecorder() {
        return this.statsRecorder;
    }

    @Override
    public StatsCollectionState getState() {
        return StatsComponentImplBase.stateToStatsState(this.currentState.get());
    }

    @Override
    public synchronized void setState(StatsCollectionState newState) {
        boolean stateChanged = this.currentState.set(StatsComponentImplBase.statsStateToState(Preconditions.checkNotNull(newState, "newState")));
        if (stateChanged) {
            if (newState == StatsCollectionState.DISABLED) {
                this.viewManager.clearStats();
            } else {
                this.viewManager.resumeStatsCollection();
            }
        }
    }

    private static CurrentState.State statsStateToState(StatsCollectionState statsCollectionState) {
        return statsCollectionState == StatsCollectionState.ENABLED ? CurrentState.State.ENABLED : CurrentState.State.DISABLED;
    }

    private static StatsCollectionState stateToStatsState(CurrentState.State state) {
        return state == CurrentState.State.ENABLED ? StatsCollectionState.ENABLED : StatsCollectionState.DISABLED;
    }
}

