/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.view;

import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.Clock;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.export.MemoryMode;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.Aggregation;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.PointData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleExplicitBucketHistogramAggregator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.List;

public final class ExplicitBucketHistogramAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation DEFAULT = new ExplicitBucketHistogramAggregation(ExplicitBucketHistogramUtils.DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES);
    private final List<Double> bucketBoundaries;
    private final double[] bucketBoundaryArray;

    public static Aggregation getDefault() {
        return DEFAULT;
    }

    public static Aggregation create(List<Double> bucketBoundaries) {
        return new ExplicitBucketHistogramAggregation(bucketBoundaries);
    }

    private ExplicitBucketHistogramAggregation(List<Double> bucketBoundaries) {
        this.bucketBoundaries = bucketBoundaries;
        this.bucketBoundaryArray = ExplicitBucketHistogramUtils.createBoundaryArray(bucketBoundaries);
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        return new DoubleExplicitBucketHistogramAggregator(this.bucketBoundaryArray, () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.longToDouble(ExemplarReservoir.histogramBucketReservoir(Clock.getDefault(), this.bucketBoundaries))), memoryMode);
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        switch (instrumentDescriptor.getType()) {
            case COUNTER: 
            case HISTOGRAM: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ExplicitBucketHistogramAggregation(" + this.bucketBoundaries.toString() + ")";
    }
}

