/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.view;

import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.Clock;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.export.MemoryMode;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.internal.RandomSupplier;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.Aggregation;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.InstrumentType;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.ExemplarData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.LongExemplarData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.data.PointData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleLastValueAggregator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.aggregator.LongLastValueAggregator;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import java.util.function.Supplier;

public final class LastValueAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new LastValueAggregation();

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private LastValueAggregation() {
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        switch (instrumentDescriptor.getValueType()) {
            case LONG: {
                Supplier<ExemplarReservoir<LongExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.longFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new LongLastValueAggregator(reservoirFactory, memoryMode);
            }
            case DOUBLE: {
                Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirFactory = () -> ExemplarReservoir.filtered(exemplarFilter, ExemplarReservoir.doubleFixedSizeReservoir(Clock.getDefault(), Runtime.getRuntime().availableProcessors(), RandomSupplier.platformDefault()));
                return new DoubleLastValueAggregator(reservoirFactory, memoryMode);
            }
        }
        throw new IllegalArgumentException("Invalid instrument value type");
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        InstrumentType instrumentType = instrumentDescriptor.getType();
        return instrumentType == InstrumentType.OBSERVABLE_GAUGE || instrumentType == InstrumentType.GAUGE;
    }

    public String toString() {
        return "LastValueAggregation";
    }
}

