/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase1_x;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.hbase.adapters.SampledRowKeysAdapter;
import com.google.cloud.bigtable.hbase1_x.BigtableAdmin;
import com.google.cloud.bigtable.hbase1_x.BigtableTable;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CommonConnection;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;

@InternalApi(value="For internal usage only")
public class BigtableConnection
extends AbstractBigtableConnection {
    public BigtableConnection(Configuration conf) throws IOException {
        super(conf);
    }

    BigtableConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        super(conf, managed, pool, user);
    }

    public Admin getAdmin() throws IOException {
        return BigtableAdmin.createInstance((CommonConnection)this);
    }

    public String getClusterId() throws IOException {
        throw new UnsupportedOperationException("not implemented");
    }

    protected SampledRowKeysAdapter createSampledRowKeysAdapter(TableName tableName, ServerName serverName) {
        return new SampledRowKeysAdapter(tableName, serverName){

            protected HRegionLocation createRegionLocation(byte[] startKey, byte[] endKey) {
                HRegionInfo hRegionInfo = new HRegionInfo(this.tableName, startKey, endKey);
                return new HRegionLocation(hRegionInfo, this.serverName);
            }
        };
    }

    public Table getTable(TableName tableName, ExecutorService ignored) throws IOException {
        return BigtableTable.create(this, this.createAdapter(tableName));
    }

    public List<HRegionInfo> getAllRegionInfos(TableName tableName) throws IOException {
        ImmutableList.Builder regionInfos = ImmutableList.builder();
        for (HRegionLocation location : this.getRegionLocator(tableName).getAllRegionLocations()) {
            regionInfos.add((Object)location.getRegionInfo());
        }
        return regionInfos.build();
    }
}

