/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.MutationApi;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.HBaseMutationAdapter;
import com.google.cloud.bigtable.hbase.adapters.PutAdapter;
import com.google.cloud.bigtable.hbase.adapters.RowMutationsAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.DefaultReadHooks;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;

@InternalApi(value="For internal usage only")
public class HBaseRequestAdapter {
    protected final MutationAdapters mutationAdapters;
    protected final TableName tableName;

    public HBaseRequestAdapter(BigtableHBaseSettings settings, TableName tableName) {
        this(settings, tableName, new MutationAdapters(settings));
    }

    public HBaseRequestAdapter(BigtableHBaseSettings settings, TableName tableName, MutationAdapters mutationAdapters) {
        this(tableName, mutationAdapters);
    }

    @VisibleForTesting
    HBaseRequestAdapter(TableName tableName, MutationAdapters mutationAdapters) {
        this.tableName = tableName;
        this.mutationAdapters = mutationAdapters;
    }

    public HBaseRequestAdapter withServerSideTimestamps() {
        return new HBaseRequestAdapter(this.tableName, this.mutationAdapters.withServerSideTimestamps());
    }

    public RowMutation adapt(Delete delete) {
        RowMutation rowMutation = this.newRowMutationModel(delete.getRow());
        this.adapt(delete, (MutationApi<?>)rowMutation);
        return rowMutation;
    }

    @InternalApi
    public void adapt(Delete delete, MutationApi<?> mutationApi) {
        Adapters.DELETE_ADAPTER.adapt(delete, mutationApi);
    }

    public RowMutationEntry adaptEntry(Delete delete) {
        RowMutationEntry rowMutation = this.buildRowMutationEntry(delete.getRow());
        this.adapt(delete, (MutationApi<?>)rowMutation);
        return rowMutation;
    }

    public Query adapt(Get get) {
        DefaultReadHooks readHooks = new DefaultReadHooks();
        Query query = Query.create((String)this.getTableId());
        query = Adapters.GET_ADAPTER.adapt(get, (ReadHooks)readHooks, query);
        readHooks.applyPreSendHook(query);
        return query;
    }

    public Query adapt(Scan scan) {
        DefaultReadHooks readHooks = new DefaultReadHooks();
        Query query = Query.create((String)this.getTableId());
        query = Adapters.SCAN_ADAPTER.adapt(scan, (ReadHooks)readHooks, query);
        readHooks.applyPreSendHook(query);
        return query;
    }

    public ReadModifyWriteRow adapt(Append append) {
        ReadModifyWriteRow readModifyWriteRow = ReadModifyWriteRow.create((String)this.getTableId(), (ByteString)ByteString.copyFrom((byte[])append.getRow()));
        Adapters.APPEND_ADAPTER.adapt(append, readModifyWriteRow);
        return readModifyWriteRow;
    }

    public ReadModifyWriteRow adapt(Increment increment) {
        ReadModifyWriteRow readModifyWriteRow = ReadModifyWriteRow.create((String)this.getTableId(), (ByteString)ByteString.copyFrom((byte[])increment.getRow()));
        Adapters.INCREMENT_ADAPTER.adapt(increment, readModifyWriteRow);
        return readModifyWriteRow;
    }

    public RowMutation adapt(Put put) {
        RowMutation rowMutation = this.newRowMutationModel(put.getRow());
        this.adapt(put, (MutationApi<?>)rowMutation);
        return rowMutation;
    }

    @InternalApi
    public void adapt(Put put, MutationApi<?> mutationApi) {
        this.mutationAdapters.putAdapter.adapt(put, mutationApi);
    }

    public RowMutationEntry adaptEntry(Put put) {
        RowMutationEntry rowMutation = this.buildRowMutationEntry(put.getRow());
        this.adapt(put, (MutationApi<?>)rowMutation);
        return rowMutation;
    }

    public RowMutation adapt(RowMutations mutations) {
        RowMutation rowMutation = this.newRowMutationModel(mutations.getRow());
        this.adapt(mutations, (MutationApi<?>)rowMutation);
        return rowMutation;
    }

    @InternalApi
    public void adapt(RowMutations mutations, MutationApi<?> mutationApi) {
        this.mutationAdapters.rowMutationsAdapter.adapt(mutations, mutationApi);
    }

    public RowMutationEntry adaptEntry(RowMutations mutations) {
        RowMutationEntry rowMutation = this.buildRowMutationEntry(mutations.getRow());
        this.adapt(mutations, (MutationApi<?>)rowMutation);
        return rowMutation;
    }

    public RowMutation adapt(Mutation mutation) {
        RowMutation rowMutation = this.newRowMutationModel(mutation.getRow());
        this.adapt(mutation, (MutationApi<?>)rowMutation);
        return rowMutation;
    }

    @InternalApi
    private void adapt(Mutation mutation, MutationApi<?> mutationApi) {
        this.mutationAdapters.hbaseMutationAdapter.adapt(mutation, mutationApi);
    }

    public String getTableId() {
        return this.tableName.getNameAsString();
    }

    public TableName getTableName() {
        return this.tableName;
    }

    private RowMutation newRowMutationModel(byte[] rowKey) {
        if (!this.mutationAdapters.putAdapter.isSetClientTimestamp()) {
            return RowMutation.create((String)this.getTableId(), (ByteString)ByteString.copyFrom((byte[])rowKey), (com.google.cloud.bigtable.data.v2.models.Mutation)com.google.cloud.bigtable.data.v2.models.Mutation.createUnsafe());
        }
        return RowMutation.create((String)this.getTableId(), (ByteString)ByteString.copyFrom((byte[])rowKey));
    }

    private RowMutationEntry buildRowMutationEntry(byte[] rowKey) {
        if (!this.mutationAdapters.putAdapter.isSetClientTimestamp()) {
            return RowMutationEntry.createUnsafe((ByteString)ByteString.copyFrom((byte[])rowKey));
        }
        return RowMutationEntry.create((ByteString)ByteString.copyFrom((byte[])rowKey));
    }

    public static class MutationAdapters {
        protected final PutAdapter putAdapter;
        protected final HBaseMutationAdapter hbaseMutationAdapter;
        protected final RowMutationsAdapter rowMutationsAdapter;

        public MutationAdapters(BigtableHBaseSettings settings) {
            this(Adapters.createPutAdapter(settings));
        }

        @VisibleForTesting
        MutationAdapters(PutAdapter putAdapter) {
            this.putAdapter = putAdapter;
            this.hbaseMutationAdapter = Adapters.createMutationsAdapter(putAdapter);
            this.rowMutationsAdapter = new RowMutationsAdapter(this.hbaseMutationAdapter);
        }

        public MutationAdapters withServerSideTimestamps() {
            return new MutationAdapters(this.putAdapter.withServerSideTimestamps());
        }
    }
}

