/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.hbase.util.RowKeyUtil;
import com.google.cloud.bigtable.hbase.util.RowKeyWrapper;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hbase.filter.PrefixFilter;

@InternalApi(value="For internal usage only")
public class PrefixFilterAdapter
extends TypedFilterAdapterBase<PrefixFilter> {
    @Override
    public Filters.Filter adapt(FilterAdapterContext context, PrefixFilter filter) throws IOException {
        ByteString.Output output = ByteString.newOutput((int)(filter.getPrefix().length * 2));
        ReaderExpressionHelper.writeQuotedRegularExpression((OutputStream)output, filter.getPrefix());
        output.write(ReaderExpressionHelper.ALL_QUALIFIERS_BYTES);
        return Filters.FILTERS.key().regex(output.toByteString());
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, PrefixFilter filter) {
        return FilterSupportStatus.SUPPORTED;
    }

    @Override
    public RangeSet<RowKeyWrapper> getIndexScanHint(PrefixFilter filter) {
        if (filter.getPrefix().length == 0) {
            return ImmutableRangeSet.of((Range)Range.all());
        }
        ByteString start = ByteString.copyFrom((byte[])filter.getPrefix());
        ByteString end = ByteString.copyFrom((byte[])RowKeyUtil.calculateTheClosestNextRowKeyForPrefix(filter.getPrefix()));
        return ImmutableRangeSet.of((Range)Range.closedOpen((Comparable)new RowKeyWrapper(start), (Comparable)new RowKeyWrapper(end)));
    }
}

