/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;

@InternalApi(value="For internal usage only")
public class WhileMatchFilterAdapter
extends TypedFilterAdapterBase<WhileMatchFilter> {
    static final String IN_LABEL_SUFFIX = "-in";
    static final String OUT_LABEL_SUFFIX = "-out";
    private final FilterAdapter subFilterAdapter;

    public WhileMatchFilterAdapter(FilterAdapter subFilterAdapter) {
        this.subFilterAdapter = subFilterAdapter;
    }

    @Override
    public Filters.Filter adapt(FilterAdapterContext context, WhileMatchFilter filter) throws IOException {
        Preconditions.checkArgument((context.getNumberOfWhileMatchFilters() == 0 ? 1 : 0) != 0, (Object)"More than one WhileMatchFilter is not supported.");
        Preconditions.checkNotNull((Object)filter.getFilter(), (Object)"The wrapped filter for a WhileMatchFilter cannot be null.");
        Optional<Filters.Filter> wrappedFilter = this.subFilterAdapter.adaptFilter(context, filter.getFilter());
        Preconditions.checkArgument((boolean)wrappedFilter.isPresent(), (Object)("Unable to adapted the wrapped filter: " + filter.getFilter()));
        String whileMatchFilterId = context.getNextUniqueId();
        Filters.Filter inLabel = Filters.FILTERS.label(whileMatchFilterId + IN_LABEL_SUFFIX);
        Filters.ChainFilter inLabelAndSink = Filters.FILTERS.chain().filter(inLabel).filter(Filters.FILTERS.sink());
        Filters.Filter outLabel = Filters.FILTERS.label(whileMatchFilterId + OUT_LABEL_SUFFIX);
        Filters.ChainFilter outLabelAndSink = Filters.FILTERS.chain().filter(outLabel).filter(Filters.FILTERS.sink());
        Filters.InterleaveFilter outInterleave = Filters.FILTERS.interleave().filter((Filters.Filter)outLabelAndSink).filter(Filters.FILTERS.pass());
        Filters.ChainFilter outChain = Filters.FILTERS.chain().filter((Filters.Filter)wrappedFilter.get()).filter((Filters.Filter)outInterleave);
        Filters.InterleaveFilter finalFilter = Filters.FILTERS.interleave().filter((Filters.Filter)inLabelAndSink).filter((Filters.Filter)outChain);
        context.addWhileMatchFilter(filter);
        return finalFilter;
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, WhileMatchFilter filter) {
        ArrayList<FilterSupportStatus> unsupportedStatuses = new ArrayList<FilterSupportStatus>();
        this.subFilterAdapter.collectUnsupportedStatuses(context, filter.getFilter(), unsupportedStatuses);
        if (!unsupportedStatuses.isEmpty()) {
            return FilterSupportStatus.newCompositeNotSupported(unsupportedStatuses);
        }
        if (this.inInterleave(context.getScan().getFilter(), filter)) {
            return FilterSupportStatus.newNotSupported("A WhileMatchFilter cannot be in a FilterList with MUST_PASS_ONE operation.");
        }
        return FilterSupportStatus.SUPPORTED;
    }

    private boolean inInterleave(Filter filter, WhileMatchFilter whileMatchFilter) {
        block5: {
            if (filter == whileMatchFilter) {
                return false;
            }
            if (!(filter instanceof FilterList)) break block5;
            FilterList list = (FilterList)filter;
            if (list.getOperator() == FilterList.Operator.MUST_PASS_ONE) {
                for (Filter subFilter : list.getFilters()) {
                    if (!this.hasFilter(subFilter, whileMatchFilter)) continue;
                    return true;
                }
            } else {
                for (Filter subFilter : list.getFilters()) {
                    if (!this.inInterleave(subFilter, whileMatchFilter)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasFilter(Filter filter, WhileMatchFilter whileMatchFilter) {
        if (filter == whileMatchFilter) {
            return true;
        }
        if (filter instanceof FilterList) {
            FilterList list = (FilterList)filter;
            for (Filter subFilter : list.getFilters()) {
                if (!this.hasFilter(subFilter, whileMatchFilter)) continue;
                return true;
            }
        }
        return false;
    }
}

