/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer;

import com.google.api.core.InternalApi;
import com.google.auth.Credentials;
import com.google.cloud.bigtable.hbase.BigtableOAuth2Credentials;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;

@InternalApi(value="For internal usage only")
public final class BigtableCredentialsWrapper
extends Credentials {
    private final BigtableOAuth2Credentials bigtableCredentials;

    public BigtableCredentialsWrapper(BigtableOAuth2Credentials btCredentials) {
        this.bigtableCredentials = btCredentials;
    }

    public String getAuthenticationType() {
        return "OAuth2";
    }

    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        try {
            return this.bigtableCredentials.getRequestMetadata(uri);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch credentials.", e);
        }
    }

    public boolean hasRequestMetadata() {
        return true;
    }

    public boolean hasRequestMetadataOnly() {
        return true;
    }

    public void refresh() throws IOException {
    }
}

