/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase;

import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.auth.Credentials;
import com.google.cloud.bigtable.hbase.BigtableExtendedConfiguration;
import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.BigtableAsyncRegistry;
import org.apache.hadoop.hbase.client.Connection;

@InternalExtensionOnly
public class BigtableConfiguration {
    @InternalApi(value="For internal usage only")
    public static final String HBASE_CLIENT_CONNECTION_IMPL = "hbase.client.connection.impl";
    @InternalApi(value="For internal usage only")
    public static final String HBASE_CLIENT_ASYNC_CONNECTION_IMPL = "hbase.client.async.connection.impl";
    @InternalApi(value="For internal usage only")
    public static final String HBASE_CLIENT_ASYNC_REGISTRY_IMPL = "hbase.client.registry.impl";
    @InternalApi(value="For internal usage only")
    public static final String BIGTABLE_HBASE_CLIENT_ASYNC_CONNECTION_CLASS = "org.apache.hadoop.hbase.client.BigtableAsyncConnection";
    @InternalApi(value="For internal usage only")
    public static final String BIGTABLE_HBASE_CLIENT_ASYNC_REGISTRY_CLASS = "org.apache.hadoop.hbase.client.BigtableAsyncRegistry";
    private static final String HBASE_ASYNC_CONNECTION_CLASS = "org.apache.hadoop.hbase.client.AsyncConnection";
    private static final String[] CONNECTION_CLASS_NAMES = new String[]{"com.google.cloud.bigtable.hbase1_x.BigtableConnection", "com.google.cloud.bigtable.hbase2_x.BigtableConnection"};
    private static final String[] ASYNC_CONNECTION_CLASS_NAMES = new String[]{"org.apache.hadoop.hbase.client.BigtableAsyncConnection", "org.apache.hadoop.hbase.client.BigtableAsyncRegistry", "org.apache.hadoop.hbase.client.AsyncConnection"};
    private static final Class<? extends Connection> CONNECTION_CLASS = BigtableConfiguration.chooseConnectionClass();

    private static Class<? extends Connection> chooseConnectionClass() {
        for (String className : CONNECTION_CLASS_NAMES) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    @InternalApi(value="For internal usage only")
    public static Class<? extends Connection> getConnectionClass() {
        Preconditions.checkState((CONNECTION_CLASS != null ? 1 : 0) != 0, (Object)"Could not load a concrete implementation of BigtableTableConnection: failed to find bigtable-hbase-1.x on the classpath.");
        return CONNECTION_CLASS;
    }

    private static Configuration injectBigtableImpls(Configuration configuration) {
        configuration.set(HBASE_CLIENT_CONNECTION_IMPL, BigtableConfiguration.getConnectionClass().getCanonicalName());
        try {
            for (String className : ASYNC_CONNECTION_CLASS_NAMES) {
                Class.forName(className);
            }
            configuration.set(HBASE_CLIENT_ASYNC_CONNECTION_IMPL, BIGTABLE_HBASE_CLIENT_ASYNC_CONNECTION_CLASS);
            configuration.set(HBASE_CLIENT_ASYNC_REGISTRY_IMPL, BigtableAsyncRegistry.getSubClass().getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return configuration;
    }

    public static Configuration configure(String projectId, String instanceId) {
        Configuration config = new Configuration(false);
        return BigtableConfiguration.configure(config, projectId, instanceId);
    }

    public static Configuration configure(String projectId, String instanceId, String appProfileId) {
        Configuration config = new Configuration(false);
        return BigtableConfiguration.configure(config, projectId, instanceId, appProfileId);
    }

    public static Configuration configure(Configuration conf, String projectId, String instanceId) {
        conf.set("google.bigtable.project.id", projectId);
        conf.set("google.bigtable.instance.id", instanceId);
        return BigtableConfiguration.injectBigtableImpls(conf);
    }

    public static Configuration configure(Configuration conf, String projectId, String instanceId, String appProfileId) {
        conf.set("google.bigtable.project.id", projectId);
        conf.set("google.bigtable.instance.id", instanceId);
        conf.set("google.bigtable.app_profile.id", appProfileId);
        return BigtableConfiguration.injectBigtableImpls(conf);
    }

    public static Configuration withCredentials(Configuration conf, Credentials credentials) {
        return new BigtableExtendedConfiguration(conf, credentials);
    }

    @Deprecated
    public static Configuration asyncConfigure(Configuration conf) {
        conf.set(HBASE_CLIENT_ASYNC_CONNECTION_IMPL, BIGTABLE_HBASE_CLIENT_ASYNC_CONNECTION_CLASS);
        conf.set(HBASE_CLIENT_ASYNC_REGISTRY_IMPL, BigtableAsyncRegistry.getSubClass().getName());
        return conf;
    }

    public static Connection connect(String projectId, String instanceId) {
        return BigtableConfiguration.connect(BigtableConfiguration.configure(projectId, instanceId));
    }

    public static Connection connect(String projectId, String instanceId, String appProfileId) {
        return BigtableConfiguration.connect(BigtableConfiguration.configure(projectId, instanceId, appProfileId));
    }

    public static Connection connect(Configuration conf) {
        Class<? extends Connection> connectionClass = BigtableConfiguration.getConnectionClass();
        try {
            return connectionClass.getConstructor(Configuration.class).newInstance(conf);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not find an appropriate constructor for " + CONNECTION_CLASS.getCanonicalName(), e);
        }
    }
}

