/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;

@InternalApi(value="For internal usage only")
@NotThreadSafe
public class FilterAdapterContext {
    private final Scan scan;
    private Deque<FilterList> filterListStack;
    private ReadHooks readHooks;
    private int counter;
    private final List<WhileMatchFilter> whileMatchFilters = new ArrayList<WhileMatchFilter>();

    public FilterAdapterContext(Scan scan, ReadHooks readHooks) {
        this.scan = scan;
        this.filterListStack = new ArrayDeque<FilterList>();
        this.readHooks = readHooks;
    }

    Scan getScan() {
        return this.scan;
    }

    public ContextCloseable beginFilterList(final FilterList lst) {
        Preconditions.checkNotNull((Object)lst);
        this.filterListStack.push(lst);
        return new ContextCloseable(){

            @Override
            public void close() {
                Preconditions.checkState((boolean)((FilterList)FilterAdapterContext.this.filterListStack.peek()).equals((Object)lst));
                FilterAdapterContext.this.filterListStack.pop();
            }
        };
    }

    public int getFilterListDepth() {
        return this.filterListStack.size();
    }

    public Optional<FilterList> getCurrentFilterList() {
        if (this.filterListStack.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)this.filterListStack.peek());
    }

    public ReadHooks getReadHooks() {
        return this.readHooks;
    }

    public String getNextUniqueId() {
        return String.valueOf(++this.counter);
    }

    @VisibleForTesting
    String getCurrentUniqueId() {
        return String.valueOf(this.counter);
    }

    public void addWhileMatchFilter(WhileMatchFilter filter) {
        this.whileMatchFilters.add(filter);
    }

    public int getNumberOfWhileMatchFilters() {
        return this.whileMatchFilters.size();
    }

    Collection<FilterList> getCurrentFilterLists() {
        return Collections.unmodifiableCollection(this.filterListStack);
    }

    public static interface ContextCloseable
    extends AutoCloseable {
        @Override
        public void close();
    }
}

