/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.hbase.adapters.ResponseAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.RowCell;
import com.google.cloud.bigtable.hbase.util.ByteStringer;
import com.google.cloud.bigtable.hbase.util.TimestampConverter;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

@InternalApi(value="For internal usage only")
public class RowAdapter
implements ResponseAdapter<Row, Result> {
    @Override
    public Result adaptResponse(Row response) {
        if (response == null) {
            return Result.EMPTY_RESULT;
        }
        TreeSet<RowCell> hbaseCells = new TreeSet<RowCell>((Comparator<RowCell>)KeyValue.COMPARATOR);
        byte[] rowKey = response.getKey().toByteArray();
        for (com.google.cloud.bigtable.data.v2.models.RowCell rowCell : response.getCells()) {
            byte[] familyNameBytes = Bytes.toBytes((String)rowCell.getFamily());
            byte[] columnQualifier = ByteStringer.extract(rowCell.getQualifier());
            long hbaseTimestamp = TimestampConverter.bigtable2hbase(rowCell.getTimestamp());
            RowCell keyValue = new RowCell(rowKey, familyNameBytes, columnQualifier, hbaseTimestamp, ByteStringer.extract(rowCell.getValue()));
            hbaseCells.add(keyValue);
        }
        return Result.create((Cell[])hbaseCells.toArray(new Cell[hbaseCells.size()]));
    }
}

