/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.Batcher;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.hbase.wrappers.BulkMutationWrapper;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.common.base.Preconditions;
import java.io.IOException;

@InternalApi(value="For internal usage only")
public class BulkMutationVeneerApi
implements BulkMutationWrapper {
    private final Meter mutationAdded = BigtableClientMetrics.meter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"bulk-mutator.mutations.added");
    private final Batcher<RowMutationEntry, Void> bulkMutateBatcher;

    BulkMutationVeneerApi(Batcher<RowMutationEntry, Void> bulkMutateBatcher) {
        this.bulkMutateBatcher = bulkMutateBatcher;
    }

    @Override
    public synchronized ApiFuture<Void> add(RowMutationEntry rowMutation) {
        Preconditions.checkNotNull((Object)rowMutation, (Object)"mutation details cannot be null");
        this.mutationAdded.mark();
        return this.bulkMutateBatcher.add((Object)rowMutation);
    }

    @Override
    public synchronized void sendUnsent() {
        this.bulkMutateBatcher.sendOutstanding();
    }

    @Override
    public synchronized void flush() {
        try {
            this.bulkMutateBatcher.flush();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Could not complete RPC for current Batch", ex);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.bulkMutateBatcher.close();
        }
        catch (InterruptedException e) {
            throw new IOException("Could not close the bulk mutation Batcher", e);
        }
    }
}

