/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.FixedWatchdogProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.Watchdog;
import com.google.auth.Credentials;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.hbase.wrappers.DataClientWrapper;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BigtableHBaseVeneerSettings;
import com.google.cloud.bigtable.hbase.wrappers.veneer.BigtableVeneerApi;
import com.google.cloud.bigtable.hbase.wrappers.veneer.DataClientVeneerApi;
import com.google.cloud.bigtable.hbase.wrappers.veneer.SharedDataClientWrapper;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;

class SharedDataClientWrapperFactory {
    private final Map<Key, ClientContext> cachedContexts = new HashMap<Key, ClientContext>();
    private final Map<Key, Integer> refCounts = new HashMap<Key, Integer>();
    private final Map<Key, Integer> channelPoolSizes = new HashMap<Key, Integer>();

    SharedDataClientWrapperFactory() {
    }

    synchronized DataClientWrapper createDataClient(BigtableHBaseVeneerSettings settings) throws IOException {
        Preconditions.checkArgument((!settings.getDataSettings().isRefreshingChannel() ? 1 : 0) != 0, (Object)"Channel refreshing is not compatible with cached channel pools");
        Key key = Key.createFromSettings(settings.getDataSettings());
        ClientContext sharedCtx = this.cachedContexts.get(key);
        if (sharedCtx == null) {
            EnhancedBigtableStubSettings stubSettings = settings.getDataSettings().getStubSettings();
            sharedCtx = ClientContext.create((StubSettings)stubSettings);
            this.cachedContexts.put(key, sharedCtx);
            this.refCounts.put(key, 0);
            int channelPoolSize = BigtableVeneerApi.getChannelPoolSize(stubSettings);
            for (int i = 0; i < channelPoolSize; ++i) {
                BigtableClientMetrics.counter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.channel.active").inc();
            }
            this.channelPoolSizes.put(key, channelPoolSize);
        }
        this.refCounts.put(key, this.refCounts.get(key) + 1);
        try {
            BigtableDataSettings.Builder builder = settings.getDataSettings().toBuilder();
            ((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)builder.stubSettings().setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)sharedCtx.getTransportChannel()))).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)sharedCtx.getCredentials()))).setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)sharedCtx.getExecutor()))).setStreamWatchdogProvider(FixedWatchdogProvider.create((Watchdog)sharedCtx.getStreamWatchdog()))).setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((Map)sharedCtx.getHeaders()))).setClock(sharedCtx.getClock());
            BigtableDataSettings data = builder.build();
            return new SharedDataClientWrapper(this, key, new DataClientVeneerApi(BigtableDataClient.create((BigtableDataSettings)data), settings.getClientTimeouts()));
        }
        catch (IOException | RuntimeException e) {
            this.release(key);
            throw e;
        }
    }

    synchronized void release(Key key) {
        int refCount = this.refCounts.get(key);
        if (--refCount > 0) {
            this.refCounts.put(key, refCount);
            return;
        }
        this.refCounts.remove(key);
        ClientContext clientContext = this.cachedContexts.remove(key);
        for (int i = 0; i < this.channelPoolSizes.get(key); ++i) {
            BigtableClientMetrics.counter((BigtableClientMetrics.MetricLevel)BigtableClientMetrics.MetricLevel.Info, (String)"grpc.channel.active").dec();
        }
        this.channelPoolSizes.remove(key);
        for (BackgroundResource resource : clientContext.getBackgroundResources()) {
            resource.shutdown();
        }
    }

    static final class Key {
        private final String endpoint;
        private final Map<String, String> headers;
        private final CredentialsProvider credentialsProvider;

        static Key createFromSettings(BigtableDataSettings settings) {
            EnhancedBigtableStubSettings stubSettings = settings.getStubSettings();
            return new Key(stubSettings.getEndpoint(), stubSettings.getHeaderProvider().getHeaders(), stubSettings.getCredentialsProvider());
        }

        private Key(String endpoint, Map<String, String> headers, CredentialsProvider credentialsProvider) {
            this.endpoint = endpoint;
            this.headers = headers;
            this.credentialsProvider = credentialsProvider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equal((Object)this.endpoint, (Object)key.endpoint) && Objects.equal(this.headers, key.headers) && Objects.equal((Object)this.credentialsProvider, (Object)key.credentialsProvider);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.endpoint, this.headers, this.credentialsProvider});
        }
    }
}

