/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.AbstractStructReader;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.r2dbc.v2.JsonWrapper;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryConverters;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;

class ClientLibraryDecoder {
    private static final Map<Type, BiFunction<Struct, Integer, Object>> decodersMap = ClientLibraryDecoder.createDecoders();
    private static final Map<Type, BiFunction<Struct, Integer, Object>> arrayDecodersMap = ClientLibraryDecoder.createArrayDecoders();

    ClientLibraryDecoder() {
    }

    private static Map<Type, BiFunction<Struct, Integer, Object>> createArrayDecoders() {
        HashMap<Type, BiFunction<Struct, Integer, Object>> decoders = new HashMap<Type, BiFunction<Struct, Integer, Object>>();
        decoders.put(Type.array((Type)Type.int64()), AbstractStructReader::getLongArray);
        decoders.put(Type.array((Type)Type.float64()), AbstractStructReader::getDoubleArray);
        decoders.put(Type.array((Type)Type.bool()), AbstractStructReader::getBooleanArray);
        decoders.put(Type.array((Type)Type.string()), (struct, index) -> struct.getStringList(index.intValue()).toArray(new String[0]));
        return decoders;
    }

    private static Map<Type, BiFunction<Struct, Integer, Object>> createDecoders() {
        HashMap<Type, BiFunction<Struct, Integer, Object>> decoders = new HashMap<Type, BiFunction<Struct, Integer, Object>>();
        decoders.put(Type.int64(), AbstractStructReader::getLong);
        decoders.put(Type.array((Type)Type.int64()), AbstractStructReader::getLongList);
        decoders.put(Type.float64(), AbstractStructReader::getDouble);
        decoders.put(Type.array((Type)Type.float64()), AbstractStructReader::getDoubleList);
        decoders.put(Type.bool(), AbstractStructReader::getBoolean);
        decoders.put(Type.array((Type)Type.bool()), AbstractStructReader::getBooleanList);
        decoders.put(Type.bytes(), AbstractStructReader::getBytes);
        decoders.put(Type.array((Type)Type.bytes()), AbstractStructReader::getBytesList);
        decoders.put(Type.date(), AbstractStructReader::getDate);
        decoders.put(Type.array((Type)Type.date()), AbstractStructReader::getDateList);
        decoders.put(Type.string(), AbstractStructReader::getString);
        decoders.put(Type.array((Type)Type.string()), AbstractStructReader::getStringList);
        decoders.put(Type.timestamp(), AbstractStructReader::getTimestamp);
        decoders.put(Type.array((Type)Type.timestamp()), AbstractStructReader::getTimestampList);
        decoders.put(Type.numeric(), AbstractStructReader::getBigDecimal);
        decoders.put(Type.array((Type)Type.numeric()), AbstractStructReader::getBigDecimalList);
        decoders.put(Type.json(), AbstractStructReader::getJson);
        return decoders;
    }

    public static <T> T decode(Struct struct, int index, Class<T> type) {
        Map<Type, BiFunction<Struct, Integer, Object>> selectedCodecsMap = type.isArray() ? arrayDecodersMap : decodersMap;
        T value = struct.isNull(index) ? null : (T)ClientLibraryDecoder.readAndConvert(struct, index, selectedCodecsMap, type);
        return value;
    }

    private static <T> T readAndConvert(Struct struct, int index, Map<Type, BiFunction<Struct, Integer, Object>> selectedCodecsMap, Class<T> type) {
        Object value = selectedCodecsMap.get(struct.getColumnType(index)).apply(struct, index);
        if (struct.getColumnType(index) == Type.json()) {
            return (T)SpannerClientLibraryConverters.convert(value, JsonWrapper.class);
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return SpannerClientLibraryConverters.convert(value, type);
    }

    static Class<?> getDefaultJavaType(Type spannerType) {
        switch (spannerType.getCode()) {
            case BOOL: {
                return Boolean.class;
            }
            case INT64: {
                return Long.class;
            }
            case FLOAT64: {
                return Double.class;
            }
            case STRING: {
                return String.class;
            }
            case BYTES: {
                return ByteBuffer.class;
            }
            case TIMESTAMP: {
                return LocalDateTime.class;
            }
            case DATE: {
                return LocalDate.class;
            }
            case NUMERIC: {
                return BigDecimal.class;
            }
            case ARRAY: {
                return Array.newInstance(ClientLibraryDecoder.getDefaultJavaType(spannerType.getArrayElementType()), 0).getClass();
            }
            case JSON: {
                return JsonWrapper.class;
            }
        }
        return Object.class;
    }
}

