/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.r2dbc.v2;

import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.r2dbc.api.SpannerConnection;
import com.google.cloud.spanner.r2dbc.statement.StatementParser;
import com.google.cloud.spanner.r2dbc.statement.StatementType;
import com.google.cloud.spanner.r2dbc.v2.DatabaseClientReactiveAdapter;
import com.google.cloud.spanner.r2dbc.v2.SpannerBatch;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryDdlStatement;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryDmlStatement;
import com.google.cloud.spanner.r2dbc.v2.SpannerClientLibraryStatement;
import com.google.cloud.spanner.r2dbc.v2.SpannerConstants;
import com.google.common.base.MoreObjects;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Statement;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import java.time.Duration;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class SpannerClientLibraryConnection
implements Connection,
SpannerConnection {
    private final DatabaseClientReactiveAdapter clientLibraryAdapter;

    public SpannerClientLibraryConnection(DatabaseClientReactiveAdapter clientLibraryAdapter) {
        this.clientLibraryAdapter = clientLibraryAdapter;
    }

    public Publisher<Void> beginTransaction() {
        return this.clientLibraryAdapter.beginTransaction();
    }

    public Publisher<Void> beginTransaction(TransactionDefinition definition) {
        IsolationLevel isolationLevel = (IsolationLevel)MoreObjects.firstNonNull((Object)definition.getAttribute(TransactionDefinition.ISOLATION_LEVEL), (Object)IsolationLevel.SERIALIZABLE);
        return this.validateIsolation(isolationLevel).then(Mono.defer(() -> {
            boolean isReadOnly = Boolean.TRUE.equals(definition.getAttribute(TransactionDefinition.READ_ONLY));
            if (isReadOnly) {
                TimestampBound timestampBound = (TimestampBound)MoreObjects.firstNonNull((Object)definition.getAttribute(SpannerConstants.TIMESTAMP_BOUND), (Object)TimestampBound.strong());
                return this.clientLibraryAdapter.beginReadonlyTransaction(timestampBound);
            }
            return this.clientLibraryAdapter.beginTransaction();
        }));
    }

    public Publisher<Void> setLockWaitTimeout(Duration timeout) {
        return Mono.error((Throwable)new UnsupportedOperationException());
    }

    public Publisher<Void> setStatementTimeout(Duration timeout) {
        return Mono.error((Throwable)new UnsupportedOperationException());
    }

    @Override
    public Mono<Void> beginReadonlyTransaction(TimestampBound timestampBound) {
        return this.clientLibraryAdapter.beginReadonlyTransaction(timestampBound);
    }

    @Override
    public Mono<Void> beginReadonlyTransaction() {
        return this.clientLibraryAdapter.beginReadonlyTransaction(TimestampBound.strong());
    }

    public Publisher<Void> commitTransaction() {
        return this.clientLibraryAdapter.commitTransaction();
    }

    public Batch createBatch() {
        return new SpannerBatch(this.clientLibraryAdapter);
    }

    public Publisher<Void> createSavepoint(String name) {
        throw new UnsupportedOperationException();
    }

    public Statement createStatement(String query) {
        if (query == null) {
            throw new IllegalArgumentException("Invalid null query.");
        }
        StatementType type = StatementParser.getStatementType(query);
        if (type == StatementType.DDL) {
            return new SpannerClientLibraryDdlStatement(query, this.clientLibraryAdapter);
        }
        if (type == StatementType.DML) {
            return new SpannerClientLibraryDmlStatement(this.clientLibraryAdapter, query);
        }
        return new SpannerClientLibraryStatement(this.clientLibraryAdapter, query);
    }

    public boolean isAutoCommit() {
        return this.clientLibraryAdapter.isAutoCommit();
    }

    public ConnectionMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }

    public IsolationLevel getTransactionIsolationLevel() {
        return IsolationLevel.SERIALIZABLE;
    }

    public Publisher<Void> releaseSavepoint(String name) {
        throw new UnsupportedOperationException();
    }

    public Publisher<Void> rollbackTransaction() {
        return this.clientLibraryAdapter.rollback();
    }

    public Publisher<Void> rollbackTransactionToSavepoint(String name) {
        throw new UnsupportedOperationException();
    }

    public Publisher<Void> setAutoCommit(boolean autoCommit) {
        return this.clientLibraryAdapter.setAutoCommit(autoCommit);
    }

    public Publisher<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        return this.validateIsolation(isolationLevel);
    }

    public Publisher<Boolean> validate(ValidationDepth depth) {
        if (depth == ValidationDepth.LOCAL) {
            return this.clientLibraryAdapter.localHealthcheck();
        }
        return this.clientLibraryAdapter.healthCheck();
    }

    public Publisher<Void> close() {
        return this.clientLibraryAdapter.close();
    }

    @Override
    public boolean isInReadonlyTransaction() {
        return this.clientLibraryAdapter.isInReadonlyTransaction();
    }

    private Mono<Void> validateIsolation(IsolationLevel isolationLevel) {
        if (isolationLevel == null) {
            return Mono.error((Throwable)new IllegalArgumentException("IsolationLevel can't be null."));
        }
        return isolationLevel == IsolationLevel.SERIALIZABLE ? Mono.empty() : Mono.error((Throwable)new UnsupportedOperationException(String.format("Unsupported '%s' isolation level, Only SERIALIZABLE is supported.", isolationLevel.asSql())));
    }
}

