/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.aiplatform.v1beta1.Annotation;
import com.google.cloud.aiplatform.v1beta1.AnnotationSpec;
import com.google.cloud.aiplatform.v1beta1.AnnotationSpecName;
import com.google.cloud.aiplatform.v1beta1.CreateDatasetOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.CreateDatasetRequest;
import com.google.cloud.aiplatform.v1beta1.DataItem;
import com.google.cloud.aiplatform.v1beta1.DataItemName;
import com.google.cloud.aiplatform.v1beta1.DataItemView;
import com.google.cloud.aiplatform.v1beta1.Dataset;
import com.google.cloud.aiplatform.v1beta1.DatasetName;
import com.google.cloud.aiplatform.v1beta1.DatasetServiceSettings;
import com.google.cloud.aiplatform.v1beta1.DeleteDatasetRequest;
import com.google.cloud.aiplatform.v1beta1.DeleteOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ExportDataConfig;
import com.google.cloud.aiplatform.v1beta1.ExportDataOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ExportDataRequest;
import com.google.cloud.aiplatform.v1beta1.ExportDataResponse;
import com.google.cloud.aiplatform.v1beta1.GetAnnotationSpecRequest;
import com.google.cloud.aiplatform.v1beta1.GetDatasetRequest;
import com.google.cloud.aiplatform.v1beta1.ImportDataConfig;
import com.google.cloud.aiplatform.v1beta1.ImportDataOperationMetadata;
import com.google.cloud.aiplatform.v1beta1.ImportDataRequest;
import com.google.cloud.aiplatform.v1beta1.ImportDataResponse;
import com.google.cloud.aiplatform.v1beta1.ListAnnotationsRequest;
import com.google.cloud.aiplatform.v1beta1.ListAnnotationsResponse;
import com.google.cloud.aiplatform.v1beta1.ListDataItemsRequest;
import com.google.cloud.aiplatform.v1beta1.ListDataItemsResponse;
import com.google.cloud.aiplatform.v1beta1.ListDatasetsRequest;
import com.google.cloud.aiplatform.v1beta1.ListDatasetsResponse;
import com.google.cloud.aiplatform.v1beta1.ListSavedQueriesRequest;
import com.google.cloud.aiplatform.v1beta1.ListSavedQueriesResponse;
import com.google.cloud.aiplatform.v1beta1.LocationName;
import com.google.cloud.aiplatform.v1beta1.SavedQuery;
import com.google.cloud.aiplatform.v1beta1.SearchDataItemsRequest;
import com.google.cloud.aiplatform.v1beta1.SearchDataItemsResponse;
import com.google.cloud.aiplatform.v1beta1.UpdateDatasetRequest;
import com.google.cloud.aiplatform.v1beta1.stub.DatasetServiceStub;
import com.google.cloud.aiplatform.v1beta1.stub.DatasetServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DatasetServiceClient
implements BackgroundResource {
    private final DatasetServiceSettings settings;
    private final DatasetServiceStub stub;
    private final OperationsClient operationsClient;

    public static final DatasetServiceClient create() throws IOException {
        return DatasetServiceClient.create(DatasetServiceSettings.newBuilder().build());
    }

    public static final DatasetServiceClient create(DatasetServiceSettings settings) throws IOException {
        return new DatasetServiceClient(settings);
    }

    public static final DatasetServiceClient create(DatasetServiceStub stub) {
        return new DatasetServiceClient(stub);
    }

    protected DatasetServiceClient(DatasetServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DatasetServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected DatasetServiceClient(DatasetServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DatasetServiceSettings getSettings() {
        return this.settings;
    }

    public DatasetServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Dataset, CreateDatasetOperationMetadata> createDatasetAsync(LocationName parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataset(dataset).build();
        return this.createDatasetAsync(request);
    }

    public final OperationFuture<Dataset, CreateDatasetOperationMetadata> createDatasetAsync(String parent, Dataset dataset) {
        CreateDatasetRequest request = CreateDatasetRequest.newBuilder().setParent(parent).setDataset(dataset).build();
        return this.createDatasetAsync(request);
    }

    public final OperationFuture<Dataset, CreateDatasetOperationMetadata> createDatasetAsync(CreateDatasetRequest request) {
        return this.createDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDatasetRequest, Dataset, CreateDatasetOperationMetadata> createDatasetOperationCallable() {
        return this.stub.createDatasetOperationCallable();
    }

    public final UnaryCallable<CreateDatasetRequest, Operation> createDatasetCallable() {
        return this.stub.createDatasetCallable();
    }

    public final Dataset getDataset(DatasetName name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(String name) {
        GetDatasetRequest request = GetDatasetRequest.newBuilder().setName(name).build();
        return this.getDataset(request);
    }

    public final Dataset getDataset(GetDatasetRequest request) {
        return (Dataset)this.getDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<GetDatasetRequest, Dataset> getDatasetCallable() {
        return this.stub.getDatasetCallable();
    }

    public final Dataset updateDataset(Dataset dataset, FieldMask updateMask) {
        UpdateDatasetRequest request = UpdateDatasetRequest.newBuilder().setDataset(dataset).setUpdateMask(updateMask).build();
        return this.updateDataset(request);
    }

    public final Dataset updateDataset(UpdateDatasetRequest request) {
        return (Dataset)this.updateDatasetCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDatasetRequest, Dataset> updateDatasetCallable() {
        return this.stub.updateDatasetCallable();
    }

    public final ListDatasetsPagedResponse listDatasets(LocationName parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(String parent) {
        ListDatasetsRequest request = ListDatasetsRequest.newBuilder().setParent(parent).build();
        return this.listDatasets(request);
    }

    public final ListDatasetsPagedResponse listDatasets(ListDatasetsRequest request) {
        return (ListDatasetsPagedResponse)((Object)this.listDatasetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsPagedResponse> listDatasetsPagedCallable() {
        return this.stub.listDatasetsPagedCallable();
    }

    public final UnaryCallable<ListDatasetsRequest, ListDatasetsResponse> listDatasetsCallable() {
        return this.stub.listDatasetsCallable();
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteDatasetAsync(DatasetName name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDatasetAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteDatasetAsync(String name) {
        DeleteDatasetRequest request = DeleteDatasetRequest.newBuilder().setName(name).build();
        return this.deleteDatasetAsync(request);
    }

    public final OperationFuture<Empty, DeleteOperationMetadata> deleteDatasetAsync(DeleteDatasetRequest request) {
        return this.deleteDatasetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDatasetRequest, Empty, DeleteOperationMetadata> deleteDatasetOperationCallable() {
        return this.stub.deleteDatasetOperationCallable();
    }

    public final UnaryCallable<DeleteDatasetRequest, Operation> deleteDatasetCallable() {
        return this.stub.deleteDatasetCallable();
    }

    public final OperationFuture<ImportDataResponse, ImportDataOperationMetadata> importDataAsync(DatasetName name, List<ImportDataConfig> importConfigs) {
        ImportDataRequest request = ImportDataRequest.newBuilder().setName(name == null ? null : name.toString()).addAllImportConfigs(importConfigs).build();
        return this.importDataAsync(request);
    }

    public final OperationFuture<ImportDataResponse, ImportDataOperationMetadata> importDataAsync(String name, List<ImportDataConfig> importConfigs) {
        ImportDataRequest request = ImportDataRequest.newBuilder().setName(name).addAllImportConfigs(importConfigs).build();
        return this.importDataAsync(request);
    }

    public final OperationFuture<ImportDataResponse, ImportDataOperationMetadata> importDataAsync(ImportDataRequest request) {
        return this.importDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportDataRequest, ImportDataResponse, ImportDataOperationMetadata> importDataOperationCallable() {
        return this.stub.importDataOperationCallable();
    }

    public final UnaryCallable<ImportDataRequest, Operation> importDataCallable() {
        return this.stub.importDataCallable();
    }

    public final OperationFuture<ExportDataResponse, ExportDataOperationMetadata> exportDataAsync(DatasetName name, ExportDataConfig exportConfig) {
        ExportDataRequest request = ExportDataRequest.newBuilder().setName(name == null ? null : name.toString()).setExportConfig(exportConfig).build();
        return this.exportDataAsync(request);
    }

    public final OperationFuture<ExportDataResponse, ExportDataOperationMetadata> exportDataAsync(String name, ExportDataConfig exportConfig) {
        ExportDataRequest request = ExportDataRequest.newBuilder().setName(name).setExportConfig(exportConfig).build();
        return this.exportDataAsync(request);
    }

    public final OperationFuture<ExportDataResponse, ExportDataOperationMetadata> exportDataAsync(ExportDataRequest request) {
        return this.exportDataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportDataRequest, ExportDataResponse, ExportDataOperationMetadata> exportDataOperationCallable() {
        return this.stub.exportDataOperationCallable();
    }

    public final UnaryCallable<ExportDataRequest, Operation> exportDataCallable() {
        return this.stub.exportDataCallable();
    }

    public final ListDataItemsPagedResponse listDataItems(DatasetName parent) {
        ListDataItemsRequest request = ListDataItemsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataItems(request);
    }

    public final ListDataItemsPagedResponse listDataItems(String parent) {
        ListDataItemsRequest request = ListDataItemsRequest.newBuilder().setParent(parent).build();
        return this.listDataItems(request);
    }

    public final ListDataItemsPagedResponse listDataItems(ListDataItemsRequest request) {
        return (ListDataItemsPagedResponse)((Object)this.listDataItemsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataItemsRequest, ListDataItemsPagedResponse> listDataItemsPagedCallable() {
        return this.stub.listDataItemsPagedCallable();
    }

    public final UnaryCallable<ListDataItemsRequest, ListDataItemsResponse> listDataItemsCallable() {
        return this.stub.listDataItemsCallable();
    }

    public final SearchDataItemsPagedResponse searchDataItems(SearchDataItemsRequest request) {
        return (SearchDataItemsPagedResponse)((Object)this.searchDataItemsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchDataItemsRequest, SearchDataItemsPagedResponse> searchDataItemsPagedCallable() {
        return this.stub.searchDataItemsPagedCallable();
    }

    public final UnaryCallable<SearchDataItemsRequest, SearchDataItemsResponse> searchDataItemsCallable() {
        return this.stub.searchDataItemsCallable();
    }

    public final ListSavedQueriesPagedResponse listSavedQueries(DatasetName parent) {
        ListSavedQueriesRequest request = ListSavedQueriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSavedQueries(request);
    }

    public final ListSavedQueriesPagedResponse listSavedQueries(String parent) {
        ListSavedQueriesRequest request = ListSavedQueriesRequest.newBuilder().setParent(parent).build();
        return this.listSavedQueries(request);
    }

    public final ListSavedQueriesPagedResponse listSavedQueries(ListSavedQueriesRequest request) {
        return (ListSavedQueriesPagedResponse)((Object)this.listSavedQueriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSavedQueriesRequest, ListSavedQueriesPagedResponse> listSavedQueriesPagedCallable() {
        return this.stub.listSavedQueriesPagedCallable();
    }

    public final UnaryCallable<ListSavedQueriesRequest, ListSavedQueriesResponse> listSavedQueriesCallable() {
        return this.stub.listSavedQueriesCallable();
    }

    public final AnnotationSpec getAnnotationSpec(AnnotationSpecName name) {
        GetAnnotationSpecRequest request = GetAnnotationSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAnnotationSpec(request);
    }

    public final AnnotationSpec getAnnotationSpec(String name) {
        GetAnnotationSpecRequest request = GetAnnotationSpecRequest.newBuilder().setName(name).build();
        return this.getAnnotationSpec(request);
    }

    public final AnnotationSpec getAnnotationSpec(GetAnnotationSpecRequest request) {
        return (AnnotationSpec)this.getAnnotationSpecCallable().call((Object)request);
    }

    public final UnaryCallable<GetAnnotationSpecRequest, AnnotationSpec> getAnnotationSpecCallable() {
        return this.stub.getAnnotationSpecCallable();
    }

    public final ListAnnotationsPagedResponse listAnnotations(DataItemName parent) {
        ListAnnotationsRequest request = ListAnnotationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAnnotations(request);
    }

    public final ListAnnotationsPagedResponse listAnnotations(String parent) {
        ListAnnotationsRequest request = ListAnnotationsRequest.newBuilder().setParent(parent).build();
        return this.listAnnotations(request);
    }

    public final ListAnnotationsPagedResponse listAnnotations(ListAnnotationsRequest request) {
        return (ListAnnotationsPagedResponse)((Object)this.listAnnotationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAnnotationsRequest, ListAnnotationsPagedResponse> listAnnotationsPagedCallable() {
        return this.stub.listAnnotationsPagedCallable();
    }

    public final UnaryCallable<ListAnnotationsRequest, ListAnnotationsResponse> listAnnotationsCallable() {
        return this.stub.listAnnotationsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAnnotationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAnnotationsRequest, ListAnnotationsResponse, Annotation, ListAnnotationsPage, ListAnnotationsFixedSizeCollection> {
        private ListAnnotationsFixedSizeCollection(List<ListAnnotationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAnnotationsFixedSizeCollection createEmptyCollection() {
            return new ListAnnotationsFixedSizeCollection(null, 0);
        }

        protected ListAnnotationsFixedSizeCollection createCollection(List<ListAnnotationsPage> pages, int collectionSize) {
            return new ListAnnotationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAnnotationsPage
    extends AbstractPage<ListAnnotationsRequest, ListAnnotationsResponse, Annotation, ListAnnotationsPage> {
        private ListAnnotationsPage(PageContext<ListAnnotationsRequest, ListAnnotationsResponse, Annotation> context, ListAnnotationsResponse response) {
            super(context, (Object)response);
        }

        private static ListAnnotationsPage createEmptyPage() {
            return new ListAnnotationsPage(null, null);
        }

        protected ListAnnotationsPage createPage(PageContext<ListAnnotationsRequest, ListAnnotationsResponse, Annotation> context, ListAnnotationsResponse response) {
            return new ListAnnotationsPage(context, response);
        }

        public ApiFuture<ListAnnotationsPage> createPageAsync(PageContext<ListAnnotationsRequest, ListAnnotationsResponse, Annotation> context, ApiFuture<ListAnnotationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAnnotationsPagedResponse
    extends AbstractPagedListResponse<ListAnnotationsRequest, ListAnnotationsResponse, Annotation, ListAnnotationsPage, ListAnnotationsFixedSizeCollection> {
        public static ApiFuture<ListAnnotationsPagedResponse> createAsync(PageContext<ListAnnotationsRequest, ListAnnotationsResponse, Annotation> context, ApiFuture<ListAnnotationsResponse> futureResponse) {
            ApiFuture<ListAnnotationsPage> futurePage = ListAnnotationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAnnotationsPagedResponse((ListAnnotationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAnnotationsPagedResponse(ListAnnotationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAnnotationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSavedQueriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery, ListSavedQueriesPage, ListSavedQueriesFixedSizeCollection> {
        private ListSavedQueriesFixedSizeCollection(List<ListSavedQueriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSavedQueriesFixedSizeCollection createEmptyCollection() {
            return new ListSavedQueriesFixedSizeCollection(null, 0);
        }

        protected ListSavedQueriesFixedSizeCollection createCollection(List<ListSavedQueriesPage> pages, int collectionSize) {
            return new ListSavedQueriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSavedQueriesPage
    extends AbstractPage<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery, ListSavedQueriesPage> {
        private ListSavedQueriesPage(PageContext<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery> context, ListSavedQueriesResponse response) {
            super(context, (Object)response);
        }

        private static ListSavedQueriesPage createEmptyPage() {
            return new ListSavedQueriesPage(null, null);
        }

        protected ListSavedQueriesPage createPage(PageContext<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery> context, ListSavedQueriesResponse response) {
            return new ListSavedQueriesPage(context, response);
        }

        public ApiFuture<ListSavedQueriesPage> createPageAsync(PageContext<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery> context, ApiFuture<ListSavedQueriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSavedQueriesPagedResponse
    extends AbstractPagedListResponse<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery, ListSavedQueriesPage, ListSavedQueriesFixedSizeCollection> {
        public static ApiFuture<ListSavedQueriesPagedResponse> createAsync(PageContext<ListSavedQueriesRequest, ListSavedQueriesResponse, SavedQuery> context, ApiFuture<ListSavedQueriesResponse> futureResponse) {
            ApiFuture<ListSavedQueriesPage> futurePage = ListSavedQueriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSavedQueriesPagedResponse((ListSavedQueriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSavedQueriesPagedResponse(ListSavedQueriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSavedQueriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchDataItemsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchDataItemsRequest, SearchDataItemsResponse, DataItemView, SearchDataItemsPage, SearchDataItemsFixedSizeCollection> {
        private SearchDataItemsFixedSizeCollection(List<SearchDataItemsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchDataItemsFixedSizeCollection createEmptyCollection() {
            return new SearchDataItemsFixedSizeCollection(null, 0);
        }

        protected SearchDataItemsFixedSizeCollection createCollection(List<SearchDataItemsPage> pages, int collectionSize) {
            return new SearchDataItemsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchDataItemsPage
    extends AbstractPage<SearchDataItemsRequest, SearchDataItemsResponse, DataItemView, SearchDataItemsPage> {
        private SearchDataItemsPage(PageContext<SearchDataItemsRequest, SearchDataItemsResponse, DataItemView> context, SearchDataItemsResponse response) {
            super(context, (Object)response);
        }

        private static SearchDataItemsPage createEmptyPage() {
            return new SearchDataItemsPage(null, null);
        }

        protected SearchDataItemsPage createPage(PageContext<SearchDataItemsRequest, SearchDataItemsResponse, DataItemView> context, SearchDataItemsResponse response) {
            return new SearchDataItemsPage(context, response);
        }

        public ApiFuture<SearchDataItemsPage> createPageAsync(PageContext<SearchDataItemsRequest, SearchDataItemsResponse, DataItemView> context, ApiFuture<SearchDataItemsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchDataItemsPagedResponse
    extends AbstractPagedListResponse<SearchDataItemsRequest, SearchDataItemsResponse, DataItemView, SearchDataItemsPage, SearchDataItemsFixedSizeCollection> {
        public static ApiFuture<SearchDataItemsPagedResponse> createAsync(PageContext<SearchDataItemsRequest, SearchDataItemsResponse, DataItemView> context, ApiFuture<SearchDataItemsResponse> futureResponse) {
            ApiFuture<SearchDataItemsPage> futurePage = SearchDataItemsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchDataItemsPagedResponse((SearchDataItemsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchDataItemsPagedResponse(SearchDataItemsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchDataItemsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDataItemsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataItemsRequest, ListDataItemsResponse, DataItem, ListDataItemsPage, ListDataItemsFixedSizeCollection> {
        private ListDataItemsFixedSizeCollection(List<ListDataItemsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataItemsFixedSizeCollection createEmptyCollection() {
            return new ListDataItemsFixedSizeCollection(null, 0);
        }

        protected ListDataItemsFixedSizeCollection createCollection(List<ListDataItemsPage> pages, int collectionSize) {
            return new ListDataItemsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataItemsPage
    extends AbstractPage<ListDataItemsRequest, ListDataItemsResponse, DataItem, ListDataItemsPage> {
        private ListDataItemsPage(PageContext<ListDataItemsRequest, ListDataItemsResponse, DataItem> context, ListDataItemsResponse response) {
            super(context, (Object)response);
        }

        private static ListDataItemsPage createEmptyPage() {
            return new ListDataItemsPage(null, null);
        }

        protected ListDataItemsPage createPage(PageContext<ListDataItemsRequest, ListDataItemsResponse, DataItem> context, ListDataItemsResponse response) {
            return new ListDataItemsPage(context, response);
        }

        public ApiFuture<ListDataItemsPage> createPageAsync(PageContext<ListDataItemsRequest, ListDataItemsResponse, DataItem> context, ApiFuture<ListDataItemsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataItemsPagedResponse
    extends AbstractPagedListResponse<ListDataItemsRequest, ListDataItemsResponse, DataItem, ListDataItemsPage, ListDataItemsFixedSizeCollection> {
        public static ApiFuture<ListDataItemsPagedResponse> createAsync(PageContext<ListDataItemsRequest, ListDataItemsResponse, DataItem> context, ApiFuture<ListDataItemsResponse> futureResponse) {
            ApiFuture<ListDataItemsPage> futurePage = ListDataItemsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataItemsPagedResponse((ListDataItemsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataItemsPagedResponse(ListDataItemsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataItemsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDatasetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        private ListDatasetsFixedSizeCollection(List<ListDatasetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDatasetsFixedSizeCollection createEmptyCollection() {
            return new ListDatasetsFixedSizeCollection(null, 0);
        }

        protected ListDatasetsFixedSizeCollection createCollection(List<ListDatasetsPage> pages, int collectionSize) {
            return new ListDatasetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDatasetsPage
    extends AbstractPage<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage> {
        private ListDatasetsPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            super(context, (Object)response);
        }

        private static ListDatasetsPage createEmptyPage() {
            return new ListDatasetsPage(null, null);
        }

        protected ListDatasetsPage createPage(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ListDatasetsResponse response) {
            return new ListDatasetsPage(context, response);
        }

        public ApiFuture<ListDatasetsPage> createPageAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDatasetsPagedResponse
    extends AbstractPagedListResponse<ListDatasetsRequest, ListDatasetsResponse, Dataset, ListDatasetsPage, ListDatasetsFixedSizeCollection> {
        public static ApiFuture<ListDatasetsPagedResponse> createAsync(PageContext<ListDatasetsRequest, ListDatasetsResponse, Dataset> context, ApiFuture<ListDatasetsResponse> futureResponse) {
            ApiFuture<ListDatasetsPage> futurePage = ListDatasetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDatasetsPagedResponse((ListDatasetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDatasetsPagedResponse(ListDatasetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDatasetsFixedSizeCollection.createEmptyCollection());
        }
    }
}

