/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.apigeeregistry.v1;

import com.google.api.HttpBody;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.apigeeregistry.v1.Api;
import com.google.cloud.apigeeregistry.v1.ApiDeployment;
import com.google.cloud.apigeeregistry.v1.ApiDeploymentName;
import com.google.cloud.apigeeregistry.v1.ApiName;
import com.google.cloud.apigeeregistry.v1.ApiSpec;
import com.google.cloud.apigeeregistry.v1.ApiSpecName;
import com.google.cloud.apigeeregistry.v1.ApiVersion;
import com.google.cloud.apigeeregistry.v1.ApiVersionName;
import com.google.cloud.apigeeregistry.v1.Artifact;
import com.google.cloud.apigeeregistry.v1.ArtifactName;
import com.google.cloud.apigeeregistry.v1.CreateApiDeploymentRequest;
import com.google.cloud.apigeeregistry.v1.CreateApiRequest;
import com.google.cloud.apigeeregistry.v1.CreateApiSpecRequest;
import com.google.cloud.apigeeregistry.v1.CreateApiVersionRequest;
import com.google.cloud.apigeeregistry.v1.CreateArtifactRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiDeploymentRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiDeploymentRevisionRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiSpecRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiSpecRevisionRequest;
import com.google.cloud.apigeeregistry.v1.DeleteApiVersionRequest;
import com.google.cloud.apigeeregistry.v1.DeleteArtifactRequest;
import com.google.cloud.apigeeregistry.v1.GetApiDeploymentRequest;
import com.google.cloud.apigeeregistry.v1.GetApiRequest;
import com.google.cloud.apigeeregistry.v1.GetApiSpecContentsRequest;
import com.google.cloud.apigeeregistry.v1.GetApiSpecRequest;
import com.google.cloud.apigeeregistry.v1.GetApiVersionRequest;
import com.google.cloud.apigeeregistry.v1.GetArtifactContentsRequest;
import com.google.cloud.apigeeregistry.v1.GetArtifactRequest;
import com.google.cloud.apigeeregistry.v1.ListApiDeploymentRevisionsRequest;
import com.google.cloud.apigeeregistry.v1.ListApiDeploymentRevisionsResponse;
import com.google.cloud.apigeeregistry.v1.ListApiDeploymentsRequest;
import com.google.cloud.apigeeregistry.v1.ListApiDeploymentsResponse;
import com.google.cloud.apigeeregistry.v1.ListApiSpecRevisionsRequest;
import com.google.cloud.apigeeregistry.v1.ListApiSpecRevisionsResponse;
import com.google.cloud.apigeeregistry.v1.ListApiSpecsRequest;
import com.google.cloud.apigeeregistry.v1.ListApiSpecsResponse;
import com.google.cloud.apigeeregistry.v1.ListApiVersionsRequest;
import com.google.cloud.apigeeregistry.v1.ListApiVersionsResponse;
import com.google.cloud.apigeeregistry.v1.ListApisRequest;
import com.google.cloud.apigeeregistry.v1.ListApisResponse;
import com.google.cloud.apigeeregistry.v1.ListArtifactsRequest;
import com.google.cloud.apigeeregistry.v1.ListArtifactsResponse;
import com.google.cloud.apigeeregistry.v1.LocationName;
import com.google.cloud.apigeeregistry.v1.RegistrySettings;
import com.google.cloud.apigeeregistry.v1.ReplaceArtifactRequest;
import com.google.cloud.apigeeregistry.v1.RollbackApiDeploymentRequest;
import com.google.cloud.apigeeregistry.v1.RollbackApiSpecRequest;
import com.google.cloud.apigeeregistry.v1.TagApiDeploymentRevisionRequest;
import com.google.cloud.apigeeregistry.v1.TagApiSpecRevisionRequest;
import com.google.cloud.apigeeregistry.v1.UpdateApiDeploymentRequest;
import com.google.cloud.apigeeregistry.v1.UpdateApiRequest;
import com.google.cloud.apigeeregistry.v1.UpdateApiSpecRequest;
import com.google.cloud.apigeeregistry.v1.UpdateApiVersionRequest;
import com.google.cloud.apigeeregistry.v1.stub.RegistryStub;
import com.google.cloud.apigeeregistry.v1.stub.RegistryStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegistryClient
implements BackgroundResource {
    private final RegistrySettings settings;
    private final RegistryStub stub;

    public static final RegistryClient create() throws IOException {
        return RegistryClient.create(RegistrySettings.newBuilder().build());
    }

    public static final RegistryClient create(RegistrySettings settings) throws IOException {
        return new RegistryClient(settings);
    }

    public static final RegistryClient create(RegistryStub stub) {
        return new RegistryClient(stub);
    }

    protected RegistryClient(RegistrySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegistryStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegistryClient(RegistryStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegistrySettings getSettings() {
        return this.settings;
    }

    public RegistryStub getStub() {
        return this.stub;
    }

    public final ListApisPagedResponse listApis(LocationName parent) {
        ListApisRequest request = ListApisRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApis(request);
    }

    public final ListApisPagedResponse listApis(String parent) {
        ListApisRequest request = ListApisRequest.newBuilder().setParent(parent).build();
        return this.listApis(request);
    }

    public final ListApisPagedResponse listApis(ListApisRequest request) {
        return (ListApisPagedResponse)((Object)this.listApisPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApisRequest, ListApisPagedResponse> listApisPagedCallable() {
        return this.stub.listApisPagedCallable();
    }

    public final UnaryCallable<ListApisRequest, ListApisResponse> listApisCallable() {
        return this.stub.listApisCallable();
    }

    public final Api getApi(ApiName name) {
        GetApiRequest request = GetApiRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApi(request);
    }

    public final Api getApi(String name) {
        GetApiRequest request = GetApiRequest.newBuilder().setName(name).build();
        return this.getApi(request);
    }

    public final Api getApi(GetApiRequest request) {
        return (Api)this.getApiCallable().call((Object)request);
    }

    public final UnaryCallable<GetApiRequest, Api> getApiCallable() {
        return this.stub.getApiCallable();
    }

    public final Api createApi(LocationName parent, Api api, String apiId) {
        CreateApiRequest request = CreateApiRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApi(api).setApiId(apiId).build();
        return this.createApi(request);
    }

    public final Api createApi(String parent, Api api, String apiId) {
        CreateApiRequest request = CreateApiRequest.newBuilder().setParent(parent).setApi(api).setApiId(apiId).build();
        return this.createApi(request);
    }

    public final Api createApi(CreateApiRequest request) {
        return (Api)this.createApiCallable().call((Object)request);
    }

    public final UnaryCallable<CreateApiRequest, Api> createApiCallable() {
        return this.stub.createApiCallable();
    }

    public final Api updateApi(Api api, FieldMask updateMask) {
        UpdateApiRequest request = UpdateApiRequest.newBuilder().setApi(api).setUpdateMask(updateMask).build();
        return this.updateApi(request);
    }

    public final Api updateApi(UpdateApiRequest request) {
        return (Api)this.updateApiCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateApiRequest, Api> updateApiCallable() {
        return this.stub.updateApiCallable();
    }

    public final void deleteApi(ApiName name) {
        DeleteApiRequest request = DeleteApiRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteApi(request);
    }

    public final void deleteApi(String name) {
        DeleteApiRequest request = DeleteApiRequest.newBuilder().setName(name).build();
        this.deleteApi(request);
    }

    public final void deleteApi(DeleteApiRequest request) {
        this.deleteApiCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteApiRequest, Empty> deleteApiCallable() {
        return this.stub.deleteApiCallable();
    }

    public final ListApiVersionsPagedResponse listApiVersions(ApiName parent) {
        ListApiVersionsRequest request = ListApiVersionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApiVersions(request);
    }

    public final ListApiVersionsPagedResponse listApiVersions(String parent) {
        ListApiVersionsRequest request = ListApiVersionsRequest.newBuilder().setParent(parent).build();
        return this.listApiVersions(request);
    }

    public final ListApiVersionsPagedResponse listApiVersions(ListApiVersionsRequest request) {
        return (ListApiVersionsPagedResponse)((Object)this.listApiVersionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApiVersionsRequest, ListApiVersionsPagedResponse> listApiVersionsPagedCallable() {
        return this.stub.listApiVersionsPagedCallable();
    }

    public final UnaryCallable<ListApiVersionsRequest, ListApiVersionsResponse> listApiVersionsCallable() {
        return this.stub.listApiVersionsCallable();
    }

    public final ApiVersion getApiVersion(ApiVersionName name) {
        GetApiVersionRequest request = GetApiVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApiVersion(request);
    }

    public final ApiVersion getApiVersion(String name) {
        GetApiVersionRequest request = GetApiVersionRequest.newBuilder().setName(name).build();
        return this.getApiVersion(request);
    }

    public final ApiVersion getApiVersion(GetApiVersionRequest request) {
        return (ApiVersion)this.getApiVersionCallable().call((Object)request);
    }

    public final UnaryCallable<GetApiVersionRequest, ApiVersion> getApiVersionCallable() {
        return this.stub.getApiVersionCallable();
    }

    public final ApiVersion createApiVersion(ApiName parent, ApiVersion apiVersion, String apiVersionId) {
        CreateApiVersionRequest request = CreateApiVersionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApiVersion(apiVersion).setApiVersionId(apiVersionId).build();
        return this.createApiVersion(request);
    }

    public final ApiVersion createApiVersion(String parent, ApiVersion apiVersion, String apiVersionId) {
        CreateApiVersionRequest request = CreateApiVersionRequest.newBuilder().setParent(parent).setApiVersion(apiVersion).setApiVersionId(apiVersionId).build();
        return this.createApiVersion(request);
    }

    public final ApiVersion createApiVersion(CreateApiVersionRequest request) {
        return (ApiVersion)this.createApiVersionCallable().call((Object)request);
    }

    public final UnaryCallable<CreateApiVersionRequest, ApiVersion> createApiVersionCallable() {
        return this.stub.createApiVersionCallable();
    }

    public final ApiVersion updateApiVersion(ApiVersion apiVersion, FieldMask updateMask) {
        UpdateApiVersionRequest request = UpdateApiVersionRequest.newBuilder().setApiVersion(apiVersion).setUpdateMask(updateMask).build();
        return this.updateApiVersion(request);
    }

    public final ApiVersion updateApiVersion(UpdateApiVersionRequest request) {
        return (ApiVersion)this.updateApiVersionCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateApiVersionRequest, ApiVersion> updateApiVersionCallable() {
        return this.stub.updateApiVersionCallable();
    }

    public final void deleteApiVersion(ApiVersionName name) {
        DeleteApiVersionRequest request = DeleteApiVersionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteApiVersion(request);
    }

    public final void deleteApiVersion(String name) {
        DeleteApiVersionRequest request = DeleteApiVersionRequest.newBuilder().setName(name).build();
        this.deleteApiVersion(request);
    }

    public final void deleteApiVersion(DeleteApiVersionRequest request) {
        this.deleteApiVersionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteApiVersionRequest, Empty> deleteApiVersionCallable() {
        return this.stub.deleteApiVersionCallable();
    }

    public final ListApiSpecsPagedResponse listApiSpecs(ApiVersionName parent) {
        ListApiSpecsRequest request = ListApiSpecsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApiSpecs(request);
    }

    public final ListApiSpecsPagedResponse listApiSpecs(String parent) {
        ListApiSpecsRequest request = ListApiSpecsRequest.newBuilder().setParent(parent).build();
        return this.listApiSpecs(request);
    }

    public final ListApiSpecsPagedResponse listApiSpecs(ListApiSpecsRequest request) {
        return (ListApiSpecsPagedResponse)((Object)this.listApiSpecsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApiSpecsRequest, ListApiSpecsPagedResponse> listApiSpecsPagedCallable() {
        return this.stub.listApiSpecsPagedCallable();
    }

    public final UnaryCallable<ListApiSpecsRequest, ListApiSpecsResponse> listApiSpecsCallable() {
        return this.stub.listApiSpecsCallable();
    }

    public final ApiSpec getApiSpec(ApiSpecName name) {
        GetApiSpecRequest request = GetApiSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApiSpec(request);
    }

    public final ApiSpec getApiSpec(String name) {
        GetApiSpecRequest request = GetApiSpecRequest.newBuilder().setName(name).build();
        return this.getApiSpec(request);
    }

    public final ApiSpec getApiSpec(GetApiSpecRequest request) {
        return (ApiSpec)this.getApiSpecCallable().call((Object)request);
    }

    public final UnaryCallable<GetApiSpecRequest, ApiSpec> getApiSpecCallable() {
        return this.stub.getApiSpecCallable();
    }

    public final HttpBody getApiSpecContents(ApiSpecName name) {
        GetApiSpecContentsRequest request = GetApiSpecContentsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApiSpecContents(request);
    }

    public final HttpBody getApiSpecContents(String name) {
        GetApiSpecContentsRequest request = GetApiSpecContentsRequest.newBuilder().setName(name).build();
        return this.getApiSpecContents(request);
    }

    public final HttpBody getApiSpecContents(GetApiSpecContentsRequest request) {
        return (HttpBody)this.getApiSpecContentsCallable().call((Object)request);
    }

    public final UnaryCallable<GetApiSpecContentsRequest, HttpBody> getApiSpecContentsCallable() {
        return this.stub.getApiSpecContentsCallable();
    }

    public final ApiSpec createApiSpec(ApiVersionName parent, ApiSpec apiSpec, String apiSpecId) {
        CreateApiSpecRequest request = CreateApiSpecRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApiSpec(apiSpec).setApiSpecId(apiSpecId).build();
        return this.createApiSpec(request);
    }

    public final ApiSpec createApiSpec(String parent, ApiSpec apiSpec, String apiSpecId) {
        CreateApiSpecRequest request = CreateApiSpecRequest.newBuilder().setParent(parent).setApiSpec(apiSpec).setApiSpecId(apiSpecId).build();
        return this.createApiSpec(request);
    }

    public final ApiSpec createApiSpec(CreateApiSpecRequest request) {
        return (ApiSpec)this.createApiSpecCallable().call((Object)request);
    }

    public final UnaryCallable<CreateApiSpecRequest, ApiSpec> createApiSpecCallable() {
        return this.stub.createApiSpecCallable();
    }

    public final ApiSpec updateApiSpec(ApiSpec apiSpec, FieldMask updateMask) {
        UpdateApiSpecRequest request = UpdateApiSpecRequest.newBuilder().setApiSpec(apiSpec).setUpdateMask(updateMask).build();
        return this.updateApiSpec(request);
    }

    public final ApiSpec updateApiSpec(UpdateApiSpecRequest request) {
        return (ApiSpec)this.updateApiSpecCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateApiSpecRequest, ApiSpec> updateApiSpecCallable() {
        return this.stub.updateApiSpecCallable();
    }

    public final void deleteApiSpec(ApiSpecName name) {
        DeleteApiSpecRequest request = DeleteApiSpecRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteApiSpec(request);
    }

    public final void deleteApiSpec(String name) {
        DeleteApiSpecRequest request = DeleteApiSpecRequest.newBuilder().setName(name).build();
        this.deleteApiSpec(request);
    }

    public final void deleteApiSpec(DeleteApiSpecRequest request) {
        this.deleteApiSpecCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteApiSpecRequest, Empty> deleteApiSpecCallable() {
        return this.stub.deleteApiSpecCallable();
    }

    public final ApiSpec tagApiSpecRevision(TagApiSpecRevisionRequest request) {
        return (ApiSpec)this.tagApiSpecRevisionCallable().call((Object)request);
    }

    public final UnaryCallable<TagApiSpecRevisionRequest, ApiSpec> tagApiSpecRevisionCallable() {
        return this.stub.tagApiSpecRevisionCallable();
    }

    public final ListApiSpecRevisionsPagedResponse listApiSpecRevisions(ListApiSpecRevisionsRequest request) {
        return (ListApiSpecRevisionsPagedResponse)((Object)this.listApiSpecRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApiSpecRevisionsRequest, ListApiSpecRevisionsPagedResponse> listApiSpecRevisionsPagedCallable() {
        return this.stub.listApiSpecRevisionsPagedCallable();
    }

    public final UnaryCallable<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse> listApiSpecRevisionsCallable() {
        return this.stub.listApiSpecRevisionsCallable();
    }

    public final ApiSpec rollbackApiSpec(RollbackApiSpecRequest request) {
        return (ApiSpec)this.rollbackApiSpecCallable().call((Object)request);
    }

    public final UnaryCallable<RollbackApiSpecRequest, ApiSpec> rollbackApiSpecCallable() {
        return this.stub.rollbackApiSpecCallable();
    }

    public final ApiSpec deleteApiSpecRevision(ApiSpecName name) {
        DeleteApiSpecRevisionRequest request = DeleteApiSpecRevisionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteApiSpecRevision(request);
    }

    public final ApiSpec deleteApiSpecRevision(String name) {
        DeleteApiSpecRevisionRequest request = DeleteApiSpecRevisionRequest.newBuilder().setName(name).build();
        return this.deleteApiSpecRevision(request);
    }

    public final ApiSpec deleteApiSpecRevision(DeleteApiSpecRevisionRequest request) {
        return (ApiSpec)this.deleteApiSpecRevisionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteApiSpecRevisionRequest, ApiSpec> deleteApiSpecRevisionCallable() {
        return this.stub.deleteApiSpecRevisionCallable();
    }

    public final ListApiDeploymentsPagedResponse listApiDeployments(ApiName parent) {
        ListApiDeploymentsRequest request = ListApiDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listApiDeployments(request);
    }

    public final ListApiDeploymentsPagedResponse listApiDeployments(String parent) {
        ListApiDeploymentsRequest request = ListApiDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listApiDeployments(request);
    }

    public final ListApiDeploymentsPagedResponse listApiDeployments(ListApiDeploymentsRequest request) {
        return (ListApiDeploymentsPagedResponse)((Object)this.listApiDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApiDeploymentsRequest, ListApiDeploymentsPagedResponse> listApiDeploymentsPagedCallable() {
        return this.stub.listApiDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListApiDeploymentsRequest, ListApiDeploymentsResponse> listApiDeploymentsCallable() {
        return this.stub.listApiDeploymentsCallable();
    }

    public final ApiDeployment getApiDeployment(ApiDeploymentName name) {
        GetApiDeploymentRequest request = GetApiDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getApiDeployment(request);
    }

    public final ApiDeployment getApiDeployment(String name) {
        GetApiDeploymentRequest request = GetApiDeploymentRequest.newBuilder().setName(name).build();
        return this.getApiDeployment(request);
    }

    public final ApiDeployment getApiDeployment(GetApiDeploymentRequest request) {
        return (ApiDeployment)this.getApiDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetApiDeploymentRequest, ApiDeployment> getApiDeploymentCallable() {
        return this.stub.getApiDeploymentCallable();
    }

    public final ApiDeployment createApiDeployment(ApiName parent, ApiDeployment apiDeployment, String apiDeploymentId) {
        CreateApiDeploymentRequest request = CreateApiDeploymentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setApiDeployment(apiDeployment).setApiDeploymentId(apiDeploymentId).build();
        return this.createApiDeployment(request);
    }

    public final ApiDeployment createApiDeployment(String parent, ApiDeployment apiDeployment, String apiDeploymentId) {
        CreateApiDeploymentRequest request = CreateApiDeploymentRequest.newBuilder().setParent(parent).setApiDeployment(apiDeployment).setApiDeploymentId(apiDeploymentId).build();
        return this.createApiDeployment(request);
    }

    public final ApiDeployment createApiDeployment(CreateApiDeploymentRequest request) {
        return (ApiDeployment)this.createApiDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateApiDeploymentRequest, ApiDeployment> createApiDeploymentCallable() {
        return this.stub.createApiDeploymentCallable();
    }

    public final ApiDeployment updateApiDeployment(ApiDeployment apiDeployment, FieldMask updateMask) {
        UpdateApiDeploymentRequest request = UpdateApiDeploymentRequest.newBuilder().setApiDeployment(apiDeployment).setUpdateMask(updateMask).build();
        return this.updateApiDeployment(request);
    }

    public final ApiDeployment updateApiDeployment(UpdateApiDeploymentRequest request) {
        return (ApiDeployment)this.updateApiDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateApiDeploymentRequest, ApiDeployment> updateApiDeploymentCallable() {
        return this.stub.updateApiDeploymentCallable();
    }

    public final void deleteApiDeployment(ApiDeploymentName name) {
        DeleteApiDeploymentRequest request = DeleteApiDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteApiDeployment(request);
    }

    public final void deleteApiDeployment(String name) {
        DeleteApiDeploymentRequest request = DeleteApiDeploymentRequest.newBuilder().setName(name).build();
        this.deleteApiDeployment(request);
    }

    public final void deleteApiDeployment(DeleteApiDeploymentRequest request) {
        this.deleteApiDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteApiDeploymentRequest, Empty> deleteApiDeploymentCallable() {
        return this.stub.deleteApiDeploymentCallable();
    }

    public final ApiDeployment tagApiDeploymentRevision(TagApiDeploymentRevisionRequest request) {
        return (ApiDeployment)this.tagApiDeploymentRevisionCallable().call((Object)request);
    }

    public final UnaryCallable<TagApiDeploymentRevisionRequest, ApiDeployment> tagApiDeploymentRevisionCallable() {
        return this.stub.tagApiDeploymentRevisionCallable();
    }

    public final ListApiDeploymentRevisionsPagedResponse listApiDeploymentRevisions(ListApiDeploymentRevisionsRequest request) {
        return (ListApiDeploymentRevisionsPagedResponse)((Object)this.listApiDeploymentRevisionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsPagedResponse> listApiDeploymentRevisionsPagedCallable() {
        return this.stub.listApiDeploymentRevisionsPagedCallable();
    }

    public final UnaryCallable<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse> listApiDeploymentRevisionsCallable() {
        return this.stub.listApiDeploymentRevisionsCallable();
    }

    public final ApiDeployment rollbackApiDeployment(RollbackApiDeploymentRequest request) {
        return (ApiDeployment)this.rollbackApiDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<RollbackApiDeploymentRequest, ApiDeployment> rollbackApiDeploymentCallable() {
        return this.stub.rollbackApiDeploymentCallable();
    }

    public final ApiDeployment deleteApiDeploymentRevision(ApiDeploymentName name) {
        DeleteApiDeploymentRevisionRequest request = DeleteApiDeploymentRevisionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteApiDeploymentRevision(request);
    }

    public final ApiDeployment deleteApiDeploymentRevision(String name) {
        DeleteApiDeploymentRevisionRequest request = DeleteApiDeploymentRevisionRequest.newBuilder().setName(name).build();
        return this.deleteApiDeploymentRevision(request);
    }

    public final ApiDeployment deleteApiDeploymentRevision(DeleteApiDeploymentRevisionRequest request) {
        return (ApiDeployment)this.deleteApiDeploymentRevisionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteApiDeploymentRevisionRequest, ApiDeployment> deleteApiDeploymentRevisionCallable() {
        return this.stub.deleteApiDeploymentRevisionCallable();
    }

    public final ListArtifactsPagedResponse listArtifacts(ApiDeploymentName parent) {
        ListArtifactsRequest request = ListArtifactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listArtifacts(request);
    }

    public final ListArtifactsPagedResponse listArtifacts(ApiName parent) {
        ListArtifactsRequest request = ListArtifactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listArtifacts(request);
    }

    public final ListArtifactsPagedResponse listArtifacts(ApiSpecName parent) {
        ListArtifactsRequest request = ListArtifactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listArtifacts(request);
    }

    public final ListArtifactsPagedResponse listArtifacts(ApiVersionName parent) {
        ListArtifactsRequest request = ListArtifactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listArtifacts(request);
    }

    public final ListArtifactsPagedResponse listArtifacts(LocationName parent) {
        ListArtifactsRequest request = ListArtifactsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listArtifacts(request);
    }

    public final ListArtifactsPagedResponse listArtifacts(String parent) {
        ListArtifactsRequest request = ListArtifactsRequest.newBuilder().setParent(parent).build();
        return this.listArtifacts(request);
    }

    public final ListArtifactsPagedResponse listArtifacts(ListArtifactsRequest request) {
        return (ListArtifactsPagedResponse)((Object)this.listArtifactsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListArtifactsRequest, ListArtifactsPagedResponse> listArtifactsPagedCallable() {
        return this.stub.listArtifactsPagedCallable();
    }

    public final UnaryCallable<ListArtifactsRequest, ListArtifactsResponse> listArtifactsCallable() {
        return this.stub.listArtifactsCallable();
    }

    public final Artifact getArtifact(ArtifactName name) {
        GetArtifactRequest request = GetArtifactRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getArtifact(request);
    }

    public final Artifact getArtifact(String name) {
        GetArtifactRequest request = GetArtifactRequest.newBuilder().setName(name).build();
        return this.getArtifact(request);
    }

    public final Artifact getArtifact(GetArtifactRequest request) {
        return (Artifact)this.getArtifactCallable().call((Object)request);
    }

    public final UnaryCallable<GetArtifactRequest, Artifact> getArtifactCallable() {
        return this.stub.getArtifactCallable();
    }

    public final HttpBody getArtifactContents(ArtifactName name) {
        GetArtifactContentsRequest request = GetArtifactContentsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getArtifactContents(request);
    }

    public final HttpBody getArtifactContents(String name) {
        GetArtifactContentsRequest request = GetArtifactContentsRequest.newBuilder().setName(name).build();
        return this.getArtifactContents(request);
    }

    public final HttpBody getArtifactContents(GetArtifactContentsRequest request) {
        return (HttpBody)this.getArtifactContentsCallable().call((Object)request);
    }

    public final UnaryCallable<GetArtifactContentsRequest, HttpBody> getArtifactContentsCallable() {
        return this.stub.getArtifactContentsCallable();
    }

    public final Artifact createArtifact(ApiDeploymentName parent, Artifact artifact, String artifactId) {
        CreateArtifactRequest request = CreateArtifactRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setArtifact(artifact).setArtifactId(artifactId).build();
        return this.createArtifact(request);
    }

    public final Artifact createArtifact(ApiName parent, Artifact artifact, String artifactId) {
        CreateArtifactRequest request = CreateArtifactRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setArtifact(artifact).setArtifactId(artifactId).build();
        return this.createArtifact(request);
    }

    public final Artifact createArtifact(ApiSpecName parent, Artifact artifact, String artifactId) {
        CreateArtifactRequest request = CreateArtifactRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setArtifact(artifact).setArtifactId(artifactId).build();
        return this.createArtifact(request);
    }

    public final Artifact createArtifact(ApiVersionName parent, Artifact artifact, String artifactId) {
        CreateArtifactRequest request = CreateArtifactRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setArtifact(artifact).setArtifactId(artifactId).build();
        return this.createArtifact(request);
    }

    public final Artifact createArtifact(LocationName parent, Artifact artifact, String artifactId) {
        CreateArtifactRequest request = CreateArtifactRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setArtifact(artifact).setArtifactId(artifactId).build();
        return this.createArtifact(request);
    }

    public final Artifact createArtifact(String parent, Artifact artifact, String artifactId) {
        CreateArtifactRequest request = CreateArtifactRequest.newBuilder().setParent(parent).setArtifact(artifact).setArtifactId(artifactId).build();
        return this.createArtifact(request);
    }

    public final Artifact createArtifact(CreateArtifactRequest request) {
        return (Artifact)this.createArtifactCallable().call((Object)request);
    }

    public final UnaryCallable<CreateArtifactRequest, Artifact> createArtifactCallable() {
        return this.stub.createArtifactCallable();
    }

    public final Artifact replaceArtifact(Artifact artifact) {
        ReplaceArtifactRequest request = ReplaceArtifactRequest.newBuilder().setArtifact(artifact).build();
        return this.replaceArtifact(request);
    }

    public final Artifact replaceArtifact(ReplaceArtifactRequest request) {
        return (Artifact)this.replaceArtifactCallable().call((Object)request);
    }

    public final UnaryCallable<ReplaceArtifactRequest, Artifact> replaceArtifactCallable() {
        return this.stub.replaceArtifactCallable();
    }

    public final void deleteArtifact(ArtifactName name) {
        DeleteArtifactRequest request = DeleteArtifactRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteArtifact(request);
    }

    public final void deleteArtifact(String name) {
        DeleteArtifactRequest request = DeleteArtifactRequest.newBuilder().setName(name).build();
        this.deleteArtifact(request);
    }

    public final void deleteArtifact(DeleteArtifactRequest request) {
        this.deleteArtifactCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteArtifactRequest, Empty> deleteArtifactCallable() {
        return this.stub.deleteArtifactCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListArtifactsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListArtifactsRequest, ListArtifactsResponse, Artifact, ListArtifactsPage, ListArtifactsFixedSizeCollection> {
        private ListArtifactsFixedSizeCollection(List<ListArtifactsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListArtifactsFixedSizeCollection createEmptyCollection() {
            return new ListArtifactsFixedSizeCollection(null, 0);
        }

        protected ListArtifactsFixedSizeCollection createCollection(List<ListArtifactsPage> pages, int collectionSize) {
            return new ListArtifactsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListArtifactsPage
    extends AbstractPage<ListArtifactsRequest, ListArtifactsResponse, Artifact, ListArtifactsPage> {
        private ListArtifactsPage(PageContext<ListArtifactsRequest, ListArtifactsResponse, Artifact> context, ListArtifactsResponse response) {
            super(context, (Object)response);
        }

        private static ListArtifactsPage createEmptyPage() {
            return new ListArtifactsPage(null, null);
        }

        protected ListArtifactsPage createPage(PageContext<ListArtifactsRequest, ListArtifactsResponse, Artifact> context, ListArtifactsResponse response) {
            return new ListArtifactsPage(context, response);
        }

        public ApiFuture<ListArtifactsPage> createPageAsync(PageContext<ListArtifactsRequest, ListArtifactsResponse, Artifact> context, ApiFuture<ListArtifactsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListArtifactsPagedResponse
    extends AbstractPagedListResponse<ListArtifactsRequest, ListArtifactsResponse, Artifact, ListArtifactsPage, ListArtifactsFixedSizeCollection> {
        public static ApiFuture<ListArtifactsPagedResponse> createAsync(PageContext<ListArtifactsRequest, ListArtifactsResponse, Artifact> context, ApiFuture<ListArtifactsResponse> futureResponse) {
            ApiFuture<ListArtifactsPage> futurePage = ListArtifactsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListArtifactsPagedResponse((ListArtifactsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListArtifactsPagedResponse(ListArtifactsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListArtifactsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApiDeploymentRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, ApiDeployment, ListApiDeploymentRevisionsPage, ListApiDeploymentRevisionsFixedSizeCollection> {
        private ListApiDeploymentRevisionsFixedSizeCollection(List<ListApiDeploymentRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApiDeploymentRevisionsFixedSizeCollection createEmptyCollection() {
            return new ListApiDeploymentRevisionsFixedSizeCollection(null, 0);
        }

        protected ListApiDeploymentRevisionsFixedSizeCollection createCollection(List<ListApiDeploymentRevisionsPage> pages, int collectionSize) {
            return new ListApiDeploymentRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApiDeploymentRevisionsPage
    extends AbstractPage<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, ApiDeployment, ListApiDeploymentRevisionsPage> {
        private ListApiDeploymentRevisionsPage(PageContext<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, ApiDeployment> context, ListApiDeploymentRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static ListApiDeploymentRevisionsPage createEmptyPage() {
            return new ListApiDeploymentRevisionsPage(null, null);
        }

        protected ListApiDeploymentRevisionsPage createPage(PageContext<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, ApiDeployment> context, ListApiDeploymentRevisionsResponse response) {
            return new ListApiDeploymentRevisionsPage(context, response);
        }

        public ApiFuture<ListApiDeploymentRevisionsPage> createPageAsync(PageContext<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, ApiDeployment> context, ApiFuture<ListApiDeploymentRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApiDeploymentRevisionsPagedResponse
    extends AbstractPagedListResponse<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, ApiDeployment, ListApiDeploymentRevisionsPage, ListApiDeploymentRevisionsFixedSizeCollection> {
        public static ApiFuture<ListApiDeploymentRevisionsPagedResponse> createAsync(PageContext<ListApiDeploymentRevisionsRequest, ListApiDeploymentRevisionsResponse, ApiDeployment> context, ApiFuture<ListApiDeploymentRevisionsResponse> futureResponse) {
            ApiFuture<ListApiDeploymentRevisionsPage> futurePage = ListApiDeploymentRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApiDeploymentRevisionsPagedResponse((ListApiDeploymentRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApiDeploymentRevisionsPagedResponse(ListApiDeploymentRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApiDeploymentRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApiDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApiDeploymentsRequest, ListApiDeploymentsResponse, ApiDeployment, ListApiDeploymentsPage, ListApiDeploymentsFixedSizeCollection> {
        private ListApiDeploymentsFixedSizeCollection(List<ListApiDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApiDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListApiDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListApiDeploymentsFixedSizeCollection createCollection(List<ListApiDeploymentsPage> pages, int collectionSize) {
            return new ListApiDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApiDeploymentsPage
    extends AbstractPage<ListApiDeploymentsRequest, ListApiDeploymentsResponse, ApiDeployment, ListApiDeploymentsPage> {
        private ListApiDeploymentsPage(PageContext<ListApiDeploymentsRequest, ListApiDeploymentsResponse, ApiDeployment> context, ListApiDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListApiDeploymentsPage createEmptyPage() {
            return new ListApiDeploymentsPage(null, null);
        }

        protected ListApiDeploymentsPage createPage(PageContext<ListApiDeploymentsRequest, ListApiDeploymentsResponse, ApiDeployment> context, ListApiDeploymentsResponse response) {
            return new ListApiDeploymentsPage(context, response);
        }

        public ApiFuture<ListApiDeploymentsPage> createPageAsync(PageContext<ListApiDeploymentsRequest, ListApiDeploymentsResponse, ApiDeployment> context, ApiFuture<ListApiDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApiDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListApiDeploymentsRequest, ListApiDeploymentsResponse, ApiDeployment, ListApiDeploymentsPage, ListApiDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListApiDeploymentsPagedResponse> createAsync(PageContext<ListApiDeploymentsRequest, ListApiDeploymentsResponse, ApiDeployment> context, ApiFuture<ListApiDeploymentsResponse> futureResponse) {
            ApiFuture<ListApiDeploymentsPage> futurePage = ListApiDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApiDeploymentsPagedResponse((ListApiDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApiDeploymentsPagedResponse(ListApiDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApiDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApiSpecRevisionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, ApiSpec, ListApiSpecRevisionsPage, ListApiSpecRevisionsFixedSizeCollection> {
        private ListApiSpecRevisionsFixedSizeCollection(List<ListApiSpecRevisionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApiSpecRevisionsFixedSizeCollection createEmptyCollection() {
            return new ListApiSpecRevisionsFixedSizeCollection(null, 0);
        }

        protected ListApiSpecRevisionsFixedSizeCollection createCollection(List<ListApiSpecRevisionsPage> pages, int collectionSize) {
            return new ListApiSpecRevisionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApiSpecRevisionsPage
    extends AbstractPage<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, ApiSpec, ListApiSpecRevisionsPage> {
        private ListApiSpecRevisionsPage(PageContext<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, ApiSpec> context, ListApiSpecRevisionsResponse response) {
            super(context, (Object)response);
        }

        private static ListApiSpecRevisionsPage createEmptyPage() {
            return new ListApiSpecRevisionsPage(null, null);
        }

        protected ListApiSpecRevisionsPage createPage(PageContext<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, ApiSpec> context, ListApiSpecRevisionsResponse response) {
            return new ListApiSpecRevisionsPage(context, response);
        }

        public ApiFuture<ListApiSpecRevisionsPage> createPageAsync(PageContext<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, ApiSpec> context, ApiFuture<ListApiSpecRevisionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApiSpecRevisionsPagedResponse
    extends AbstractPagedListResponse<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, ApiSpec, ListApiSpecRevisionsPage, ListApiSpecRevisionsFixedSizeCollection> {
        public static ApiFuture<ListApiSpecRevisionsPagedResponse> createAsync(PageContext<ListApiSpecRevisionsRequest, ListApiSpecRevisionsResponse, ApiSpec> context, ApiFuture<ListApiSpecRevisionsResponse> futureResponse) {
            ApiFuture<ListApiSpecRevisionsPage> futurePage = ListApiSpecRevisionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApiSpecRevisionsPagedResponse((ListApiSpecRevisionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApiSpecRevisionsPagedResponse(ListApiSpecRevisionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApiSpecRevisionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApiSpecsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApiSpecsRequest, ListApiSpecsResponse, ApiSpec, ListApiSpecsPage, ListApiSpecsFixedSizeCollection> {
        private ListApiSpecsFixedSizeCollection(List<ListApiSpecsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApiSpecsFixedSizeCollection createEmptyCollection() {
            return new ListApiSpecsFixedSizeCollection(null, 0);
        }

        protected ListApiSpecsFixedSizeCollection createCollection(List<ListApiSpecsPage> pages, int collectionSize) {
            return new ListApiSpecsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApiSpecsPage
    extends AbstractPage<ListApiSpecsRequest, ListApiSpecsResponse, ApiSpec, ListApiSpecsPage> {
        private ListApiSpecsPage(PageContext<ListApiSpecsRequest, ListApiSpecsResponse, ApiSpec> context, ListApiSpecsResponse response) {
            super(context, (Object)response);
        }

        private static ListApiSpecsPage createEmptyPage() {
            return new ListApiSpecsPage(null, null);
        }

        protected ListApiSpecsPage createPage(PageContext<ListApiSpecsRequest, ListApiSpecsResponse, ApiSpec> context, ListApiSpecsResponse response) {
            return new ListApiSpecsPage(context, response);
        }

        public ApiFuture<ListApiSpecsPage> createPageAsync(PageContext<ListApiSpecsRequest, ListApiSpecsResponse, ApiSpec> context, ApiFuture<ListApiSpecsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApiSpecsPagedResponse
    extends AbstractPagedListResponse<ListApiSpecsRequest, ListApiSpecsResponse, ApiSpec, ListApiSpecsPage, ListApiSpecsFixedSizeCollection> {
        public static ApiFuture<ListApiSpecsPagedResponse> createAsync(PageContext<ListApiSpecsRequest, ListApiSpecsResponse, ApiSpec> context, ApiFuture<ListApiSpecsResponse> futureResponse) {
            ApiFuture<ListApiSpecsPage> futurePage = ListApiSpecsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApiSpecsPagedResponse((ListApiSpecsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApiSpecsPagedResponse(ListApiSpecsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApiSpecsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApiVersionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApiVersionsRequest, ListApiVersionsResponse, ApiVersion, ListApiVersionsPage, ListApiVersionsFixedSizeCollection> {
        private ListApiVersionsFixedSizeCollection(List<ListApiVersionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApiVersionsFixedSizeCollection createEmptyCollection() {
            return new ListApiVersionsFixedSizeCollection(null, 0);
        }

        protected ListApiVersionsFixedSizeCollection createCollection(List<ListApiVersionsPage> pages, int collectionSize) {
            return new ListApiVersionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApiVersionsPage
    extends AbstractPage<ListApiVersionsRequest, ListApiVersionsResponse, ApiVersion, ListApiVersionsPage> {
        private ListApiVersionsPage(PageContext<ListApiVersionsRequest, ListApiVersionsResponse, ApiVersion> context, ListApiVersionsResponse response) {
            super(context, (Object)response);
        }

        private static ListApiVersionsPage createEmptyPage() {
            return new ListApiVersionsPage(null, null);
        }

        protected ListApiVersionsPage createPage(PageContext<ListApiVersionsRequest, ListApiVersionsResponse, ApiVersion> context, ListApiVersionsResponse response) {
            return new ListApiVersionsPage(context, response);
        }

        public ApiFuture<ListApiVersionsPage> createPageAsync(PageContext<ListApiVersionsRequest, ListApiVersionsResponse, ApiVersion> context, ApiFuture<ListApiVersionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApiVersionsPagedResponse
    extends AbstractPagedListResponse<ListApiVersionsRequest, ListApiVersionsResponse, ApiVersion, ListApiVersionsPage, ListApiVersionsFixedSizeCollection> {
        public static ApiFuture<ListApiVersionsPagedResponse> createAsync(PageContext<ListApiVersionsRequest, ListApiVersionsResponse, ApiVersion> context, ApiFuture<ListApiVersionsResponse> futureResponse) {
            ApiFuture<ListApiVersionsPage> futurePage = ListApiVersionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApiVersionsPagedResponse((ListApiVersionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApiVersionsPagedResponse(ListApiVersionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApiVersionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListApisFixedSizeCollection
    extends AbstractFixedSizeCollection<ListApisRequest, ListApisResponse, Api, ListApisPage, ListApisFixedSizeCollection> {
        private ListApisFixedSizeCollection(List<ListApisPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListApisFixedSizeCollection createEmptyCollection() {
            return new ListApisFixedSizeCollection(null, 0);
        }

        protected ListApisFixedSizeCollection createCollection(List<ListApisPage> pages, int collectionSize) {
            return new ListApisFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListApisPage
    extends AbstractPage<ListApisRequest, ListApisResponse, Api, ListApisPage> {
        private ListApisPage(PageContext<ListApisRequest, ListApisResponse, Api> context, ListApisResponse response) {
            super(context, (Object)response);
        }

        private static ListApisPage createEmptyPage() {
            return new ListApisPage(null, null);
        }

        protected ListApisPage createPage(PageContext<ListApisRequest, ListApisResponse, Api> context, ListApisResponse response) {
            return new ListApisPage(context, response);
        }

        public ApiFuture<ListApisPage> createPageAsync(PageContext<ListApisRequest, ListApisResponse, Api> context, ApiFuture<ListApisResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListApisPagedResponse
    extends AbstractPagedListResponse<ListApisRequest, ListApisResponse, Api, ListApisPage, ListApisFixedSizeCollection> {
        public static ApiFuture<ListApisPagedResponse> createAsync(PageContext<ListApisRequest, ListApisResponse, Api> context, ApiFuture<ListApisResponse> futureResponse) {
            ApiFuture<ListApisPage> futurePage = ListApisPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListApisPagedResponse((ListApisPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListApisPagedResponse(ListApisPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListApisFixedSizeCollection.createEmptyCollection());
        }
    }
}

