/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.appengine.v1.AuthorizedDomain;
import com.google.appengine.v1.AuthorizedDomainsClient;
import com.google.appengine.v1.ListAuthorizedDomainsRequest;
import com.google.appengine.v1.ListAuthorizedDomainsResponse;
import com.google.appengine.v1.stub.AuthorizedDomainsStub;
import com.google.appengine.v1.stub.GrpcAuthorizedDomainsStub;
import com.google.appengine.v1.stub.HttpJsonAuthorizedDomainsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AuthorizedDomainsStubSettings
extends StubSettings<AuthorizedDomainsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/appengine.admin").add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/cloud-platform.read-only").build();
    private final PagedCallSettings<ListAuthorizedDomainsRequest, ListAuthorizedDomainsResponse, AuthorizedDomainsClient.ListAuthorizedDomainsPagedResponse> listAuthorizedDomainsSettings;
    private static final PagedListDescriptor<ListAuthorizedDomainsRequest, ListAuthorizedDomainsResponse, AuthorizedDomain> LIST_AUTHORIZED_DOMAINS_PAGE_STR_DESC = new PagedListDescriptor<ListAuthorizedDomainsRequest, ListAuthorizedDomainsResponse, AuthorizedDomain>(){

        public String emptyToken() {
            return "";
        }

        public ListAuthorizedDomainsRequest injectToken(ListAuthorizedDomainsRequest payload, String token) {
            return ListAuthorizedDomainsRequest.newBuilder((ListAuthorizedDomainsRequest)payload).setPageToken(token).build();
        }

        public ListAuthorizedDomainsRequest injectPageSize(ListAuthorizedDomainsRequest payload, int pageSize) {
            return ListAuthorizedDomainsRequest.newBuilder((ListAuthorizedDomainsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAuthorizedDomainsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAuthorizedDomainsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AuthorizedDomain> extractResources(ListAuthorizedDomainsResponse payload) {
            return payload.getDomainsList() == null ? ImmutableList.of() : payload.getDomainsList();
        }
    };
    private static final PagedListResponseFactory<ListAuthorizedDomainsRequest, ListAuthorizedDomainsResponse, AuthorizedDomainsClient.ListAuthorizedDomainsPagedResponse> LIST_AUTHORIZED_DOMAINS_PAGE_STR_FACT = new PagedListResponseFactory<ListAuthorizedDomainsRequest, ListAuthorizedDomainsResponse, AuthorizedDomainsClient.ListAuthorizedDomainsPagedResponse>(){

        public ApiFuture<AuthorizedDomainsClient.ListAuthorizedDomainsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAuthorizedDomainsRequest, ListAuthorizedDomainsResponse> callable, ListAuthorizedDomainsRequest request, ApiCallContext context, ApiFuture<ListAuthorizedDomainsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AUTHORIZED_DOMAINS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AuthorizedDomainsClient.ListAuthorizedDomainsPagedResponse.createAsync((PageContext<ListAuthorizedDomainsRequest, ListAuthorizedDomainsResponse, AuthorizedDomain>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListAuthorizedDomainsRequest, ListAuthorizedDomainsResponse, AuthorizedDomainsClient.ListAuthorizedDomainsPagedResponse> listAuthorizedDomainsSettings() {
        return this.listAuthorizedDomainsSettings;
    }

    public AuthorizedDomainsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAuthorizedDomainsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAuthorizedDomainsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "appengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "appengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AuthorizedDomainsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AuthorizedDomainsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AuthorizedDomainsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AuthorizedDomainsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AuthorizedDomainsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listAuthorizedDomainsSettings = settingsBuilder.listAuthorizedDomainsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AuthorizedDomainsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListAuthorizedDomainsRequest, ListAuthorizedDomainsResponse, AuthorizedDomainsClient.ListAuthorizedDomainsPagedResponse> listAuthorizedDomainsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listAuthorizedDomainsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AUTHORIZED_DOMAINS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAuthorizedDomainsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AuthorizedDomainsStubSettings settings) {
            super((StubSettings)settings);
            this.listAuthorizedDomainsSettings = settings.listAuthorizedDomainsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listAuthorizedDomainsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AuthorizedDomainsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AuthorizedDomainsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AuthorizedDomainsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AuthorizedDomainsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AuthorizedDomainsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AuthorizedDomainsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AuthorizedDomainsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AuthorizedDomainsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(AuthorizedDomainsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(AuthorizedDomainsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listAuthorizedDomainsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListAuthorizedDomainsRequest, ListAuthorizedDomainsResponse, AuthorizedDomainsClient.ListAuthorizedDomainsPagedResponse> listAuthorizedDomainsSettings() {
            return this.listAuthorizedDomainsSettings;
        }

        public AuthorizedDomainsStubSettings build() throws IOException {
            return new AuthorizedDomainsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

