/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.batch.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.batch.v1alpha.BatchServiceClient;
import com.google.cloud.batch.v1alpha.CancelJobRequest;
import com.google.cloud.batch.v1alpha.CancelJobResponse;
import com.google.cloud.batch.v1alpha.CreateJobRequest;
import com.google.cloud.batch.v1alpha.CreateResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.DeleteJobRequest;
import com.google.cloud.batch.v1alpha.DeleteResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.GetJobRequest;
import com.google.cloud.batch.v1alpha.GetResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.GetTaskRequest;
import com.google.cloud.batch.v1alpha.Job;
import com.google.cloud.batch.v1alpha.ListJobsRequest;
import com.google.cloud.batch.v1alpha.ListJobsResponse;
import com.google.cloud.batch.v1alpha.ListResourceAllowancesRequest;
import com.google.cloud.batch.v1alpha.ListResourceAllowancesResponse;
import com.google.cloud.batch.v1alpha.ListTasksRequest;
import com.google.cloud.batch.v1alpha.ListTasksResponse;
import com.google.cloud.batch.v1alpha.OperationMetadata;
import com.google.cloud.batch.v1alpha.ResourceAllowance;
import com.google.cloud.batch.v1alpha.Task;
import com.google.cloud.batch.v1alpha.UpdateJobRequest;
import com.google.cloud.batch.v1alpha.UpdateResourceAllowanceRequest;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStub;
import com.google.cloud.batch.v1alpha.stub.BatchServiceStubSettings;
import com.google.cloud.batch.v1alpha.stub.GrpcBatchServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcBatchServiceStub
extends BatchServiceStub {
    private static final MethodDescriptor<CreateJobRequest, Job> createJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/CreateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/GetJob").setRequestMarshaller(ProtoUtils.marshaller((Message)GetJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteJobRequest, Operation> deleteJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/DeleteJob").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CancelJobRequest, Operation> cancelJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/CancelJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CancelJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateJobRequest, Job> updateJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/UpdateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/ListJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListJobsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetTaskRequest, Task> getTaskMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/GetTask").setRequestMarshaller(ProtoUtils.marshaller((Message)GetTaskRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Task.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListTasksRequest, ListTasksResponse> listTasksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/ListTasks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListTasksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListTasksResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/CreateResourceAllowance").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateResourceAllowanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ResourceAllowance.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/GetResourceAllowance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetResourceAllowanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ResourceAllowance.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/DeleteResourceAllowance").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteResourceAllowanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListResourceAllowancesRequest, ListResourceAllowancesResponse> listResourceAllowancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/ListResourceAllowances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListResourceAllowancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListResourceAllowancesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.batch.v1alpha.BatchService/UpdateResourceAllowance").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateResourceAllowanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ResourceAllowance.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateJobRequest, Job> createJobCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable;
    private final OperationCallable<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationCallable;
    private final UnaryCallable<CancelJobRequest, Operation> cancelJobCallable;
    private final OperationCallable<CancelJobRequest, CancelJobResponse, OperationMetadata> cancelJobOperationCallable;
    private final UnaryCallable<UpdateJobRequest, Job> updateJobCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, BatchServiceClient.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<GetTaskRequest, Task> getTaskCallable;
    private final UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable;
    private final UnaryCallable<ListTasksRequest, BatchServiceClient.ListTasksPagedResponse> listTasksPagedCallable;
    private final UnaryCallable<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceCallable;
    private final UnaryCallable<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceCallable;
    private final UnaryCallable<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceCallable;
    private final OperationCallable<DeleteResourceAllowanceRequest, Empty, OperationMetadata> deleteResourceAllowanceOperationCallable;
    private final UnaryCallable<ListResourceAllowancesRequest, ListResourceAllowancesResponse> listResourceAllowancesCallable;
    private final UnaryCallable<ListResourceAllowancesRequest, BatchServiceClient.ListResourceAllowancesPagedResponse> listResourceAllowancesPagedCallable;
    private final UnaryCallable<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, BatchServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBatchServiceStub create(BatchServiceStubSettings settings) throws IOException {
        return new GrpcBatchServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBatchServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcBatchServiceStub(BatchServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBatchServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBatchServiceStub(BatchServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBatchServiceStub(BatchServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBatchServiceCallableFactory());
    }

    protected GrpcBatchServiceStub(BatchServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings cancelJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(cancelJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateJobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("job.name", String.valueOf(request.getJob().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getTaskTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getTaskMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listTasksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listTasksMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createResourceAllowanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createResourceAllowanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getResourceAllowanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getResourceAllowanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteResourceAllowanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteResourceAllowanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listResourceAllowancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listResourceAllowancesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateResourceAllowanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateResourceAllowanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource_allowance.name", String.valueOf(request.getResourceAllowance().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createJobCallable = callableFactory.createUnaryCallable(createJobTransportSettings, settings.createJobSettings(), clientContext);
        this.getJobCallable = callableFactory.createUnaryCallable(getJobTransportSettings, settings.getJobSettings(), clientContext);
        this.deleteJobCallable = callableFactory.createUnaryCallable(deleteJobTransportSettings, settings.deleteJobSettings(), clientContext);
        this.deleteJobOperationCallable = callableFactory.createOperationCallable(deleteJobTransportSettings, settings.deleteJobOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.cancelJobCallable = callableFactory.createUnaryCallable(cancelJobTransportSettings, settings.cancelJobSettings(), clientContext);
        this.cancelJobOperationCallable = callableFactory.createOperationCallable(cancelJobTransportSettings, settings.cancelJobOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateJobCallable = callableFactory.createUnaryCallable(updateJobTransportSettings, settings.updateJobSettings(), clientContext);
        this.listJobsCallable = callableFactory.createUnaryCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.listJobsPagedCallable = callableFactory.createPagedCallable(listJobsTransportSettings, settings.listJobsSettings(), clientContext);
        this.getTaskCallable = callableFactory.createUnaryCallable(getTaskTransportSettings, settings.getTaskSettings(), clientContext);
        this.listTasksCallable = callableFactory.createUnaryCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.listTasksPagedCallable = callableFactory.createPagedCallable(listTasksTransportSettings, settings.listTasksSettings(), clientContext);
        this.createResourceAllowanceCallable = callableFactory.createUnaryCallable(createResourceAllowanceTransportSettings, settings.createResourceAllowanceSettings(), clientContext);
        this.getResourceAllowanceCallable = callableFactory.createUnaryCallable(getResourceAllowanceTransportSettings, settings.getResourceAllowanceSettings(), clientContext);
        this.deleteResourceAllowanceCallable = callableFactory.createUnaryCallable(deleteResourceAllowanceTransportSettings, settings.deleteResourceAllowanceSettings(), clientContext);
        this.deleteResourceAllowanceOperationCallable = callableFactory.createOperationCallable(deleteResourceAllowanceTransportSettings, settings.deleteResourceAllowanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listResourceAllowancesCallable = callableFactory.createUnaryCallable(listResourceAllowancesTransportSettings, settings.listResourceAllowancesSettings(), clientContext);
        this.listResourceAllowancesPagedCallable = callableFactory.createPagedCallable(listResourceAllowancesTransportSettings, settings.listResourceAllowancesSettings(), clientContext);
        this.updateResourceAllowanceCallable = callableFactory.createUnaryCallable(updateResourceAllowanceTransportSettings, settings.updateResourceAllowanceSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateJobRequest, Job> createJobCallable() {
        return this.createJobCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Operation> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    @Override
    public OperationCallable<DeleteJobRequest, Empty, OperationMetadata> deleteJobOperationCallable() {
        return this.deleteJobOperationCallable;
    }

    @Override
    public UnaryCallable<CancelJobRequest, Operation> cancelJobCallable() {
        return this.cancelJobCallable;
    }

    @Override
    public OperationCallable<CancelJobRequest, CancelJobResponse, OperationMetadata> cancelJobOperationCallable() {
        return this.cancelJobOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.updateJobCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, BatchServiceClient.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<GetTaskRequest, Task> getTaskCallable() {
        return this.getTaskCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, ListTasksResponse> listTasksCallable() {
        return this.listTasksCallable;
    }

    @Override
    public UnaryCallable<ListTasksRequest, BatchServiceClient.ListTasksPagedResponse> listTasksPagedCallable() {
        return this.listTasksPagedCallable;
    }

    @Override
    public UnaryCallable<CreateResourceAllowanceRequest, ResourceAllowance> createResourceAllowanceCallable() {
        return this.createResourceAllowanceCallable;
    }

    @Override
    public UnaryCallable<GetResourceAllowanceRequest, ResourceAllowance> getResourceAllowanceCallable() {
        return this.getResourceAllowanceCallable;
    }

    @Override
    public UnaryCallable<DeleteResourceAllowanceRequest, Operation> deleteResourceAllowanceCallable() {
        return this.deleteResourceAllowanceCallable;
    }

    @Override
    public OperationCallable<DeleteResourceAllowanceRequest, Empty, OperationMetadata> deleteResourceAllowanceOperationCallable() {
        return this.deleteResourceAllowanceOperationCallable;
    }

    @Override
    public UnaryCallable<ListResourceAllowancesRequest, ListResourceAllowancesResponse> listResourceAllowancesCallable() {
        return this.listResourceAllowancesCallable;
    }

    @Override
    public UnaryCallable<ListResourceAllowancesRequest, BatchServiceClient.ListResourceAllowancesPagedResponse> listResourceAllowancesPagedCallable() {
        return this.listResourceAllowancesPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateResourceAllowanceRequest, ResourceAllowance> updateResourceAllowanceCallable() {
        return this.updateResourceAllowanceCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, BatchServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

