/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.FormatOptions;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class ParquetOptions
extends FormatOptions {
    private static final long serialVersionUID = 1992L;
    private final Boolean enableListInference;
    private final Boolean enumAsString;

    public Boolean getEnableListInference() {
        return this.enableListInference;
    }

    public Boolean getEnumAsString() {
        return this.enumAsString;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    ParquetOptions(Builder builder) {
        super("PARQUET");
        this.enableListInference = builder.enableListInference;
        this.enumAsString = builder.enumAsString;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enableListInference", (Object)this.enableListInference).add("enumAsString", (Object)this.enumAsString).toString();
    }

    @Override
    public final int hashCode() {
        return Objects.hash(this.enableListInference, this.enumAsString);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(ParquetOptions.class)) {
            return false;
        }
        ParquetOptions other = (ParquetOptions)obj;
        return this.enableListInference == other.enableListInference && this.enumAsString == other.enumAsString;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static ParquetOptions fromPb(com.google.api.services.bigquery.model.ParquetOptions parquetOptions) {
        Builder builder = ParquetOptions.newBuilder();
        if (parquetOptions.getEnableListInference() != null) {
            builder.setEnableListInference(parquetOptions.getEnableListInference());
        }
        if (parquetOptions.getEnumAsString() != null) {
            builder.setEnumAsString(parquetOptions.getEnumAsString());
        }
        return builder.build();
    }

    com.google.api.services.bigquery.model.ParquetOptions toPb() {
        com.google.api.services.bigquery.model.ParquetOptions parquetOptions = new com.google.api.services.bigquery.model.ParquetOptions();
        if (this.enableListInference != null) {
            parquetOptions.setEnableListInference(this.enableListInference);
        }
        if (this.enumAsString != null) {
            parquetOptions.setEnumAsString(this.enumAsString);
        }
        return parquetOptions;
    }

    public static final class Builder {
        private Boolean enableListInference;
        private Boolean enumAsString;

        private Builder() {
        }

        private Builder(ParquetOptions parquetOptions) {
            this.enableListInference = parquetOptions.enableListInference;
            this.enumAsString = parquetOptions.enumAsString;
        }

        public Builder setEnableListInference(Boolean enableListInference) {
            this.enableListInference = enableListInference;
            return this;
        }

        public Builder setEnumAsString(Boolean enumAsString) {
            this.enumAsString = enumAsString;
            return this;
        }

        public ParquetOptions build() {
            return new ParquetOptions(this);
        }
    }
}

