package com.google.cloud.bigquery;

import com.google.api.core.BetaApi;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TimePartitioning extends TimePartitioning {

  private final TimePartitioning.Type type;

  @Nullable
  private final Long expirationMs;

  @Nullable
  private final String field;

  @Nullable
  private final Boolean requirePartitionFilter;

  private AutoValue_TimePartitioning(
      TimePartitioning.Type type,
      @Nullable Long expirationMs,
      @Nullable String field,
      @Nullable Boolean requirePartitionFilter) {
    this.type = type;
    this.expirationMs = expirationMs;
    this.field = field;
    this.requirePartitionFilter = requirePartitionFilter;
  }

  @Override
  public TimePartitioning.Type getType() {
    return type;
  }

  @Nullable
  @Override
  public Long getExpirationMs() {
    return expirationMs;
  }

  @BetaApi
  @Nullable
  @Override
  public String getField() {
    return field;
  }

  @BetaApi
  @Nullable
  @Override
  public Boolean getRequirePartitionFilter() {
    return requirePartitionFilter;
  }

  @Override
  public String toString() {
    return "TimePartitioning{"
        + "type=" + type + ", "
        + "expirationMs=" + expirationMs + ", "
        + "field=" + field + ", "
        + "requirePartitionFilter=" + requirePartitionFilter
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TimePartitioning) {
      TimePartitioning that = (TimePartitioning) o;
      return this.type.equals(that.getType())
          && (this.expirationMs == null ? that.getExpirationMs() == null : this.expirationMs.equals(that.getExpirationMs()))
          && (this.field == null ? that.getField() == null : this.field.equals(that.getField()))
          && (this.requirePartitionFilter == null ? that.getRequirePartitionFilter() == null : this.requirePartitionFilter.equals(that.getRequirePartitionFilter()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= (expirationMs == null) ? 0 : expirationMs.hashCode();
    h$ *= 1000003;
    h$ ^= (field == null) ? 0 : field.hashCode();
    h$ *= 1000003;
    h$ ^= (requirePartitionFilter == null) ? 0 : requirePartitionFilter.hashCode();
    return h$;
  }

  private static final long serialVersionUID = -8565064035346940951L;

  @Override
  public TimePartitioning.Builder toBuilder() {
    return new AutoValue_TimePartitioning.Builder(this);
  }

  static final class Builder extends TimePartitioning.Builder {
    private TimePartitioning.Type type;
    private Long expirationMs;
    private String field;
    private Boolean requirePartitionFilter;
    Builder() {
    }
    Builder(TimePartitioning source) {
      this.type = source.getType();
      this.expirationMs = source.getExpirationMs();
      this.field = source.getField();
      this.requirePartitionFilter = source.getRequirePartitionFilter();
    }
    @Override
    TimePartitioning.Builder setType(TimePartitioning.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public TimePartitioning.Builder setExpirationMs(Long expirationMs) {
      this.expirationMs = expirationMs;
      return this;
    }
    @Override
    public TimePartitioning.Builder setField(String field) {
      this.field = field;
      return this;
    }
    @Override
    public TimePartitioning.Builder setRequirePartitionFilter(Boolean requirePartitionFilter) {
      this.requirePartitionFilter = requirePartitionFilter;
      return this;
    }
    @Override
    public TimePartitioning build() {
      if (this.type == null) {
        String missing = " type";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TimePartitioning(
          this.type,
          this.expirationMs,
          this.field,
          this.requirePartitionFilter);
    }
  }

}
