/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.ConnectionWorker;
import com.google.cloud.bigquery.storage.v1.JsonToProtoMessage;
import com.google.cloud.bigquery.storage.v1.SchemaAwareStreamWriter;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.gson.JsonArray;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.json.JSONArray;

public class JsonStreamWriter
implements AutoCloseable {
    private final SchemaAwareStreamWriter<Object> schemaAwareStreamWriter;
    private static final String CLIENT_ID = "java-jsonwriter";

    private JsonStreamWriter(SchemaAwareStreamWriter.Builder<Object> builder) throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
        this.schemaAwareStreamWriter = builder.build();
    }

    public ApiFuture<AppendRowsResponse> append(JSONArray jsonArr) throws IOException, Descriptors.DescriptorValidationException {
        return this.schemaAwareStreamWriter.append((Iterable<Object>)jsonArr);
    }

    public ApiFuture<AppendRowsResponse> append(JSONArray jsonArr, long offset) throws IOException, Descriptors.DescriptorValidationException {
        return this.schemaAwareStreamWriter.append((Iterable<Object>)jsonArr, offset);
    }

    private JSONArray gsonToOrgJSON(JsonArray jsonArr) {
        return new JSONArray(jsonArr.toString());
    }

    public ApiFuture<AppendRowsResponse> append(JsonArray jsonArr) throws IOException, Descriptors.DescriptorValidationException {
        return this.append(jsonArr, -1L);
    }

    public ApiFuture<AppendRowsResponse> append(JsonArray jsonArr, long offset) throws IOException, Descriptors.DescriptorValidationException {
        return this.append(this.gsonToOrgJSON(jsonArr), offset);
    }

    public String getStreamName() {
        return this.schemaAwareStreamWriter.getStreamName();
    }

    public String getWriterId() {
        return this.schemaAwareStreamWriter.getWriterId();
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.schemaAwareStreamWriter.getDescriptor();
    }

    public String getLocation() {
        return this.schemaAwareStreamWriter.getLocation();
    }

    public long getInflightWaitSeconds() {
        return this.schemaAwareStreamWriter.getInflightWaitSeconds();
    }

    public Map<String, AppendRowsRequest.MissingValueInterpretation> getMissingValueInterpretationMap() {
        return this.schemaAwareStreamWriter.getMissingValueInterpretationMap();
    }

    public static Builder newBuilder(String streamOrTableName, TableSchema tableSchema) {
        return new Builder(SchemaAwareStreamWriter.newBuilder(streamOrTableName, tableSchema, JsonToProtoMessage.INSTANCE));
    }

    public static Builder newBuilder(String streamOrTableName, TableSchema tableSchema, BigQueryWriteClient client) {
        return new Builder(SchemaAwareStreamWriter.newBuilder(streamOrTableName, tableSchema, client, JsonToProtoMessage.INSTANCE));
    }

    public static Builder newBuilder(String streamOrTableName, BigQueryWriteClient client) {
        return new Builder(SchemaAwareStreamWriter.newBuilder(streamOrTableName, client, JsonToProtoMessage.INSTANCE));
    }

    public static void setMaxRequestCallbackWaitTime(Duration waitTime) {
        ConnectionWorker.MAXIMUM_REQUEST_CALLBACK_WAIT_TIME = waitTime;
    }

    @Override
    public void close() {
        this.schemaAwareStreamWriter.close();
    }

    public boolean isClosed() {
        return this.schemaAwareStreamWriter.isClosed();
    }

    public boolean isUserClosed() {
        return this.schemaAwareStreamWriter.isUserClosed();
    }

    public static final class Builder {
        private final SchemaAwareStreamWriter.Builder<Object> schemaAwareStreamWriterBuilder;

        private Builder(SchemaAwareStreamWriter.Builder<Object> schemaAwareStreamWriterBuilder) {
            this.schemaAwareStreamWriterBuilder = schemaAwareStreamWriterBuilder.setClientId(JsonStreamWriter.CLIENT_ID);
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.schemaAwareStreamWriterBuilder.setChannelProvider(channelProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.schemaAwareStreamWriterBuilder.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.schemaAwareStreamWriterBuilder.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            this.schemaAwareStreamWriterBuilder.setFlowControlSettings(flowControlSettings);
            return this;
        }

        public String getStreamName() {
            return this.schemaAwareStreamWriterBuilder.getStreamName();
        }

        public Builder setEndpoint(String endpoint) {
            this.schemaAwareStreamWriterBuilder.setEndpoint(endpoint);
            return this;
        }

        public Builder setTraceId(String traceId) {
            this.schemaAwareStreamWriterBuilder.setTraceId(traceId);
            return this;
        }

        public Builder setIgnoreUnknownFields(boolean ignoreUnknownFields) {
            this.schemaAwareStreamWriterBuilder.setIgnoreUnknownFields(ignoreUnknownFields);
            return this;
        }

        public Builder setReconnectAfter10M(boolean reconnectAfter10M) {
            return this;
        }

        public Builder setEnableConnectionPool(boolean enableConnectionPool) {
            this.schemaAwareStreamWriterBuilder.setEnableConnectionPool(enableConnectionPool);
            return this;
        }

        public Builder setLocation(String location) {
            this.schemaAwareStreamWriterBuilder.setLocation(location);
            return this;
        }

        public Builder setCompressorName(String compressorName) {
            this.schemaAwareStreamWriterBuilder.setCompressorName(compressorName);
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            this.schemaAwareStreamWriterBuilder.setRetrySettings(retrySettings);
            return this;
        }

        public Builder setEnableLatencyProfiler(boolean enableLatencyProfiler) {
            this.schemaAwareStreamWriterBuilder.setEnableLatencyProfiler(enableLatencyProfiler);
            return this;
        }

        public Builder setEnableOpenTelemetry(boolean enableOpenTelemetry) {
            this.schemaAwareStreamWriterBuilder.setEnableOpenTelemetry(enableOpenTelemetry);
            return this;
        }

        public Builder setDefaultMissingValueInterpretation(AppendRowsRequest.MissingValueInterpretation defaultMissingValueInterpretation) {
            this.schemaAwareStreamWriterBuilder.setDefaultMissingValueInterpretation(defaultMissingValueInterpretation);
            return this;
        }

        public Builder setMissingValueInterpretationMap(Map<String, AppendRowsRequest.MissingValueInterpretation> missingValueInterpretationMap) {
            this.schemaAwareStreamWriterBuilder.setMissingValueInterpretationMap(missingValueInterpretationMap);
            return this;
        }

        public JsonStreamWriter build() throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
            return new JsonStreamWriter(this.schemaAwareStreamWriterBuilder);
        }
    }
}

