/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BQTableSchemaToProtoDescriptor;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.Exceptions;
import com.google.cloud.bigquery.storage.v1.GetWriteStreamRequest;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchema;
import com.google.cloud.bigquery.storage.v1.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1.RequestProfiler;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.cloud.bigquery.storage.v1.ToProtoConverter;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.cloud.bigquery.storage.v1.WriteStreamView;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.rpc.Code;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SchemaAwareStreamWriter<T>
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(SchemaAwareStreamWriter.class.getName());
    private final BigQueryWriteClient client;
    private final String streamName;
    private final StreamWriter.Builder streamWriterBuilder;
    private final boolean ignoreUnknownFields;
    private final ToProtoConverter<T> toProtoConverter;
    private StreamWriter streamWriter;
    private Descriptors.Descriptor descriptor;
    private TableSchema tableSchema;
    private ProtoSchema protoSchema;
    private String CompressorName;
    private final boolean skipRefreshStreamWriter;
    private final RequestProfiler.RequestProfilerHook requestProfilerHook;

    private SchemaAwareStreamWriter(Builder<T> builder) throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException {
        this.descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor(((Builder)builder).tableSchema);
        this.streamWriterBuilder = ((Builder)builder).client == null ? StreamWriter.newBuilder(((Builder)builder).streamName) : StreamWriter.newBuilder(((Builder)builder).streamName, ((Builder)builder).client);
        this.protoSchema = ProtoSchemaConverter.convert(this.descriptor);
        this.client = ((Builder)builder).client;
        this.streamWriterBuilder.setWriterSchema(this.protoSchema);
        this.setStreamWriterSettings(((Builder)builder).channelProvider, ((Builder)builder).credentialsProvider, ((Builder)builder).executorProvider, ((Builder)builder).endpoint, ((Builder)builder).flowControlSettings, ((Builder)builder).traceId, ((Builder)builder).compressorName, ((Builder)builder).retrySettings);
        this.streamWriterBuilder.setEnableConnectionPool(((Builder)builder).enableConnectionPool);
        this.streamWriterBuilder.setLocation(((Builder)builder).location);
        this.streamWriterBuilder.setDefaultMissingValueInterpretation(((Builder)builder).defaultMissingValueInterpretation);
        this.streamWriterBuilder.setClientId(((Builder)builder).clientId);
        this.streamWriterBuilder.setEnableLatencyProfiler(((Builder)builder).enableRequestProfiler);
        this.requestProfilerHook = new RequestProfiler.RequestProfilerHook(((Builder)builder).enableRequestProfiler);
        if (((Builder)builder).enableRequestProfiler) {
            this.requestProfilerHook.startPeriodicalReportFlushing();
        }
        this.streamWriterBuilder.setEnableOpenTelemetry(((Builder)builder).enableOpenTelemetry);
        this.streamWriter = this.streamWriterBuilder.build();
        this.streamName = ((Builder)builder).streamName;
        this.tableSchema = ((Builder)builder).tableSchema;
        this.toProtoConverter = ((Builder)builder).toProtoConverter;
        this.ignoreUnknownFields = ((Builder)builder).ignoreUnknownFields;
        this.skipRefreshStreamWriter = ((Builder)builder).skipRefreshStreamWriter;
    }

    public ApiFuture<AppendRowsResponse> append(Iterable<T> items) throws IOException, Descriptors.DescriptorValidationException {
        String requestUniqueId = this.generateRequestUniqueId();
        this.requestProfilerHook.startOperation(RequestProfiler.OperationName.TOTAL_LATENCY, requestUniqueId);
        try {
            return this.appendWithUniqueId(items, -1L, requestUniqueId);
        }
        catch (Exception ex) {
            this.requestProfilerHook.endOperation(RequestProfiler.OperationName.TOTAL_LATENCY, requestUniqueId);
            throw ex;
        }
    }

    private void refreshWriter(TableSchema updatedSchema) throws Descriptors.DescriptorValidationException, IOException {
        Preconditions.checkNotNull((Object)updatedSchema, (Object)"updatedSchema is null.");
        LOG.info("Refresh internal writer due to schema update, stream: " + this.streamName);
        this.streamWriter.close();
        this.tableSchema = updatedSchema;
        this.descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor(updatedSchema);
        this.protoSchema = ProtoSchemaConverter.convert(this.descriptor);
        this.streamWriter = this.streamWriterBuilder.setWriterSchema(this.protoSchema).build();
    }

    private List<DynamicMessage> buildMessage(Iterable<T> items) throws InterruptedException, Descriptors.DescriptorValidationException, IOException {
        try {
            return this.toProtoConverter.convertToProtoMessage(this.descriptor, this.tableSchema, items, this.ignoreUnknownFields);
        }
        catch (Exceptions.RowIndexToErrorException ex) {
            if (!ex.hasDataUnknownError) {
                throw ex;
            }
            if (this.skipRefreshStreamWriter) {
                throw ex;
            }
            LOG.warning("Saw unknown field error during proto message conversin within error messages" + ex.rowIndexToErrorMessage + ", try to refresh the writer with updated schema, stream: " + this.streamName);
            GetWriteStreamRequest writeStreamRequest = GetWriteStreamRequest.newBuilder().setName(this.streamName).setView(WriteStreamView.FULL).build();
            WriteStream writeStream = this.client.getWriteStream(writeStreamRequest);
            this.refreshWriter(writeStream.getTableSchema());
            return this.toProtoConverter.convertToProtoMessage(this.descriptor, this.tableSchema, items, this.ignoreUnknownFields);
        }
    }

    public ApiFuture<AppendRowsResponse> append(Iterable<T> items, long offset) throws IOException, Descriptors.DescriptorValidationException {
        String requestUniqueId = this.generateRequestUniqueId();
        this.requestProfilerHook.startOperation(RequestProfiler.OperationName.TOTAL_LATENCY, requestUniqueId);
        try {
            return this.appendWithUniqueId(items, offset, requestUniqueId);
        }
        catch (Exception ex) {
            this.requestProfilerHook.endOperation(RequestProfiler.OperationName.TOTAL_LATENCY, requestUniqueId);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ApiFuture<AppendRowsResponse> appendWithUniqueId(Iterable<T> items, long offset, String requestUniqueId) throws Descriptors.DescriptorValidationException, IOException {
        SchemaAwareStreamWriter schemaAwareStreamWriter = this;
        synchronized (schemaAwareStreamWriter) {
            this.requestProfilerHook.startOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, requestUniqueId);
            ProtoRows.Builder rowsBuilder = ProtoRows.newBuilder();
            try {
                if (!this.skipRefreshStreamWriter && this.streamWriter.getUpdatedSchema() != null) {
                    this.refreshWriter(this.streamWriter.getUpdatedSchema());
                }
                Map<Object, Object> rowIndexToErrorMessage = new HashMap();
                try {
                    List<DynamicMessage> protoMessages = this.buildMessage(items);
                    for (DynamicMessage dynamicMessage : protoMessages) {
                        rowsBuilder.addSerializedRows(dynamicMessage.toByteString());
                    }
                }
                catch (Exceptions.RowIndexToErrorException exception) {
                    rowIndexToErrorMessage = exception.rowIndexToErrorMessage;
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                if (!rowIndexToErrorMessage.isEmpty()) {
                    throw new Exceptions.AppendSerializationError(Code.INVALID_ARGUMENT.getNumber(), "Append serialization failed for writer: " + this.streamName, this.streamName, rowIndexToErrorMessage);
                }
            }
            finally {
                this.requestProfilerHook.endOperation(RequestProfiler.OperationName.JSON_TO_PROTO_CONVERSION, requestUniqueId);
            }
            return this.streamWriter.appendWithUniqueId(rowsBuilder.build(), offset, requestUniqueId);
        }
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getWriterId() {
        return this.streamWriter.getWriterId();
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }

    public String getLocation() {
        return this.streamWriter.getLocation();
    }

    public long getInflightWaitSeconds() {
        return this.streamWriter.getInflightWaitSeconds();
    }

    public void setMissingValueInterpretationMap(Map<String, AppendRowsRequest.MissingValueInterpretation> missingValueInterpretationMap) {
        this.streamWriter.setMissingValueInterpretationMap(missingValueInterpretationMap);
    }

    public Map<String, AppendRowsRequest.MissingValueInterpretation> getMissingValueInterpretationMap() {
        return this.streamWriter.getMissingValueInterpretationMap();
    }

    private void setStreamWriterSettings(@Nullable TransportChannelProvider channelProvider, @Nullable CredentialsProvider credentialsProvider, @Nullable ExecutorProvider executorProvider, @Nullable String endpoint, @Nullable FlowControlSettings flowControlSettings, @Nullable String traceId, @Nullable String compressorName, @Nullable RetrySettings retrySettings) {
        if (channelProvider != null) {
            this.streamWriterBuilder.setChannelProvider(channelProvider);
        }
        if (credentialsProvider != null) {
            this.streamWriterBuilder.setCredentialsProvider(credentialsProvider);
        }
        if (executorProvider != null) {
            this.streamWriterBuilder.setExecutorProvider(executorProvider);
        }
        if (endpoint != null) {
            this.streamWriterBuilder.setEndpoint(endpoint);
        }
        if (traceId != null) {
            this.streamWriterBuilder.setTraceId(traceId);
        }
        if (flowControlSettings != null) {
            if (flowControlSettings.getMaxOutstandingRequestBytes() != null) {
                this.streamWriterBuilder.setMaxInflightBytes(flowControlSettings.getMaxOutstandingRequestBytes());
            }
            if (flowControlSettings.getMaxOutstandingElementCount() != null) {
                this.streamWriterBuilder.setMaxInflightRequests(flowControlSettings.getMaxOutstandingElementCount());
            }
            if (flowControlSettings.getLimitExceededBehavior() != null) {
                this.streamWriterBuilder.setLimitExceededBehavior(flowControlSettings.getLimitExceededBehavior());
            }
        }
        if (compressorName != null) {
            this.streamWriterBuilder.setCompressorName(compressorName);
        }
        if (retrySettings != null) {
            this.streamWriterBuilder.setRetrySettings(retrySettings);
        }
    }

    public static <T> Builder<T> newBuilder(String streamOrTableName, TableSchema tableSchema, ToProtoConverter<T> toProtoConverter) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamOrTableName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        Preconditions.checkNotNull(toProtoConverter, (Object)"ToProtoConverter is null.");
        return new Builder(streamOrTableName, tableSchema, null, toProtoConverter);
    }

    public static <T> Builder<T> newBuilder(String streamOrTableName, TableSchema tableSchema, BigQueryWriteClient client, ToProtoConverter<T> toProtoConverter) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamOrTableName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        Preconditions.checkNotNull((Object)client, (Object)"BigQuery client is null.");
        Preconditions.checkNotNull(toProtoConverter, (Object)"ToProtoConverter is null.");
        return new Builder(streamOrTableName, tableSchema, client, toProtoConverter);
    }

    public static <T> Builder<T> newBuilder(String streamOrTableName, BigQueryWriteClient client, ToProtoConverter<T> toProtoConverter) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamOrTableName is null.");
        Preconditions.checkNotNull((Object)client, (Object)"BigQuery client is null.");
        Preconditions.checkNotNull(toProtoConverter, (Object)"ToProtoConverter is null.");
        return new Builder(streamOrTableName, null, client, toProtoConverter);
    }

    @Override
    public void close() {
        this.streamWriter.close();
    }

    public boolean isClosed() {
        return this.streamWriter.isClosed();
    }

    public boolean isUserClosed() {
        return this.streamWriter.isUserClosed();
    }

    private String generateRequestUniqueId() {
        return this.getStreamName() + "-" + UUID.randomUUID().toString();
    }

    public static final class Builder<T> {
        private final String streamName;
        private final BigQueryWriteClient client;
        private final TableSchema tableSchema;
        private final boolean skipRefreshStreamWriter;
        private final ToProtoConverter<T> toProtoConverter;
        private TransportChannelProvider channelProvider;
        private CredentialsProvider credentialsProvider;
        private ExecutorProvider executorProvider;
        private FlowControlSettings flowControlSettings;
        private String endpoint;
        private String traceIdBase;
        private String traceId;
        private boolean ignoreUnknownFields = false;
        private boolean enableConnectionPool = false;
        private String location;
        private String compressorName;
        private RetrySettings retrySettings;
        private AppendRowsRequest.MissingValueInterpretation defaultMissingValueInterpretation = AppendRowsRequest.MissingValueInterpretation.MISSING_VALUE_INTERPRETATION_UNSPECIFIED;
        private String clientId;
        private boolean enableRequestProfiler = false;
        private boolean enableOpenTelemetry = false;
        private static final String streamPatternString = "(projects/[^/]+/datasets/[^/]+/tables/[^/]+)/streams/[^/]+";
        private static final String tablePatternString = "(projects/[^/]+/datasets/[^/]+/tables/[^/]+)";
        private static final String defaultStreamPatternString = "(projects/[^/]+/datasets/[^/]+/tables/[^/]+)/_default";
        private static final Pattern streamPattern = Pattern.compile("(projects/[^/]+/datasets/[^/]+/tables/[^/]+)/streams/[^/]+");
        private static final Pattern tablePattern = Pattern.compile("(projects/[^/]+/datasets/[^/]+/tables/[^/]+)");
        private static final Pattern defaultStreamPattern = Pattern.compile("(projects/[^/]+/datasets/[^/]+/tables/[^/]+)/_default");

        private Builder(String streamOrTableName, TableSchema tableSchema, BigQueryWriteClient client, ToProtoConverter<T> toProtoConverter) {
            Matcher streamMatcher = streamPattern.matcher(streamOrTableName);
            if (!streamMatcher.matches()) {
                Matcher tableMatcher = tablePattern.matcher(streamOrTableName);
                Matcher defaultStreamMatcher = defaultStreamPattern.matcher(streamOrTableName);
                if (!tableMatcher.matches() && !defaultStreamMatcher.matches()) {
                    throw new IllegalArgumentException("Invalid  name: " + streamOrTableName);
                }
                this.streamName = !tableMatcher.matches() && defaultStreamMatcher.matches() ? streamOrTableName : streamOrTableName + "/_default";
            } else {
                this.streamName = streamOrTableName;
            }
            this.client = client;
            if (tableSchema == null) {
                GetWriteStreamRequest writeStreamRequest = GetWriteStreamRequest.newBuilder().setName(this.getStreamName()).setView(WriteStreamView.FULL).build();
                WriteStream writeStream = this.client.getWriteStream(writeStreamRequest);
                this.tableSchema = writeStream.getTableSchema();
                this.location = writeStream.getLocation();
                this.skipRefreshStreamWriter = false;
            } else {
                this.tableSchema = tableSchema;
                this.skipRefreshStreamWriter = true;
            }
            this.toProtoConverter = toProtoConverter;
        }

        public Builder<T> setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider, (Object)"ChannelProvider is null.");
            return this;
        }

        public Builder<T> setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"CredentialsProvider is null.");
            return this;
        }

        public Builder<T> setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider, (Object)"ExecutorProvider is null.");
            return this;
        }

        public Builder<T> setFlowControlSettings(FlowControlSettings flowControlSettings) {
            this.flowControlSettings = (FlowControlSettings)Preconditions.checkNotNull((Object)flowControlSettings, (Object)"FlowControlSettings is null.");
            return this;
        }

        public String getStreamName() {
            return this.streamName;
        }

        public Builder<T> setEndpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"Endpoint is null.");
            return this;
        }

        public Builder<T> setTraceId(String traceId) {
            this.traceId = (String)Preconditions.checkNotNull((Object)traceId, (Object)"TraceId is null.");
            return this;
        }

        Builder<T> setClientId(String clientId) {
            this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"ClientId is null.");
            return this;
        }

        public Builder<T> setIgnoreUnknownFields(boolean ignoreUnknownFields) {
            this.ignoreUnknownFields = ignoreUnknownFields;
            return this;
        }

        public Builder<T> setEnableConnectionPool(boolean enableConnectionPool) {
            this.enableConnectionPool = enableConnectionPool;
            return this;
        }

        public Builder<T> setLocation(String location) {
            if (this.location != null && !this.location.equals(location)) {
                throw new IllegalArgumentException("Specified location " + location + " does not match the system value " + this.location);
            }
            this.location = location;
            return this;
        }

        public Builder<T> setCompressorName(String compressorName) {
            this.compressorName = compressorName;
            return this;
        }

        public Builder setDefaultMissingValueInterpretation(AppendRowsRequest.MissingValueInterpretation defaultMissingValueInterpretation) {
            this.defaultMissingValueInterpretation = defaultMissingValueInterpretation;
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            this.retrySettings = retrySettings;
            return this;
        }

        public Builder setEnableLatencyProfiler(boolean enableLatencyProfiler) {
            this.enableRequestProfiler = enableLatencyProfiler;
            return this;
        }

        public Builder setEnableOpenTelemetry(boolean enableOpenTelemetry) {
            this.enableOpenTelemetry = enableOpenTelemetry;
            return this;
        }

        public SchemaAwareStreamWriter<T> build() throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
            return new SchemaAwareStreamWriter(this);
        }
    }
}

