/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.stats;

import com.google.api.MonitoredResource;
import com.google.bigtable.veneer.repackaged.io.opencensus.exporter.metrics.util.MetricExporter;
import com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Metric;
import com.google.cloud.bigtable.stats.BigtableStackdriverExportUtils;
import com.google.cloud.monitoring.v3.MetricServiceClient;
import com.google.monitoring.v3.CreateTimeSeriesRequest;
import com.google.monitoring.v3.ProjectName;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

final class BigtableCreateTimeSeriesExporter
extends MetricExporter {
    private static final Logger logger = Logger.getLogger(BigtableCreateTimeSeriesExporter.class.getName());
    private final MetricServiceClient metricServiceClient;
    private final MonitoredResource gceOrGkeMonitoredResource;
    private final String clientId;

    BigtableCreateTimeSeriesExporter(MetricServiceClient metricServiceClient, MonitoredResource gceOrGkeMonitoredResource) {
        this.metricServiceClient = metricServiceClient;
        this.clientId = BigtableStackdriverExportUtils.getDefaultTaskValue();
        this.gceOrGkeMonitoredResource = gceOrGkeMonitoredResource;
    }

    @Override
    public void export(Collection<Metric> metrics) {
        Map<Object, Object> projectToTimeSeries = new HashMap();
        for (Metric metric : metrics) {
            if (!BigtableStackdriverExportUtils.shouldExportMetric(metric.getMetricDescriptor())) continue;
            projectToTimeSeries = metric.getTimeSeriesList().stream().collect(Collectors.groupingBy(timeSeries -> BigtableStackdriverExportUtils.getProjectId(metric.getMetricDescriptor(), timeSeries, this.gceOrGkeMonitoredResource), Collectors.mapping(timeSeries -> BigtableStackdriverExportUtils.convertTimeSeries(metric.getMetricDescriptor(), timeSeries, this.clientId, this.gceOrGkeMonitoredResource), Collectors.toList())));
            for (Map.Entry<Object, Object> entry : projectToTimeSeries.entrySet()) {
                ProjectName projectName = ProjectName.of((String)((String)entry.getKey()));
                CreateTimeSeriesRequest request = CreateTimeSeriesRequest.newBuilder().setName(projectName.toString()).addAllTimeSeries((Iterable)entry.getValue()).build();
                try {
                    this.metricServiceClient.createServiceTimeSeries(request);
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Exception thrown when exporting TimeSeries for projectName=" + projectName.getProject(), e);
                }
            }
        }
    }
}

