/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.stats;

import com.google.api.core.InternalApi;
import com.google.bigtable.veneer.repackaged.io.opencensus.stats.Stats;
import com.google.bigtable.veneer.repackaged.io.opencensus.stats.View;
import com.google.bigtable.veneer.repackaged.io.opencensus.stats.ViewManager;
import com.google.cloud.bigtable.stats.BuiltinViewConstants;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;

@InternalApi(value="For internal use only")
public class BuiltinViews {
    @VisibleForTesting
    static final ImmutableSet<View> BIGTABLE_BUILTIN_VIEWS = ImmutableSet.of((Object)BuiltinViewConstants.OPERATION_LATENCIES_VIEW, (Object)BuiltinViewConstants.ATTEMPT_LATENCIES_VIEW, (Object)BuiltinViewConstants.RETRY_COUNT_VIEW, (Object)BuiltinViewConstants.FIRST_RESPONSE_LATENCIES_VIEW, (Object)BuiltinViewConstants.SERVER_LATENCIES_VIEW, (Object)BuiltinViewConstants.CONNECTIVITY_ERROR_COUNT_VIEW, (Object[])new View[]{BuiltinViewConstants.APPLICATION_LATENCIES_VIEW, BuiltinViewConstants.THROTTLING_LATENCIES_VIEW});
    static final ImmutableSet<View> NON_BIGTABLE_BUILTIN_VIEWS = ImmutableSet.of((Object)BuiltinViewConstants.PER_CONNECTION_ERROR_COUNT_VIEW);

    @VisibleForTesting
    void registerPrivateViews(ViewManager viewManager) {
        for (View view : BIGTABLE_BUILTIN_VIEWS) {
            viewManager.registerView(view);
        }
        for (View view : NON_BIGTABLE_BUILTIN_VIEWS) {
            viewManager.registerView(view);
        }
    }

    public static void registerBigtableBuiltinViews() {
        ViewManager viewManager = Stats.getViewManager();
        for (View view : BIGTABLE_BUILTIN_VIEWS) {
            viewManager.registerView(view);
        }
        for (View view : NON_BIGTABLE_BUILTIN_VIEWS) {
            viewManager.registerView(view);
        }
    }
}

