/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub;

import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.data.v2.stub.SafeResponseObserver;

final class ConvertExceptionCallable<ReadRowsRequest, RowT>
extends ServerStreamingCallable<ReadRowsRequest, RowT> {
    private final ServerStreamingCallable<ReadRowsRequest, RowT> innerCallable;

    public ConvertExceptionCallable(ServerStreamingCallable<ReadRowsRequest, RowT> innerCallable) {
        this.innerCallable = innerCallable;
    }

    public void call(ReadRowsRequest request, ResponseObserver<RowT> responseObserver, ApiCallContext context) {
        ReadRowsConvertExceptionResponseObserver<RowT> observer = new ReadRowsConvertExceptionResponseObserver<RowT>(responseObserver);
        this.innerCallable.call(request, observer, context);
    }

    private Throwable convertException(Throwable t) {
        String error;
        if (t instanceof InternalException && t.getMessage() != null && ((error = t.getMessage().toLowerCase()).contains("rst_stream") || error.contains("rst stream"))) {
            return new InternalException(t, ((InternalException)t).getStatusCode(), true);
        }
        return t;
    }

    private class ReadRowsConvertExceptionResponseObserver<RowT>
    extends SafeResponseObserver<RowT> {
        private final ResponseObserver<RowT> outerObserver;

        ReadRowsConvertExceptionResponseObserver(ResponseObserver<RowT> outerObserver) {
            super(outerObserver);
            this.outerObserver = outerObserver;
        }

        @Override
        protected void onStartImpl(StreamController controller) {
            this.outerObserver.onStart(controller);
        }

        @Override
        protected void onResponseImpl(RowT response) {
            this.outerObserver.onResponse(response);
        }

        @Override
        protected void onErrorImpl(Throwable t) {
            this.outerObserver.onError(ConvertExceptionCallable.this.convertException(t));
        }

        @Override
        protected void onCompleteImpl() {
            this.outerObserver.onComplete();
        }
    }
}

