/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.LogicalViewName;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import javax.annotation.Nonnull;

public final class LogicalView {
    private final com.google.bigtable.admin.v2.LogicalView proto;

    @InternalApi
    public static LogicalView fromProto(@Nonnull com.google.bigtable.admin.v2.LogicalView proto) {
        return new LogicalView(proto);
    }

    private LogicalView(@Nonnull com.google.bigtable.admin.v2.LogicalView proto) {
        Preconditions.checkNotNull((Object)proto);
        Preconditions.checkArgument((!proto.getName().isEmpty() ? 1 : 0) != 0, (Object)"LogicalView must have a name");
        this.proto = proto;
    }

    public String getId() {
        LogicalViewName fullName = LogicalViewName.parse((String)this.proto.getName());
        return fullName.getLogicalView();
    }

    public String getInstanceId() {
        LogicalViewName fullName = (LogicalViewName)Verify.verifyNotNull((Object)LogicalViewName.parse((String)this.proto.getName()), (String)"Name can never be null", (Object[])new Object[0]);
        return fullName.getInstance();
    }

    public String getQuery() {
        return this.proto.getQuery();
    }

    @InternalApi
    public com.google.bigtable.admin.v2.LogicalView toProto() {
        return this.proto;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalView that = (LogicalView)o;
        return Objects.equal((Object)this.proto, (Object)that.proto);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.proto});
    }
}

