/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.api.core.InternalApi;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.metrics.Aggregation;
import io.opentelemetry.sdk.metrics.InstrumentSelector;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.View;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@InternalApi
public class BuiltinMetricsConstants {
    public static final AttributeKey<String> BIGTABLE_PROJECT_ID_KEY = AttributeKey.stringKey((String)"project_id");
    public static final AttributeKey<String> INSTANCE_ID_KEY = AttributeKey.stringKey((String)"instance");
    public static final AttributeKey<String> TABLE_ID_KEY = AttributeKey.stringKey((String)"table");
    public static final AttributeKey<String> CLUSTER_ID_KEY = AttributeKey.stringKey((String)"cluster");
    public static final AttributeKey<String> ZONE_ID_KEY = AttributeKey.stringKey((String)"zone");
    public static final AttributeKey<String> APP_PROFILE_KEY = AttributeKey.stringKey((String)"app_profile");
    public static final AttributeKey<Boolean> STREAMING_KEY = AttributeKey.booleanKey((String)"streaming");
    public static final AttributeKey<String> CLIENT_NAME_KEY = AttributeKey.stringKey((String)"client_name");
    static final AttributeKey<String> METHOD_KEY = AttributeKey.stringKey((String)"method");
    static final AttributeKey<String> STATUS_KEY = AttributeKey.stringKey((String)"status");
    static final AttributeKey<String> CLIENT_UID_KEY = AttributeKey.stringKey((String)"client_uid");
    public static final String OPERATION_LATENCIES_NAME = "operation_latencies";
    public static final String ATTEMPT_LATENCIES_NAME = "attempt_latencies";
    static final String RETRY_COUNT_NAME = "retry_count";
    static final String CONNECTIVITY_ERROR_COUNT_NAME = "connectivity_error_count";
    static final String SERVER_LATENCIES_NAME = "server_latencies";
    static final String FIRST_RESPONSE_LATENCIES_NAME = "first_response_latencies";
    static final String APPLICATION_BLOCKING_LATENCIES_NAME = "application_latencies";
    static final String REMAINING_DEADLINE_NAME = "remaining_deadline";
    static final String CLIENT_BLOCKING_LATENCIES_NAME = "throttling_latencies";
    static final String PER_CONNECTION_ERROR_COUNT_NAME = "per_connection_error_count";
    private static final Aggregation AGGREGATION_WITH_MILLIS_HISTOGRAM = Aggregation.explicitBucketHistogram((List)ImmutableList.of((Object)0.0, (Object)1.0, (Object)2.0, (Object)3.0, (Object)4.0, (Object)5.0, (Object)6.0, (Object)8.0, (Object)10.0, (Object)13.0, (Object)16.0, (Object)20.0, (Object[])new Double[]{25.0, 30.0, 40.0, 50.0, 65.0, 80.0, 100.0, 130.0, 160.0, 200.0, 250.0, 300.0, 400.0, 500.0, 650.0, 800.0, 1000.0, 2000.0, 5000.0, 10000.0, 20000.0, 50000.0, 100000.0, 200000.0, 400000.0, 800000.0, 1600000.0, 3200000.0}));
    private static final Aggregation AGGREGATION_PER_CONNECTION_ERROR_COUNT_HISTOGRAM = Aggregation.explicitBucketHistogram((List)ImmutableList.of((Object)1.0, (Object)2.0, (Object)4.0, (Object)8.0, (Object)16.0, (Object)32.0, (Object)64.0, (Object)125.0, (Object)250.0, (Object)500.0, (Object)1000.0, (Object)2000.0, (Object[])new Double[]{4000.0, 8000.0, 16000.0, 32000.0, 64000.0, 128000.0, 250000.0, 500000.0, 1000000.0}));
    public static final String METER_NAME = "bigtable.googleapis.com/internal/client/";
    static final Set<AttributeKey> COMMON_ATTRIBUTES = ImmutableSet.of(BIGTABLE_PROJECT_ID_KEY, INSTANCE_ID_KEY, TABLE_ID_KEY, APP_PROFILE_KEY, CLUSTER_ID_KEY, ZONE_ID_KEY, (Object[])new AttributeKey[]{METHOD_KEY, CLIENT_NAME_KEY});

    static void defineView(ImmutableMap.Builder<InstrumentSelector, View> viewMap, String id, Aggregation aggregation, InstrumentType type, String unit, Set<AttributeKey> attributes) {
        InstrumentSelector selector = InstrumentSelector.builder().setName(id).setMeterName(METER_NAME).setType(type).setUnit(unit).build();
        ImmutableSet attributesFilter = ImmutableSet.builder().addAll((Iterable)COMMON_ATTRIBUTES.stream().map(AttributeKey::getKey).collect(Collectors.toSet())).addAll((Iterable)attributes.stream().map(AttributeKey::getKey).collect(Collectors.toSet())).build();
        View view = View.builder().setName(METER_NAME + id).setAggregation(aggregation).setAttributeFilter((Set)attributesFilter).build();
        viewMap.put((Object)selector, (Object)view);
    }

    public static Map<InstrumentSelector, View> getAllViews() {
        ImmutableMap.Builder views = ImmutableMap.builder();
        BuiltinMetricsConstants.defineView((ImmutableMap.Builder<InstrumentSelector, View>)views, OPERATION_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES).add((Object[])new AttributeKey[]{STREAMING_KEY, STATUS_KEY}).build());
        BuiltinMetricsConstants.defineView((ImmutableMap.Builder<InstrumentSelector, View>)views, ATTEMPT_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES).add((Object[])new AttributeKey[]{STREAMING_KEY, STATUS_KEY}).build());
        BuiltinMetricsConstants.defineView((ImmutableMap.Builder<InstrumentSelector, View>)views, SERVER_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES).add(STATUS_KEY).build());
        BuiltinMetricsConstants.defineView((ImmutableMap.Builder<InstrumentSelector, View>)views, FIRST_RESPONSE_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES).add(STATUS_KEY).build());
        BuiltinMetricsConstants.defineView((ImmutableMap.Builder<InstrumentSelector, View>)views, APPLICATION_BLOCKING_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES).build());
        BuiltinMetricsConstants.defineView((ImmutableMap.Builder<InstrumentSelector, View>)views, CLIENT_BLOCKING_LATENCIES_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES).build());
        BuiltinMetricsConstants.defineView((ImmutableMap.Builder<InstrumentSelector, View>)views, RETRY_COUNT_NAME, Aggregation.sum(), InstrumentType.COUNTER, "1", (Set<AttributeKey>)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES).add(STATUS_KEY).build());
        BuiltinMetricsConstants.defineView((ImmutableMap.Builder<InstrumentSelector, View>)views, CONNECTIVITY_ERROR_COUNT_NAME, Aggregation.sum(), InstrumentType.COUNTER, "1", (Set<AttributeKey>)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES).add(STATUS_KEY).build());
        BuiltinMetricsConstants.defineView((ImmutableMap.Builder<InstrumentSelector, View>)views, PER_CONNECTION_ERROR_COUNT_NAME, AGGREGATION_PER_CONNECTION_ERROR_COUNT_HISTOGRAM, InstrumentType.HISTOGRAM, "1", (Set<AttributeKey>)ImmutableSet.builder().add((Object[])new AttributeKey[]{BIGTABLE_PROJECT_ID_KEY, INSTANCE_ID_KEY, APP_PROFILE_KEY, CLIENT_NAME_KEY}).build());
        BuiltinMetricsConstants.defineView((ImmutableMap.Builder<InstrumentSelector, View>)views, REMAINING_DEADLINE_NAME, AGGREGATION_WITH_MILLIS_HISTOGRAM, InstrumentType.HISTOGRAM, "ms", (Set<AttributeKey>)ImmutableSet.builder().addAll(COMMON_ATTRIBUTES).add((Object[])new AttributeKey[]{STREAMING_KEY, STATUS_KEY}).build());
        return views.build();
    }
}

