/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Address;
import com.google.cloud.compute.v1.AddressAggregatedList;
import com.google.cloud.compute.v1.AddressList;
import com.google.cloud.compute.v1.AddressesScopedList;
import com.google.cloud.compute.v1.AddressesSettings;
import com.google.cloud.compute.v1.AggregatedListAddressesRequest;
import com.google.cloud.compute.v1.DeleteAddressRequest;
import com.google.cloud.compute.v1.GetAddressRequest;
import com.google.cloud.compute.v1.InsertAddressRequest;
import com.google.cloud.compute.v1.ListAddressesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionSetLabelsRequest;
import com.google.cloud.compute.v1.SetLabelsAddressRequest;
import com.google.cloud.compute.v1.stub.AddressesStub;
import com.google.cloud.compute.v1.stub.AddressesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class AddressesClient
implements BackgroundResource {
    private final AddressesSettings settings;
    private final AddressesStub stub;

    public static final AddressesClient create() throws IOException {
        return AddressesClient.create(AddressesSettings.newBuilder().build());
    }

    public static final AddressesClient create(AddressesSettings settings) throws IOException {
        return new AddressesClient(settings);
    }

    public static final AddressesClient create(AddressesStub stub) {
        return new AddressesClient(stub);
    }

    protected AddressesClient(AddressesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AddressesStubSettings)settings.getStubSettings()).createStub();
    }

    protected AddressesClient(AddressesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AddressesSettings getSettings() {
        return this.settings;
    }

    public AddressesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListAddressesRequest request = AggregatedListAddressesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListAddressesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListAddressesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListAddressesRequest, AddressAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String address) {
        DeleteAddressRequest request = DeleteAddressRequest.newBuilder().setProject(project).setRegion(region).setAddress(address).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteAddressRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAddressRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteAddressRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Address get(String project, String region, String address) {
        GetAddressRequest request = GetAddressRequest.newBuilder().setProject(project).setRegion(region).setAddress(address).build();
        return this.get(request);
    }

    public final Address get(GetAddressRequest request) {
        return (Address)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetAddressRequest, Address> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, Address addressResource) {
        InsertAddressRequest request = InsertAddressRequest.newBuilder().setProject(project).setRegion(region).setAddressResource(addressResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertAddressRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertAddressRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertAddressRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListAddressesRequest request = ListAddressesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListAddressesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAddressesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListAddressesRequest, AddressList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> setLabelsAsync(String project, String region, String resource, RegionSetLabelsRequest regionSetLabelsRequestResource) {
        SetLabelsAddressRequest request = SetLabelsAddressRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetLabelsRequestResource(regionSetLabelsRequestResource).build();
        return this.setLabelsAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setLabelsAsync(SetLabelsAddressRequest request) {
        return this.setLabelsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetLabelsAddressRequest, Operation, Operation> setLabelsOperationCallable() {
        return this.stub.setLabelsOperationCallable();
    }

    public final UnaryCallable<SetLabelsAddressRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAddressesRequest, AddressList, Address, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListAddressesRequest, AddressList, Address, ListPage> {
        private ListPage(PageContext<ListAddressesRequest, AddressList, Address> context, AddressList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListAddressesRequest, AddressList, Address> context, AddressList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListAddressesRequest, AddressList, Address> context, ApiFuture<AddressList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListAddressesRequest, AddressList, Address, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListAddressesRequest, AddressList, Address> context, ApiFuture<AddressList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListAddressesRequest, AddressAggregatedList, Map.Entry<String, AddressesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListAddressesRequest, AddressAggregatedList, Map.Entry<String, AddressesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListAddressesRequest, AddressAggregatedList, Map.Entry<String, AddressesScopedList>> context, AddressAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListAddressesRequest, AddressAggregatedList, Map.Entry<String, AddressesScopedList>> context, AddressAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListAddressesRequest, AddressAggregatedList, Map.Entry<String, AddressesScopedList>> context, ApiFuture<AddressAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListAddressesRequest, AddressAggregatedList, Map.Entry<String, AddressesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListAddressesRequest, AddressAggregatedList, Map.Entry<String, AddressesScopedList>> context, ApiFuture<AddressAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

