/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionUrlMapRequest;
import com.google.cloud.compute.v1.GetRegionUrlMapRequest;
import com.google.cloud.compute.v1.InsertRegionUrlMapRequest;
import com.google.cloud.compute.v1.ListRegionUrlMapsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionUrlMapRequest;
import com.google.cloud.compute.v1.RegionUrlMapsSettings;
import com.google.cloud.compute.v1.RegionUrlMapsValidateRequest;
import com.google.cloud.compute.v1.UpdateRegionUrlMapRequest;
import com.google.cloud.compute.v1.UrlMap;
import com.google.cloud.compute.v1.UrlMapList;
import com.google.cloud.compute.v1.UrlMapsValidateResponse;
import com.google.cloud.compute.v1.ValidateRegionUrlMapRequest;
import com.google.cloud.compute.v1.stub.RegionUrlMapsStub;
import com.google.cloud.compute.v1.stub.RegionUrlMapsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionUrlMapsClient
implements BackgroundResource {
    private final RegionUrlMapsSettings settings;
    private final RegionUrlMapsStub stub;

    public static final RegionUrlMapsClient create() throws IOException {
        return RegionUrlMapsClient.create(RegionUrlMapsSettings.newBuilder().build());
    }

    public static final RegionUrlMapsClient create(RegionUrlMapsSettings settings) throws IOException {
        return new RegionUrlMapsClient(settings);
    }

    public static final RegionUrlMapsClient create(RegionUrlMapsStub stub) {
        return new RegionUrlMapsClient(stub);
    }

    protected RegionUrlMapsClient(RegionUrlMapsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionUrlMapsStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionUrlMapsClient(RegionUrlMapsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionUrlMapsSettings getSettings() {
        return this.settings;
    }

    public RegionUrlMapsStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String urlMap) {
        DeleteRegionUrlMapRequest request = DeleteRegionUrlMapRequest.newBuilder().setProject(project).setRegion(region).setUrlMap(urlMap).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionUrlMapRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionUrlMapRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionUrlMapRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final UrlMap get(String project, String region, String urlMap) {
        GetRegionUrlMapRequest request = GetRegionUrlMapRequest.newBuilder().setProject(project).setRegion(region).setUrlMap(urlMap).build();
        return this.get(request);
    }

    public final UrlMap get(GetRegionUrlMapRequest request) {
        return (UrlMap)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionUrlMapRequest, UrlMap> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, UrlMap urlMapResource) {
        InsertRegionUrlMapRequest request = InsertRegionUrlMapRequest.newBuilder().setProject(project).setRegion(region).setUrlMapResource(urlMapResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionUrlMapRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionUrlMapRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionUrlMapRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionUrlMapsRequest request = ListRegionUrlMapsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionUrlMapsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionUrlMapsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionUrlMapsRequest, UrlMapList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String urlMap, UrlMap urlMapResource) {
        PatchRegionUrlMapRequest request = PatchRegionUrlMapRequest.newBuilder().setProject(project).setRegion(region).setUrlMap(urlMap).setUrlMapResource(urlMapResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchRegionUrlMapRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRegionUrlMapRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchRegionUrlMapRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String region, String urlMap, UrlMap urlMapResource) {
        UpdateRegionUrlMapRequest request = UpdateRegionUrlMapRequest.newBuilder().setProject(project).setRegion(region).setUrlMap(urlMap).setUrlMapResource(urlMapResource).build();
        return this.updateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> updateAsync(UpdateRegionUrlMapRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRegionUrlMapRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateRegionUrlMapRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final UrlMapsValidateResponse validate(String project, String region, String urlMap, RegionUrlMapsValidateRequest regionUrlMapsValidateRequestResource) {
        ValidateRegionUrlMapRequest request = ValidateRegionUrlMapRequest.newBuilder().setProject(project).setRegion(region).setUrlMap(urlMap).setRegionUrlMapsValidateRequestResource(regionUrlMapsValidateRequestResource).build();
        return this.validate(request);
    }

    public final UrlMapsValidateResponse validate(ValidateRegionUrlMapRequest request) {
        return (UrlMapsValidateResponse)this.validateCallable().call((Object)request);
    }

    public final UnaryCallable<ValidateRegionUrlMapRequest, UrlMapsValidateResponse> validateCallable() {
        return this.stub.validateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionUrlMapsRequest, UrlMapList, UrlMap, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionUrlMapsRequest, UrlMapList, UrlMap, ListPage> {
        private ListPage(PageContext<ListRegionUrlMapsRequest, UrlMapList, UrlMap> context, UrlMapList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionUrlMapsRequest, UrlMapList, UrlMap> context, UrlMapList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionUrlMapsRequest, UrlMapList, UrlMap> context, ApiFuture<UrlMapList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionUrlMapsRequest, UrlMapList, UrlMap, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionUrlMapsRequest, UrlMapList, UrlMap> context, ApiFuture<UrlMapList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

