/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionTargetTcpProxyRequest;
import com.google.cloud.compute.v1.GetRegionTargetTcpProxyRequest;
import com.google.cloud.compute.v1.InsertRegionTargetTcpProxyRequest;
import com.google.cloud.compute.v1.ListRegionTargetTcpProxiesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionTargetTcpProxiesClient;
import com.google.cloud.compute.v1.TargetTcpProxy;
import com.google.cloud.compute.v1.TargetTcpProxyList;
import com.google.cloud.compute.v1.stub.HttpJsonRegionTargetTcpProxiesStub;
import com.google.cloud.compute.v1.stub.RegionTargetTcpProxiesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RegionTargetTcpProxiesStubSettings
extends StubSettings<RegionTargetTcpProxiesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<DeleteRegionTargetTcpProxyRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteRegionTargetTcpProxyRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetRegionTargetTcpProxyRequest, TargetTcpProxy> getSettings;
    private final UnaryCallSettings<InsertRegionTargetTcpProxyRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertRegionTargetTcpProxyRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, RegionTargetTcpProxiesClient.ListPagedResponse> listSettings;
    private static final PagedListDescriptor<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy>(){

        public String emptyToken() {
            return "";
        }

        public ListRegionTargetTcpProxiesRequest injectToken(ListRegionTargetTcpProxiesRequest payload, String token) {
            return ListRegionTargetTcpProxiesRequest.newBuilder((ListRegionTargetTcpProxiesRequest)payload).setPageToken(token).build();
        }

        public ListRegionTargetTcpProxiesRequest injectPageSize(ListRegionTargetTcpProxiesRequest payload, int pageSize) {
            return ListRegionTargetTcpProxiesRequest.newBuilder((ListRegionTargetTcpProxiesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListRegionTargetTcpProxiesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(TargetTcpProxyList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TargetTcpProxy> extractResources(TargetTcpProxyList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, RegionTargetTcpProxiesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, RegionTargetTcpProxiesClient.ListPagedResponse>(){

        public ApiFuture<RegionTargetTcpProxiesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList> callable, ListRegionTargetTcpProxiesRequest request, ApiCallContext context, ApiFuture<TargetTcpProxyList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RegionTargetTcpProxiesClient.ListPagedResponse.createAsync((PageContext<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, TargetTcpProxy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DeleteRegionTargetTcpProxyRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteRegionTargetTcpProxyRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetRegionTargetTcpProxyRequest, TargetTcpProxy> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertRegionTargetTcpProxyRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertRegionTargetTcpProxyRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, RegionTargetTcpProxiesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public RegionTargetTcpProxiesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRegionTargetTcpProxiesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RegionTargetTcpProxiesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RegionTargetTcpProxiesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RegionTargetTcpProxiesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RegionTargetTcpProxiesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DeleteRegionTargetTcpProxyRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteRegionTargetTcpProxyRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetRegionTargetTcpProxyRequest, TargetTcpProxy> getSettings;
        private final UnaryCallSettings.Builder<InsertRegionTargetTcpProxyRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertRegionTargetTcpProxyRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, RegionTargetTcpProxiesClient.ListPagedResponse> listSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings);
            Builder.initDefaults(this);
        }

        protected Builder(RegionTargetTcpProxiesStubSettings settings) {
            super((StubSettings)settings);
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RegionTargetTcpProxiesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RegionTargetTcpProxiesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RegionTargetTcpProxiesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RegionTargetTcpProxiesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(RegionTargetTcpProxiesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DeleteRegionTargetTcpProxyRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteRegionTargetTcpProxyRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRegionTargetTcpProxyRequest, TargetTcpProxy> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertRegionTargetTcpProxyRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<InsertRegionTargetTcpProxyRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListRegionTargetTcpProxiesRequest, TargetTcpProxyList, RegionTargetTcpProxiesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public RegionTargetTcpProxiesStubSettings build() throws IOException {
            return new RegionTargetTcpProxiesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

