/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListNetworkAttachmentsRequest;
import com.google.cloud.compute.v1.DeleteNetworkAttachmentRequest;
import com.google.cloud.compute.v1.GetIamPolicyNetworkAttachmentRequest;
import com.google.cloud.compute.v1.GetNetworkAttachmentRequest;
import com.google.cloud.compute.v1.InsertNetworkAttachmentRequest;
import com.google.cloud.compute.v1.ListNetworkAttachmentsRequest;
import com.google.cloud.compute.v1.NetworkAttachment;
import com.google.cloud.compute.v1.NetworkAttachmentAggregatedList;
import com.google.cloud.compute.v1.NetworkAttachmentList;
import com.google.cloud.compute.v1.NetworkAttachmentsScopedList;
import com.google.cloud.compute.v1.NetworkAttachmentsSettings;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicyNetworkAttachmentRequest;
import com.google.cloud.compute.v1.TestIamPermissionsNetworkAttachmentRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.NetworkAttachmentsStub;
import com.google.cloud.compute.v1.stub.NetworkAttachmentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class NetworkAttachmentsClient
implements BackgroundResource {
    private final NetworkAttachmentsSettings settings;
    private final NetworkAttachmentsStub stub;

    public static final NetworkAttachmentsClient create() throws IOException {
        return NetworkAttachmentsClient.create(NetworkAttachmentsSettings.newBuilder().build());
    }

    public static final NetworkAttachmentsClient create(NetworkAttachmentsSettings settings) throws IOException {
        return new NetworkAttachmentsClient(settings);
    }

    public static final NetworkAttachmentsClient create(NetworkAttachmentsStub stub) {
        return new NetworkAttachmentsClient(stub);
    }

    protected NetworkAttachmentsClient(NetworkAttachmentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((NetworkAttachmentsStubSettings)settings.getStubSettings()).createStub();
    }

    protected NetworkAttachmentsClient(NetworkAttachmentsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final NetworkAttachmentsSettings getSettings() {
        return this.settings;
    }

    public NetworkAttachmentsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListNetworkAttachmentsRequest request = AggregatedListNetworkAttachmentsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListNetworkAttachmentsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListNetworkAttachmentsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListNetworkAttachmentsRequest, NetworkAttachmentAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String networkAttachment) {
        DeleteNetworkAttachmentRequest request = DeleteNetworkAttachmentRequest.newBuilder().setProject(project).setRegion(region).setNetworkAttachment(networkAttachment).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteNetworkAttachmentRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteNetworkAttachmentRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteNetworkAttachmentRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final NetworkAttachment get(String project, String region, String networkAttachment) {
        GetNetworkAttachmentRequest request = GetNetworkAttachmentRequest.newBuilder().setProject(project).setRegion(region).setNetworkAttachment(networkAttachment).build();
        return this.get(request);
    }

    public final NetworkAttachment get(GetNetworkAttachmentRequest request) {
        return (NetworkAttachment)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetNetworkAttachmentRequest, NetworkAttachment> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String region, String resource) {
        GetIamPolicyNetworkAttachmentRequest request = GetIamPolicyNetworkAttachmentRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyNetworkAttachmentRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyNetworkAttachmentRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, NetworkAttachment networkAttachmentResource) {
        InsertNetworkAttachmentRequest request = InsertNetworkAttachmentRequest.newBuilder().setProject(project).setRegion(region).setNetworkAttachmentResource(networkAttachmentResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertNetworkAttachmentRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertNetworkAttachmentRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertNetworkAttachmentRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListNetworkAttachmentsRequest request = ListNetworkAttachmentsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListNetworkAttachmentsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListNetworkAttachmentsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListNetworkAttachmentsRequest, NetworkAttachmentList> listCallable() {
        return this.stub.listCallable();
    }

    public final Policy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyNetworkAttachmentRequest request = SetIamPolicyNetworkAttachmentRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyNetworkAttachmentRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyNetworkAttachmentRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsNetworkAttachmentRequest request = TestIamPermissionsNetworkAttachmentRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsNetworkAttachmentRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsNetworkAttachmentRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListNetworkAttachmentsRequest, NetworkAttachmentList, NetworkAttachment, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListNetworkAttachmentsRequest, NetworkAttachmentList, NetworkAttachment, ListPage> {
        private ListPage(PageContext<ListNetworkAttachmentsRequest, NetworkAttachmentList, NetworkAttachment> context, NetworkAttachmentList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListNetworkAttachmentsRequest, NetworkAttachmentList, NetworkAttachment> context, NetworkAttachmentList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListNetworkAttachmentsRequest, NetworkAttachmentList, NetworkAttachment> context, ApiFuture<NetworkAttachmentList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListNetworkAttachmentsRequest, NetworkAttachmentList, NetworkAttachment, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListNetworkAttachmentsRequest, NetworkAttachmentList, NetworkAttachment> context, ApiFuture<NetworkAttachmentList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListNetworkAttachmentsRequest, NetworkAttachmentAggregatedList, Map.Entry<String, NetworkAttachmentsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListNetworkAttachmentsRequest, NetworkAttachmentAggregatedList, Map.Entry<String, NetworkAttachmentsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListNetworkAttachmentsRequest, NetworkAttachmentAggregatedList, Map.Entry<String, NetworkAttachmentsScopedList>> context, NetworkAttachmentAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListNetworkAttachmentsRequest, NetworkAttachmentAggregatedList, Map.Entry<String, NetworkAttachmentsScopedList>> context, NetworkAttachmentAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListNetworkAttachmentsRequest, NetworkAttachmentAggregatedList, Map.Entry<String, NetworkAttachmentsScopedList>> context, ApiFuture<NetworkAttachmentAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListNetworkAttachmentsRequest, NetworkAttachmentAggregatedList, Map.Entry<String, NetworkAttachmentsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListNetworkAttachmentsRequest, NetworkAttachmentAggregatedList, Map.Entry<String, NetworkAttachmentsScopedList>> context, ApiFuture<NetworkAttachmentAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

