/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionHealthCheckRequest;
import com.google.cloud.compute.v1.GetRegionHealthCheckRequest;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.HealthCheckList;
import com.google.cloud.compute.v1.InsertRegionHealthCheckRequest;
import com.google.cloud.compute.v1.ListRegionHealthChecksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionHealthCheckRequest;
import com.google.cloud.compute.v1.RegionHealthChecksSettings;
import com.google.cloud.compute.v1.UpdateRegionHealthCheckRequest;
import com.google.cloud.compute.v1.stub.RegionHealthChecksStub;
import com.google.cloud.compute.v1.stub.RegionHealthChecksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionHealthChecksClient
implements BackgroundResource {
    private final RegionHealthChecksSettings settings;
    private final RegionHealthChecksStub stub;

    public static final RegionHealthChecksClient create() throws IOException {
        return RegionHealthChecksClient.create(RegionHealthChecksSettings.newBuilder().build());
    }

    public static final RegionHealthChecksClient create(RegionHealthChecksSettings settings) throws IOException {
        return new RegionHealthChecksClient(settings);
    }

    public static final RegionHealthChecksClient create(RegionHealthChecksStub stub) {
        return new RegionHealthChecksClient(stub);
    }

    protected RegionHealthChecksClient(RegionHealthChecksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionHealthChecksStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionHealthChecksClient(RegionHealthChecksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionHealthChecksSettings getSettings() {
        return this.settings;
    }

    public RegionHealthChecksStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String healthCheck) {
        DeleteRegionHealthCheckRequest request = DeleteRegionHealthCheckRequest.newBuilder().setProject(project).setRegion(region).setHealthCheck(healthCheck).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionHealthCheckRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionHealthCheckRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionHealthCheckRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final HealthCheck get(String project, String region, String healthCheck) {
        GetRegionHealthCheckRequest request = GetRegionHealthCheckRequest.newBuilder().setProject(project).setRegion(region).setHealthCheck(healthCheck).build();
        return this.get(request);
    }

    public final HealthCheck get(GetRegionHealthCheckRequest request) {
        return (HealthCheck)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionHealthCheckRequest, HealthCheck> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, HealthCheck healthCheckResource) {
        InsertRegionHealthCheckRequest request = InsertRegionHealthCheckRequest.newBuilder().setProject(project).setRegion(region).setHealthCheckResource(healthCheckResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionHealthCheckRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionHealthCheckRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionHealthCheckRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionHealthChecksRequest request = ListRegionHealthChecksRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionHealthChecksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionHealthChecksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionHealthChecksRequest, HealthCheckList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String healthCheck, HealthCheck healthCheckResource) {
        PatchRegionHealthCheckRequest request = PatchRegionHealthCheckRequest.newBuilder().setProject(project).setRegion(region).setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchRegionHealthCheckRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRegionHealthCheckRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchRegionHealthCheckRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String region, String healthCheck, HealthCheck healthCheckResource) {
        UpdateRegionHealthCheckRequest request = UpdateRegionHealthCheckRequest.newBuilder().setProject(project).setRegion(region).setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).build();
        return this.updateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> updateAsync(UpdateRegionHealthCheckRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRegionHealthCheckRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateRegionHealthCheckRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck, ListPage> {
        private ListPage(PageContext<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionHealthChecksRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

