package com.google.cloud;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Binding extends Binding {

  private final String role;

  private final ImmutableList<String> members;

  private final Condition condition;

  private AutoValue_Binding(
      String role,
      ImmutableList<String> members,
      @Nullable Condition condition) {
    this.role = role;
    this.members = members;
    this.condition = condition;
  }

  @Override
  public String getRole() {
    return role;
  }

  @Override
  public ImmutableList<String> getMembers() {
    return members;
  }

  @Nullable
  @Override
  public Condition getCondition() {
    return condition;
  }

  @Override
  public String toString() {
    return "Binding{"
        + "role=" + role + ", "
        + "members=" + members + ", "
        + "condition=" + condition
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Binding) {
      Binding that = (Binding) o;
      return this.role.equals(that.getRole())
          && this.members.equals(that.getMembers())
          && (this.condition == null ? that.getCondition() == null : this.condition.equals(that.getCondition()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= role.hashCode();
    h$ *= 1000003;
    h$ ^= members.hashCode();
    h$ *= 1000003;
    h$ ^= (condition == null) ? 0 : condition.hashCode();
    return h$;
  }

  @Override
  public Binding.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Binding.Builder {
    private String role;
    private ImmutableList<String> members;
    private Condition condition;
    Builder() {
    }
    private Builder(Binding source) {
      this.role = source.getRole();
      this.members = source.getMembers();
      this.condition = source.getCondition();
    }
    @Override
    public Binding.Builder setRole(String role) {
      if (role == null) {
        throw new NullPointerException("Null role");
      }
      this.role = role;
      return this;
    }
    @Override
    public Binding.Builder setMembers(Iterable<String> members) {
      this.members = ImmutableList.copyOf(members);
      return this;
    }
    @Override
    ImmutableList<String> getMembers() {
      if (members == null) {
        throw new IllegalStateException("Property \"members\" has not been set");
      }
      return members;
    }
    @Override
    public Binding.Builder setCondition(Condition condition) {
      this.condition = condition;
      return this;
    }
    @Override
    public Binding build() {
      if (this.role == null
          || this.members == null) {
        StringBuilder missing = new StringBuilder();
        if (this.role == null) {
          missing.append(" role");
        }
        if (this.members == null) {
          missing.append(" members");
        }
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Binding(
          this.role,
          this.members,
          this.condition);
    }
  }

}
